#include "setup.h"

static void GenCheckStart (fp)
FILE * fp;
{
	fprintf (fp, "\t%s(if test -f .target; \\\n",
		verbose_output ? "" : "@");
	fprintf (fp, "\t  then \\\n");
	fprintf (fp, "\t\tif test `cat .target` = xemp; \\\n");
	fprintf (fp, "\t\tthen \\\n");
}

static void GenCheckMiddle (fp)
FILE * fp;
{
	fprintf (fp, "\t\telse \\\n");
}

static void GenCheckEnd (fp)
FILE * fp;
{
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t  else \\\n");
	fprintf (fp, "\t\techo \"No target specified (yet)\"; \\\n");
	fprintf (fp, "\t\texit 1; \\\n");
	fprintf (fp, "\t  fi)\n");
}

void GenHeader (fp)
FILE * fp;
{
	Verbose ("Generating header\n");

	fprintf (fp, "#\tMakefile for xemp\n");
	fprintf (fp, "#\n");
	fprintf (fp, "#\tmake:\n");
	fprintf (fp, "#\t\txemp       - compiles xemp\n");
	fprintf (fp, "#\t\ttcemp      - compiles tcemp\n");
	fprintf (fp, "#\t\ttags       - makes tags file\n");
	fprintf (fp, "#\t\treply      - send a reply to %s\n", author);
	fprintf (fp, "#\t\tclean      - remove object and tags files\n");
	fprintf (fp, "#\t\tpack       - pack all sub directories\n");
	fprintf (fp, "#\t\tunpack     - unpack all sub directories\n");
	fprintf (fp, "#\t\tsetup      - compiles setup\n");
	fprintf (fp, "#\t\tproto      - compiles proto\n");
	fprintf (fp, "#\t\tproto.h    - creates a new proto-file\n");

	if (! just_tcemp && ! just_xemp)
	{
		fprintf (fp, "#\t\ttc_proto.h - creates proto.h\n");
		fprintf (fp, "#\t\tx_proto.h  - creates proto.h\n");
	}

	fprintf (fp, "#\t\tftp     - places a copy of xemp in ftp\n");
	fprintf (fp, "\n");
	fprintf (fp, "LDFLAGS= %s\n", lopts);
	fprintf (fp, "CC= %s\n", compiler);
	fprintf (fp, "CTAGS= %s\n", ctags);
	fprintf (fp, "\n");
	fprintf (fp, "AUTHOR= %s\n", author);
	fprintf (fp, "FTPDIR= %s\n", ftpdir);
	fprintf (fp, "\n");
}

static char * ToUpper (prefix, name)
char * prefix, * name;
{
	static char buffer [BUFSIZ];
	char * ptr;

	strcpy (buffer, prefix);
	ptr = buffer + strlen (buffer);
	while (* name != '\0')
		if (* name >= 'a' && * name <= 'z')
			* (ptr ++) = * (name ++) + 'A' - 'a';
		else
			* (ptr ++) = * (name ++);
	
	* ptr = '\0';
	return buffer;
}

static void GenDirsList (fp, dirs, name)
FILE * fp;
char ** dirs;
char * name;
{
	FILE * ls_fp;
	char ** dptr;
	char buf [BUFSIZ];

	fprintf (fp, "%s=", name);
	for (dptr = dirs; * dptr != (char *) 0; dptr ++)
	{
		ls_fp = popen (Fmt ("ls -1 %s/*.[hi]*",
			* dptr, * dptr), "r");

		while (fgets (buf, BUFSIZ, ls_fp) != (char *) 0)
		{
			buf [strlen (buf) - 1] = '\0';
			fprintf (fp, " \\\n\t%s", buf);
		}

		pclose (ls_fp);
	}
	fprintf (fp, "\n\n");
}

static void GenFileList (fp, files, name, change_to_objects)
FILE * fp;
char * files;
char * name;
bool change_to_objects;
{
	FILE * ls_fp;
	char buf [BUFSIZ];
	int len;

	ls_fp = popen (Fmt ("ls -1 %s", files), "r");

        if (ls_fp == (FILE *) 0)
		Error ("can't execute \"ls -1 %s\"\n", files);

	fprintf (fp, "%s=", name);

	while (fgets (buf, BUFSIZ, ls_fp) != (char *) 0)
	{
		len = strlen (buf);
		buf [-- len] = '\0';

			/*
			 *	Don't add version.c
			 *	This one should be compiled as last!
			 */

		if (strcmp (buf, "misc/version.c") == 0)
			continue;

		if (change_to_objects && strcmp (buf + len - 2, ".c") == 0)
			buf [len - 1] = 'o';

		fprintf (fp, " \\\n\t%s", buf);
	}

	fprintf (fp, "\n\n");
	pclose (ls_fp);
}

static void GenFindList (fp, dir, files, name)
FILE * fp;
char * dir, * files, * name;
{
	FILE * find_fp;
	char buf [1024];

	fprintf (fp, Fmt ("%s= ", name));

	find_fp = popen (Fmt ("find %s -name '%s' -print", dir, files), "r");
	if (find_fp == (FILE *) 0)
		Error (stderr, "Fatal error: Couldn't pipe find\n");
	
	while (fgets (buf, BUFSIZ, find_fp) != (char *) 0)
	{
		buf [strlen (buf) - 1] = '\0';
		fprintf (fp, " \\\n\t%s", buf);
	}

	fprintf (fp, "\n\n");
	pclose (find_fp);
}

void GenFiles (fp)
FILE * fp;
{
	char ** fptr;
	char include_files [BUFSIZ];

	fprintf (fp, "\nDIRS=");
	for (fptr = all_dirs; * fptr != (char *) 0; fptr ++)
		fprintf (fp, " \\\n\t%s", * fptr);
	fprintf (fp, "\n\n");

	Verbose ("Generating include list\n");
	if (just_tcemp)
	{
		GenDirsList (fp, tc_incl_dirs, "HFILES");
	}
	else if (just_xemp)
	{
		GenDirsList (fp, x_incl_dirs, "HFILES");
	}
	else
	{
		GenDirsList (fp, incl_dirs, "HFILES");
		GenDirsList (fp, x_incl_dirs, "X_HFILES");
		GenDirsList (fp, tc_incl_dirs, "TC_HFILES");
	}
	GenFileList (fp, "src/*/*.[ch]", "SRC_FILES", False);

	GenFindList (fp, "info", "*", "INFO");
	GenFindList (fp, "info.t", "*.t", "INFO_T");

	for (fptr = src_dirs; * fptr != (char *) 0; fptr ++)
	{
		Verbose ("Generating c-file list in %s\n", * fptr);
		GenFileList (fp, Fmt ("%s/*.c", * fptr),
				ToUpper ("C", * fptr), False);
	}

	for (fptr = src_dirs; * fptr != (char *) 0; fptr ++)
	{
		Verbose ("Generating o-file list in %s\n", * fptr);
		GenFileList (fp, Fmt ("%s/*.c", * fptr),
				ToUpper ("O", * fptr), True);
	}
}

static void Spec (fp, file, dep, extra_flags)
FILE * fp;
char * file, * dep, * extra_flags;
{
	fprintf (fp, "%s:\t", file);
	fprintf (fp, "%s\n", dep);
	if (verbose_output)
	{
		fprintf (fp, "\t$(CC) -c $(CFLAGS) %s $< $(INCLUDE)\n\n",
				extra_flags);
		fprintf (fp, "\t[ -f `basename $< .c`.o ] && mv -f ");
		fprintf (fp, "`basename $< .c`.o `dirname $<`\n");
	}
	else
	{
		fprintf (fp, "\t@echo compiling $<\n");
		fprintf (fp, "\t@$(CC) -c $(CFLAGS) %s $< $(INCLUDE)\n\n",
				extra_flags);
		fprintf (fp, "\t@[ -f `basename $< .c`.o ] && mv -f ");
		fprintf (fp, "`basename $< .c`.o `dirname $<`\n");
	}
}

void GenCheck (fp, str)
FILE * fp;
char * str;
{
	if (just_xemp || just_tcemp)
		return;

	fprintf (fp, "chk_%semp:\n", str);
	fprintf (fp, "\t%s(if test -f .target; \\\n",
		verbose_output ? "" : "@");
	fprintf (fp, "\t  then \\\n");
	fprintf (fp, "\t\tif test ! `cat .target` = %semp; \\\n", str);
	fprintf (fp, "\t\tthen \\\n");
	fprintf (fp, "\t\t\techo \"Wrong version.\"; \\\n");
	fprintf (fp, "\t\t\techo \"Run 'make cleanup' first.\"; \\\n");
	fprintf (fp, "\t\t\texit 1; \\\n");
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t  else \\\n");
	fprintf (fp, "\t\techo %semp > .target; \\\n", str);
	fprintf (fp, "\t  fi)\n\n");
}

void GenMisc (fp)
FILE * fp;
{
	char ** fptr;

	Verbose ("Miscellanious\n");

	if (just_tcemp)
	{
		fprintf (fp, "CALL= \\\n");
		for (fptr = tc_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("C", * fptr));
		fprintf (fp, "\tmisc/version.c\n\n");

		fprintf (fp, "OALL= \\\n");
		for (fptr = tc_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("O", * fptr));
		fprintf (fp, "\tmisc/version.o\n\n");
	}
	else if (just_xemp)
	{
		fprintf (fp, "CALL= \\\n");
		for (fptr = x_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("C", * fptr));
		fprintf (fp, "\tmisc/version.c\n\n");

		fprintf (fp, "OALL= \\\n");
		for (fptr = x_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("O", * fptr));
		fprintf (fp, "\tmisc/version.o\n\n");
	}
	else
	{
		fprintf (fp, "CALL= \\\n");
		for (fptr = src_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("C", * fptr));
		fprintf (fp, "\tmisc/version.c\n\n");

		fprintf (fp, "X_CALL= \\\n");
		for (fptr = x_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("C", * fptr));
		fprintf (fp, "\tmisc/version.c\n\n");
		
		fprintf (fp, "TC_CALL= \\\n");
		for (fptr = tc_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("C", * fptr));
		fprintf (fp, "\tmisc/version.c\n\n");

		fprintf (fp, "\n\nOALL= \\\n");
		for (fptr = src_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("O", * fptr));
		fprintf (fp, "\tmisc/version.o\n\n");

		fprintf (fp, "X_OALL= \\\n");
		for (fptr = x_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("O", * fptr));
		fprintf (fp, "\tmisc/version.o\n\n");
		
		fprintf (fp, "TC_OALL= \\\n");
		for (fptr = tc_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, "\t$(%s) \\\n", ToUpper ("O", * fptr));
		fprintf (fp, "\tmisc/version.o\n\n");
	}
	
	fprintf (fp, "\n\nCLIENTFLAGS= \\\n");
	fprintf (fp, "\t-DEMPIREHOST=\\\"%s\\\" \\\n", dhost);
	fprintf (fp, "\t-DEMPIREPORT=\\\"%s\\\"\n\n", dport);

	fprintf (fp, "MAINFLAGS= \\\n");
	fprintf (fp, "\t-DDEF_MAX_X=%d \\\n", def_max_x);
	fprintf (fp, "\t-DDEF_MAX_Y=%d\n\n", def_max_y);

	fprintf (fp, "VAROPTFLAGS=");
#ifdef INC_VSPRINTF
	fprintf (fp, " \\\n\t-DINC_VSPRINTF");
#endif /* INC_VSPRINTF */
#ifdef INC_GETOPT
	fprintf (fp, " \\\n\t-DINC_GETOPT");
#endif /* INC_GETOPT */
	fprintf (fp, "\n\n");

	fprintf (fp, "INFOFLAGS= \\\n");
	if (access ("/usr/include/sys/dirent.h") == 0)
		fprintf (fp, "\t-DDIRENT_INSYS \\\n");
	if (empinf != (char *) 0)
		fprintf (fp, "\t-DEMPINFO=\\\"%s\\\" \\\n", empinf);
	fprintf (fp, "\t-DXEMPINFO=\\\"%s\\\"\n\n", xempinf);

	if (just_tcemp || just_xemp)
	{
		if (just_xemp)
		{
			fprintf (fp, "INCLUDE=");
			for (fptr = x_incl_dirs; * fptr != (char *) 0; fptr ++)
				fprintf (fp, "-I%s ", * fptr);
			fprintf (fp, "\n");
			fprintf (fp, "CFLAGS=-DX_VERSION %s\n", copts);
			fprintf (fp, "LLIBS=-L%s\n", x11lib);
			fprintf (fp, "LIBS=-lX11 -lm\n\n");
		}
		else
		{
			fprintf (fp, "INCLUDE=");
			for (fptr = tc_incl_dirs; * fptr != (char *) 0; fptr ++)
				fprintf (fp, "-I%s ", * fptr);
			fprintf (fp, "\n");
			fprintf (fp, "CFLAGS=-DTERMC_VERSION %s\n", copts);
			fprintf (fp, "LIBS=-lm -ltermcap\n\n");
		}

		fprintf (fp, "%semp: $(OALL)\n", just_tcemp ? "tc" : "x");
		fprintf (fp, "\t@echo loading\n");
		fprintf (fp, "\t%srm -f %semp\n",
			verbose_output ? "" : "@",
			just_tcemp ? "tc" : "x");
		fprintf (fp, "\t%s$(CC) -o %semp $(LDFLAGS) $(OALL) ",
				verbose_output ? "" : "@",
				just_tcemp ? "tc" : "x");
		fprintf (fp, "$(LLIBS) $(LIBS)\n");
		fprintf (fp, "\t@echo \007%semp ready\n\n",
				just_tcemp ? "tc" : "x");
	}
	else
	{
		fprintf (fp, "target:\n");
		GenCheckStart (fp);
		fprintf (fp, "\t\t\tmake -f %s xemp; \\\n", makef);
		GenCheckMiddle (fp);
		fprintf (fp, "\t\t\tmake -f %s tcemp; \\\n", makef);
		GenCheckEnd (fp);
		fprintf (fp, "\n");

		fprintf (fp, "xemp:\tchk_xemp unpack\n");
		fprintf (fp, "\tmake -f %s \\\n", makef);
		fprintf (fp, "\t\tINCLUDE=\"");
		for (fptr = x_incl_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, " -I%s", * fptr);
		fprintf (fp, "\" \\\n");
		fprintf (fp, "\t\tCFLAGS=\"-DX_VERSION %s\" \\\n", copts);
		fprintf (fp, "\t\tLLIBS=\"-L%s\" \\\n", x11lib);
		fprintf (fp, "\t\tLIBS=\"-lX11 -lm\" \\\n");
		fprintf (fp, "\t\tX_xemp\n\n");

		fprintf (fp, "X_xemp:\t$(X_OALL)\n");
		fprintf (fp, "\t%srm -f xemp\n",
			verbose_output ? "" : "@");
		fprintf (fp, "\t@echo loading ...\n");
		fprintf (fp, "\t%s$(CC) -o xemp $(LDFLAGS) $(X_OALL) ",
			verbose_output ? "" : "@");
		fprintf (fp, "$(LLIBS) $(LIBS)\n");
		fprintf (fp, "\t@echo \007xemp ready\n\n");

		fprintf (fp, "tcemp:\tchk_tcemp unpack\n");
		fprintf (fp, "\tmake -f %s \\\n", makef);
		fprintf (fp, "\t\tINCLUDE=\"");
		for (fptr = tc_incl_dirs; * fptr != (char *) 0; fptr ++)
			fprintf (fp, " -I%s", * fptr);
		fprintf (fp, "\" \\\n");
		fprintf (fp, "\t\tCFLAGS=\"-DTERMC_VERSION %s\" \\\n", copts);
		fprintf (fp, "\t\tLLIBS=\"\" \\\n");
		fprintf (fp, "\t\tLIBS=\"-ltermcap -lm\" \\\n");
		fprintf (fp, "\t\tX_tcemp\n\n");

		fprintf (fp, "X_tcemp:\t$(TC_OALL)\n");
		fprintf (fp, "\t%srm -f tcemp\n",
			verbose_output ? "" : "@");
		fprintf (fp, "\t@echo loading ...\n");
		fprintf (fp, "\t%s$(CC) -o tcemp $(LDFLAGS) $(TC_OALL) ",
			verbose_output ? "" : "@");
		fprintf (fp, "$(LLIBS) $(LIBS)\n");
		fprintf (fp, "\t@echo \007tcemp ready\n\n");

		GenCheck (fp, "tc");
		GenCheck (fp, "x");
	}

	fprintf (fp, ".c.o:\n");
	if (! verbose_output)
		fprintf (fp, "\t@echo compiling $<\n");
	fprintf (fp, "\t%s$(CC) -c $(CFLAGS) $< $(INCLUDE)\n",
		verbose_output ? "" : "@");
	fprintf (fp, "\t%s[ -f `basename $< .c`.o ] && mv -f ",
		verbose_output ? "" : "@");
	fprintf (fp, "`basename $< .c`.o `dirname $<`\n\n");

	fprintf (fp, "misc/version.o: $(CALL)\n");
	if (! verbose_output)
		fprintf (fp, "\t@echo compiling misc/version.c\n");
	fprintf (fp, "\t%s$(CC) -c $(CFLAGS) -DCOM_DATE=\"\\\"`date`\\\"\" ",
			verbose_output ? "" : "@");
	fprintf (fp, "misc/version.c $(INCLUDE)\n");
	fprintf (fp, "\t%s[ -f version.o ] && mv -f version.o misc\n\n");

	/*
	Spec (fp, "misc/version.o", "$(CALL)", "-DCOM_DATE=\"\\\"`date`\\\"\"");
	*/

	Spec (fp, "misc/client.o", "misc/client.c", "$(CLIENTFLAGS)");
	Spec (fp, "misc/info.o", "misc/info.c", "$(INFOFLAGS)");
	Spec (fp, "data/help.o", "data/help.c", "$(INFOFLAGS)");
	Spec (fp, "misc/main.o", "misc/main.c", "$(MAINFLAGS)");
	Spec (fp, "misc/get_opt.o", "misc/get_opt.c", "$(VAROPTFLAGS)");
}

void GenTags (fp)
FILE * fp;
{
	if (just_tcemp || just_xemp)
	{
		fprintf (fp, "tags:	$(CALL)\n");
		if (! verbose_output)
			fprintf (fp, "\t@echo generating tags\n");
		fprintf (fp, "\t%s$(CTAGS) $(CALL) $(HFILES)\n\n",
			verbose_output ? "" : "@");
		return;
	}
	fprintf (fp, "tags:\tunpack $(CALL)\n");
	fprintf (fp, "\t@rm -f tags\n");
	GenCheckStart (fp);
	fprintf (fp, "\t\t\t$(CTAGS) $(X_CALL) $(X_HFILES); \\\n");
	GenCheckMiddle (fp);
	fprintf (fp, "\t\t\t$(CTAGS) $(TC_CALL) $(TC_HFILES); \\\n");
	GenCheckEnd (fp);
	fprintf (fp, "\n");
}

void GenReply (fp)
FILE * fp;
{
	fprintf (fp, "reply:\n");
	fprintf (fp, "\t@(temp=/tmp/.xemp.$$$$; \\\n");
	fprintf (fp, "\t $${EDITOR-vi} $$temp; \\\n");
	fprintf (fp, "\t while echo -n '(a)bort (e)dit (l)ist (s)end: '; \\\n");
	fprintf (fp, "\t do \\\n");
	fprintf (fp, "\t\tread action; \\\n");
	fprintf (fp, "\t\tcase $$action in \\\n");
	fprintf (fp, "\t\t\ta*)\texit;; \\\n");
	fprintf (fp, "\t\t\te*)\teval $${EDITOR-vi} $$temp;; \\\n");
	fprintf (fp, "\t\t\tl*)\t$${PAGER-more} $$temp;; \\\n");
	fprintf (fp, "\t\t\ts*)\tbreak; \\\n");
	fprintf (fp, "\t\tesac \\\n");
	fprintf (fp, "\t done; \\\n");
	fprintf (fp, "\t if test -f $$temp; then \\\n");
	fprintf (fp, "\t\tif test -s $$temp; then \\\n");
	fprintf (fp, "\t\t\tmail -s \"xemp: reply\" $(AUTHOR) < $$temp; \\\n");
	fprintf (fp, "\t\t\techo \"Message send\"; \\\n");
	fprintf (fp, "\t\telse \\\n");
	fprintf (fp, "\t\t\techo \"Empty body, nothing send\"; \\\n");
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t\trm $$temp; \\\n");
	fprintf (fp, "\t fi)\n\n");
}

void GenPack (fp)
FILE * fp;
{
	fprintf (fp, "pack:\n");
	fprintf (fp, "\t@(for i in $(DIRS) include icons; \\\n");
	fprintf (fp, "\t  do \\\n");
	fprintf (fp, "\t\techo -n $$i\": \"; \\\n");
	fprintf (fp, "\t\tif test -d $$i; then \\\n");
	fprintf (fp, "\t\t\ttar -cf $$i.t $$i; \\\n");
	fprintf (fp, "\t\t\tcompress $$i.t; \\\n");
	fprintf (fp, "\t\t\trm -rf $$i; \\\n");
	fprintf (fp, "\t\t\techo done; \\\n");
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t  done)\n\n");
}

void GenUnpack (fp)
FILE * fp;
{
	fprintf (fp, "unpack:\n");
	fprintf (fp, "\t@(for i in $(DIRS) include icons; \\\n");
	fprintf (fp, "\t\tdo \\\n");
	fprintf (fp, "\t\tif test -f $$i.t.Z; then \\\n");
	fprintf (fp, "\t\t\techo unpacking $$i; \\\n");
	fprintf (fp, "\t\t\tzcat $$i.t.Z | tar -xf -; \\\n");
	fprintf (fp, "\t\t\trm $$i.t.Z; \\\n");
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t  done)\n\n");
}

void GenSetup (fp)
FILE * fp;
{
	GenFileList (fp, "src/setup/*.c", "CSETUP", False);

	fprintf (fp, "setup:\t$(CSETUP)\n");
	fprintf (fp, "\t@(cd src/setup; \\\n");
	fprintf (fp, "\t  make; \\\n");
	fprintf (fp, "\t  make cleanup)\n\n");
}

void GenTryCap (fp)
FILE * fp;
{
	GenFileList (fp, "src/trycap/*.c", "CTRYCAP", False);

	fprintf (fp, "trycap:\t$(CTRYCAP)\n");
	fprintf (fp, "\t%s(cd src/trycap; \\\n",
		verbose_output ? "" : "@");
	fprintf (fp, "\t  make; \\\n");
	fprintf (fp, "\t  make cleanup)\n\n");
}

void GenFtp (fp)
FILE * fp;
{
	/* char ** dptr; */

	fprintf (fp, "FTP= \\\n");
	fprintf (fp, "\t$(CALL) \\\n");
	fprintf (fp, "\t$(HFILES) \\\n");
	fprintf (fp, "\tinfo \\\n");
	fprintf (fp, "\tinfo.t \\\n");
	fprintf (fp, "\tsrc \\\n");
	fprintf (fp, "\t.xemprc.def \\\n");
	fprintf (fp, "\tdoc \\\n");
	fprintf (fp, "\tmakefile \\\n");
	fprintf (fp, "\tTODO \\\n");
	fprintf (fp, "\tbin \\\n");
	fprintf (fp, "\tinstall \\\n");
	fprintf (fp, "\tprogs \\\n");
	fprintf (fp, "\tREADME \n\n");

	fprintf (fp, "ftp:\n");
	fprintf (fp, "\t@(echo -n extension? xemp; \\\n");
	fprintf (fp, "\t  read ans; \\\n");
	fprintf (fp, "\t  for i in $(FTP); \\\n");
	fprintf (fp, "\t  do \\\n");
	fprintf (fp, "\t\tFILES=$${FILES}\" xemp/$${i}\"; \\\n");
	fprintf (fp, "\t  done; \\\n");
	fprintf (fp, "\t  cd ..;\\\n");
	fprintf (fp, "\t  echo tar ...;\\\n");
	fprintf (fp, "\t  tar -cf $(FTPDIR)/xemp$${ans}.tar $${FILES}; \\\n");
	fprintf (fp, "\t  echo compress ...;\\\n");
	fprintf (fp, "\t  compress -f $(FTPDIR)/xemp$${ans}.tar; \\\n");
	fprintf (fp, "\t  ls -l $(FTPDIR)/xemp$${ans}.tar.Z)\n\n");
}

void GenDo (fp)
FILE * fp;
{
	fprintf (fp, "#\tUse the \"Do\" command in the bin-directory\n\n");

	fprintf (fp, "do:\n");
	fprintf (fp, "\t@(FILES=\"$(CALL)\"; \\\n");
	fprintf (fp, "\t  export FILES; \\\n");
	fprintf (fp, "\t  eval $${COMMAND})\n\n");

	fprintf (fp, "xdo:\n");
	fprintf (fp, "\t@(FILES=\"$(X_CALL)\"; \\\n");
	fprintf (fp, "\t  export FILES; \\\n");
	fprintf (fp, "\t  eval $${COMMAND})\n\n");

	fprintf (fp, "tcdo:\n");
	fprintf (fp, "\t@(FILES=\"$(TC_CALL)\"; \\\n");
	fprintf (fp, "\t  export FILES; \\\n");
	fprintf (fp, "\t  eval $${COMMAND})\n\n");
}

void GenProto (fp)
FILE * fp;
{
	fprintf (fp, "proto:\tsrc/proto/proto.c\n");
	fprintf (fp, "\tcc -O -s src/proto/proto.c -o proto\n\n");

	if (just_tcemp || just_xemp)
	{
		fprintf (fp, "proto.h:	$(CALL) proto\n");
		fprintf (fp, "\t%smv -f include/proto.h include/proto.h.old\n",
			verbose_output ? "" : "@");
		if (! verbose_output)
		{
			fprintf (fp, "\t@echo making proto.h\n");
			fprintf (fp, "\t@echo errors can be ingnored\n");
		}

		fprintf (fp, "\t%s./proto %s-f include/proto.h $(CALL)\n\n",
			verbose_output ? "" : "@",
			verbose_output ? "-v ": "");
		return;
	}
			
	fprintf (fp, "proto.h:\tunpack proto $(CALL)\n");
	fprintf (fp, "\t@(if test -f include/proto.h; \\\n");
	fprintf (fp, "\t  then \\\n");
	fprintf (fp, "\t\tmv -f include/proto.h include/proto.h.old; \\\n");
	fprintf (fp, "\t  fi; \\\n");
	fprintf (fp, "\t  if test -f .target; \\\n");
	fprintf (fp, "\t  then \\\n");
	fprintf (fp, "\t\tif test `cat .target` = tcemp; \\\n");
	fprintf (fp, "\t\tthen \\\n");
	fprintf (fp, "\t\t\t./proto -v -f include/proto.h $(TC_CALL); \\\n");
	fprintf (fp, "\t\telse \\\n");
	fprintf (fp, "\t\t\t./proto -v -f include/proto.h $(X_CALL); \\\n");
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t  else \\\n");
	fprintf (fp, "\t\techo \"Target not specified!\"; \\\n");
	fprintf (fp, "\t\techo \"Use: make tc_proto.h\"; \\\n");
	fprintf (fp, "\t\techo \" or: make x_proto.h\"; \\\n");
	fprintf (fp, "\t  fi)\n\n");

	fprintf (fp, "tc_proto.h:\tchk_tcemp proto.h\n\n");
	fprintf (fp, "x_proto.h:\tchk_xemp proto.h\n\n");
}

void GenPatch (fp)
FILE * fp;
{
	fprintf (fp, "PATCH= \\\n");
	fprintf (fp, "\t$(CALL) \\\n");
	fprintf (fp, "\t$(HFILES) \\\n");
	fprintf (fp, "\t$(SRC_FILES) \\\n");
	fprintf (fp, "\t$(INFO) \\\n");
	fprintf (fp, "\t.xemprc.def \\\n");
	fprintf (fp, "\tinfo/.help \\\n");
	fprintf (fp, "\tdoc \\\n");
	fprintf (fp, "\t$(INFO_T)\n\n");

	fprintf (fp, "patch:\n");
	fprintf (fp, "\t@(echo -n \"Diff against which directory: \"; \\\n");
	fprintf (fp, "\t  read olddir; \\\n");
	fprintf (fp, "\t  NEWF=\"\"; \\\n");
	fprintf (fp, "\t  echo Generating diffs......; \\\n");
	fprintf (fp, "\t  echo > patch; \\\n");
	fprintf (fp, "\t  for file in $(PATCH); \\\n");
	fprintf (fp, "\t  do \\\n");
	fprintf (fp, "\t\tif test ! -f $${olddir}/$${file} ");
	fprintf (fp, "-a ! -d $${olddir}/$${file}; \\\n");
	fprintf (fp, "\t\tthen \\\n");
	fprintf (fp, "\t\t\tNEWF=$${NEWF}\" $${file}\"; \\\n");
	fprintf (fp, "\t\telse \\\n");
	fprintf (fp, "\t\t\techo \"diff at $${file}\"; \\\n");
	fprintf (fp, "\t\t\t(diff -c5 -b $${olddir}/$${file} $${file} ");
	fprintf (fp, ">> patch || \\\n");
	fprintf (fp, "\t\t\t  (a=$$?; test $$a -eq 2 && a=1 || a=0; ");
	fprintf (fp, "exit $$a)); \\\n");
	fprintf (fp, "\t\tfi; \\\n");
	fprintf (fp, "\t  done; \\\n");
	fprintf (fp, "\t  ls -l patch; \\\n");
	fprintf (fp, "\t  if test ! \"X$${NEWF}\" = X; \\\n");
	fprintf (fp, "\t  then \\\n");
	fprintf (fp, "\t\ttar -cf newfiles.tar $${NEWF}; \\\n");
	fprintf (fp, "\t\tls -l newfiles.tar; \\\n");
	fprintf (fp, "\t  fi)\n\n");
}

void GenCleanup (fp)
FILE * fp;
{
	fprintf (fp, "cleanup:\n");
	fprintf (fp, "\t@echo removing object files.\n");
	fprintf (fp, "\t@rm -f $(OALL)\n");
	fprintf (fp, "\t@rm -f .target\n\n");
}

void GenAllDependencies (fp)
FILE * fp;
{
	FILE * ls_fp;
	char ** dptr;
	char buffer [BUFSIZ];

	for (dptr = src_dirs; * dptr != (char *) 0; dptr ++)
	{
		Verbose ("dependencies in %s\n", * dptr);
		ls_fp = popen (Fmt ("ls -1 %s/*.c", * dptr), "r");
		if (ls_fp == (FILE *) 0)
		{
			Error ("can execute 'ls -1 %s/*.c'\n", * dptr);
			exit (-1);
		}

		while (fgets (buffer, BUFSIZ, ls_fp) != (char *) 0)
		{
			buffer [strlen (buffer) -1] = '\0';
			Verbose ("\t%s:\n", buffer);
			PrintDepend (fp, buffer);
		}

		pclose (ls_fp);
	}
}
