#include "include.h"
#include "token.h"

#define MAX_BUFSIZ	1024

typedef struct s_tokenid
{
	File fp;
	char buf [MAX_BUFSIZ];
	char unget;
	bool buffered;
	int len;
	int linenr;
	char * filename;
}
	TOKENID;

TokenId NewTokenId (fp, filename)
File fp;
char * filename;
{
	TokenId new;

	new = (TokenId) malloc ((unsigned) sizeof (TOKENID));
	new-> fp = fp;
	new-> len = 0;
	new-> unget = '\0';
	new-> buffered = False;
	new-> filename = filename;
	new-> linenr = 0;

	return new;
}

static char TokenNextChar (tokenid)
TokenId tokenid;
{
	char ch;

	if (tokenid-> buffered)
	{
		ch = tokenid-> unget;
		tokenid-> buffered = False;
	}
	else
	{
		ch = getc (tokenid-> fp);
		if (ch == '\n')
			tokenid-> linenr ++;
	}

	tokenid-> buf [tokenid-> len] = ch;
	tokenid-> buf [++ tokenid-> len] = '\0';
	
	return ch;
}

static void TokenUnget (tokenid)
TokenId tokenid;
{
	tokenid-> buffered = True;
	tokenid-> unget = tokenid-> buf [tokenid-> len - 1];
	tokenid-> buf [-- tokenid-> len] = '\0';
}

static void TokenClearBuf (tokenid)
TokenId tokenid;
{
	tokenid-> len = 0;
	tokenid-> buf [0] = '\0';
}

int NextToken (tokenid)
TokenId tokenid;
{
	char ch, next_ch, prev_ch;

	TokenClearBuf (tokenid);

	ch = TokenNextChar (tokenid);
	switch (ch)
	{

	case EOF:
		return TOKEN_EOF;
	
	case '/':
		next_ch = TokenNextChar (tokenid);
		if (next_ch == '*')
			return TOKEN_START_COMMENT;
		TokenUnget (tokenid);
		return TOKEN_OTHER;
	
	case '*':
		next_ch = TokenNextChar (tokenid);
		if (next_ch == '/')
			return TOKEN_END_COMMENT;
		TokenUnget (tokenid);
		return TOKEN_OTHER;
		
	case '(':
		return TOKEN_BR_OPEN;
	
	case ')':
		return TOKEN_BR_CLOSE;

	case '"':
		prev_ch = '\0';
		do
		{
			next_ch = TokenNextChar (tokenid);
			if (next_ch == '"' && prev_ch != '\\')
				return TOKEN_STRING_CONST;
			if (prev_ch == next_ch && prev_ch == '\\')
				prev_ch ='\0';
			else
				prev_ch = next_ch;
		}
		while (next_ch != EOF);

		fprintf (stderr, "NextToken: Illegal string constant\n");
		fprintf (stderr, "File: %s  Line: %d\n",
			tokenid-> filename, tokenid-> linenr);
		exit (-1);

	case '\'':
		prev_ch = '\0';
		do
		{
			next_ch = TokenNextChar (tokenid);
			if (next_ch == '\'' && prev_ch != '\\')
				return TOKEN_CHAR_CONST;
			if (prev_ch == next_ch && prev_ch == '\\')
				prev_ch ='\0';
			else
				prev_ch = next_ch;
		}
		while (next_ch != EOF);

		fprintf (stderr, "NextToken: Illegal char constant\n");
		fprintf (stderr, "File: %s  Line: %d\n",
			tokenid-> filename, tokenid-> linenr);
		exit (-1);

	case ' ':
	case '\n':
	case '\t':
		do {
			next_ch = TokenNextChar (tokenid);
		}
			while (index (" \t\n", next_ch) != (char *) 0);
		TokenUnget (tokenid);
		return TOKEN_BLANK;
	
	}

	if ((ch >= 'a' && ch <= 'z') ||
	    (ch >= 'A' && ch <= 'Z') ||
	    (ch == '_'))
	{
		do {
			next_ch = TokenNextChar (tokenid);
		}
		while
			((next_ch >= 'a' && next_ch <= 'z') ||
			 (next_ch >= 'A' && next_ch <= 'Z') ||
			 (next_ch >= '0' && next_ch <= '9') ||
			 (next_ch == '_'));
		
		TokenUnget (tokenid);

		return TOKEN_IDENTIFIER;
	}

	return TOKEN_OTHER;
}

char * TokenBuffer (tokenid)
TokenId tokenid;
{
	return tokenid-> buf;
}
