#include <stdio.h>
#include "list.h"
#include "type.h"

#define	MAX_LEN		100

char ** SendArgs (list, groupname, subject)
List list;
char * groupname;
char * subject;
{
	char ** args;
	Group group;
	User user;
	int j;
	int i;

	group = GetGroup (list, groupname);
	if (group == (Group) 0)
	{
		fprintf (stderr, "Group '%s' doesn't exist.\n", groupname);
		return;
	}

	args = (char **) malloc ((UsersInGroup (group) +
		subject == (char *) 0 ? 2 : 4) *
					sizeof (char *));
	if (subject == (char *) 0)
	{
		args [0] = "send";
		i = 1;
	}
	else
	{
		args [0] = "mail";
		args [1] = "-s";
		args [2] = subject;
		i = 3;
	}

	j = i;
	for (user = FirstUser (group);
	     user != (User) 0;
	     user = NextUser (group))
		args [i ++] = UserAddress (user);

	if (i == j)
		return (char **) 0;

	args [i] = (char *) 0;
	return args;
}

void Send (list, groupname)
List list;
char * groupname;
{
	Group group;
	char ** args;

	args = SendArgs (list, groupname, (char *) 0);
	if (args == (char **) 0)
	{
		fprintf (stderr, "No users found in '%s'\n", groupname);
		return;
	}

	execvp ("send", args);
	perror ("execvp");
}
