#include "type.h"
#include "main.h"
#include "sector.h"
#include "nation.h"
#include "var.h"
#include "ship.h"
#include "plane.h"

ShType shiptypes [MAX_SHIPTYPES];

ShType nilship = {
	0, 0, 0, 0, 0, 1, 0, 0, 0, (char *) 0, 9999, 0, 9999, (long) ~M_KNOWN,
	{ 0, 999, 999, 999, 999, 999, 9999, 9999, 0, 9999, 9999, 9999, 9999,
	  9999, 0 },
};

Ship shiplist = (Ship) 0;

int FindShipTypeByName (name, must_exist)
char *name;
bool must_exist;
{
	register int i, j;
	int namelen;

	if (strncmp (name, "fishing ves", 11) == 0)
		name = "fishing boat";

	namelen = strlen(name);	/* Length of boat name */
	if (namelen > 13) namelen = 13; /* Only unique to 13 characters */

	for (i = 0; shiptypes [i]. nam != (char *) 0; i ++)
	{

/* TARL - only compare to length of name. */
	  if (strncmp (name, shiptypes[i].nam, namelen) == 0)
	    {
	      /* Determine if the name we are called with is better than */
	      /* name in database. If so, replace it. */
	      if (strlen(name) > strlen(shiptypes[i].nam)) {
		 free ((char *) shiptypes [i]. nam);
		 shiptypes [i]. nam = Str (name);
	       }
	    return i;
	    }
	}

	if (! must_exist)
		return -1;

	PrintAtEmpire (Fmt ("Ship \"%s\" not found in 'ship-types' list",
			name));
	Bell ();
	(void) EmpireMore ();

	shiptypes [i] = nilship;
	shiptypes [i]. nam = Str (name);
	if (isupper (*shiptypes [i]. nam))
		*shiptypes [i]. nam = tolower (*shiptypes [i]. nam);
	return i;
}


	/*
	 *	Set all values for the current ship. (radar range,
	 *	sonar range, id of the ship (to lookup into shiptypes).
	 *
	 *	I don't know why, but empire names a fishing boat and
	 *	a fishing trawler a fishing vessel. Since we don't know
	 *	what ship, we'll assume a fishing boat.
	 */

char *ShipName (ship)
Ship ship;
{
/* TARL - Don't do comparison unless name exists. Avoid faulting. */
  if (shiptypes[sh_type(ship)].nam)
	if (! sh_owned (ship) && StrEQ (shiptypes [sh_type (ship)]. nam,
						"fishing"))
		return ("fishing vessel");
	
	return (shiptypes [sh_type (ship)].  nam);
}

void SetShipValues (ship, ship_name)
Ship ship;
char *ship_name;
{
	int tf;

	set_sh_type (ship, FindShipTypeByName (ship_name, True));

		/* set radar/sonar range of the ship */

	if (! sh_owned (ship))
	{
		/* No way to tell which values */
		set_sh_radar (ship, 0);
		set_sh_sonar (ship, 0);
		return;
	}

	tf = (int) TechFact (sh_tech (ship),
			(double) shiptypes [sh_type (ship)].  spy);

	set_sh_radar (ship, 0.01 * (double) tf * (double) sh_eff (ship));

	if ((shiptypes [sh_type (ship)].  flags & M_SONAR) == M_SONAR)
		set_sh_sonar (ship, sh_radar (ship));
	else
		set_sh_sonar (ship, 0);
}

bool KnowsResoShip (ship)
Ship ship;
{
	if ((shiptypes [sh_type (ship)].  flags & M_FISH) == M_FISH)
		return True;
	if ((shiptypes [sh_type (ship)].  flags & M_OIL) == M_OIL)
		return True;
	return False;
}

bool ShipOnList (ship)
Ship ship;
{
	Ship ptr;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = sh_next (ptr))
		if (ptr == ship)
			return True;
	
	return False;
}

Ship NrToShip (nr)
int nr;
{
	Ship ptr;

	for (ptr = shiplist; ptr != (Ship) 0; ptr = sh_next (ptr))
		if (sh_nr (ptr) == nr)
			return ptr;
	
	return (Ship) 0;
}

void SetSectorShipsNr (sct)
Sector sct;
{
	Ship ptr;

	set_shi (sct, 0);
	for (ptr = s_fship (sct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
		inc_shi (sct);
}

void AddShipToSector (ship, to)
Ship ship;
Sector to;
{
	Ship ptr;

	if (! ShipOnList (ship))
	{
		fprintf (stderr,
			"AddShipToSector : ship not on global list ??\n");
		leave ();
	}

	set_sh_xcd (ship, s_xcd (to));
	set_sh_ycd (ship, s_ycd (to));

	(void) UpdateSectorDes (to, '.', False);

	for (ptr = s_fship (to); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
	{
		if (sh_nr (ptr) == sh_nr (ship))
		{
			if (ptr != ship)
			{
				/* impossible */
				DeleteShip (ptr);
				/* Restart Chain */
				ptr = s_fship (to);
			}
			else
			{
				/* Obviously ship is already in sector */
				SetSectorShipsNr (to);
				return;
			}
		}
	}

	set_sh_nxtsct (ship, s_fship (to));
	s_fship (to) = ship;
	SetSectorShipsNr (to);
}

void DeleteShipFromSector (ship)
Ship ship;
{
	register Ship ptr, prv;
	Sector from;

	from = World (sh_xcd (ship), sh_ycd (ship), S_DESIG);

	prv = (Ship) 0;
	for (ptr = s_fship (from); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
	{
		if (ptr == ship)
		{
			/* delete ship from sector */

			SetSectorShipsNr (from);
			s_shi (from) --;

			if (prv == (Ship) 0) 
				s_fship (from) = sh_nxtsct (ptr);
			else
				set_sh_nxtsct (prv, sh_nxtsct (ptr));

			return;
		}

		prv = ptr;
	}

	fprintf (stderr,
	"Internal error (DeleteShipFromSector): ship not found at it's pos.\n");
	leave ();
}

void MoveShip (ship, to)
Ship ship;
Sector to;
{
	Plane ptr, next;
	Sector old;

	if (ship == (Ship) 0)
		return;

	if (ShipHas (ship, M_PLANE) || ShipHas (ship, M_MISS))
	{
		old = ShipSector (ship);
		ptr = s_fplane (old);
		while (ptr != (Plane) 0)
			if (pl_shipnr (ptr) == sh_nr (ship))
			{
				next = pl_nxtsct (ptr);
				MovePlaneTo (ptr, to);
				ptr = next;
			}
			else
				ptr = pl_nxtsct (ptr);
	}

	DeleteShipFromSector (ship);
	AddShipToSector (ship, to);
}

void DeleteShip (ship)
Ship ship;
{
	register Ship ptr, prv;

	if (ship == (Ship) 0)
		return;

	/* from sector list */
	DeleteShipFromSector (ship);

	/* from global list */

	prv = (Ship) 0;
	for (ptr = shiplist; ptr != (Ship) 0; ptr = sh_next (ptr))
	{
		if (ptr == ship)
		{
			if (prv == (Ship) 0)
				shiplist = sh_next (shiplist);
			else
				set_sh_next (prv, sh_next (ship));

			if (ship == curship)
				curship = sh_nxtsct (curship);
			free ((char *) ship);
			return;
		}
		prv = ptr;
	}

	fprintf (stderr, "DeleteShip : ship not on global list ??\n");
	leave ();
}

void AddShipToList (ship)
Ship ship;
{
	Ship ptr;

	if (ship == (Ship) 0)
		return;

	if ((ptr = NrToShip (sh_nr (ship))) != (Ship) 0)
	{
		if (ptr == ship)
			/* obviously already there */
			return;
		else
		{
			if (ptr == curship)
				curship = ship;
			DeleteShip (ptr);
		}
	}

	set_sh_next (ship, shiplist);
	shiplist = ship;

}

char ShipCharInSector (sct)
Sector sct;
{
	Ship ship;
	char let;

	if ((ship = s_fship (sct)) == (Ship) 0)
		return s_des (sct);
	else
	{
		let = * ShipName (ship);
		return toupper (let);
	}
}

bool ShipAtSect (sct, let)
Sector sct;
char let;
{
	Ship ship;
	char slet;

	for (ship = s_fship (sct); ship != (Ship) 0; ship = sh_nxtsct (ship))
	{
		slet = * ShipName (ship);
		if (toupper (slet) == let)
			return True;
	}

	return False;
}

bool AddEnemyShip (x, y, nr, owner, ptr)
int x, y, nr, owner;
char *ptr;
{
	Ship new;
	Sector to;

	to = World (x, y, S_DESIG);

	if ((new = NrToShip (nr)) != (Ship) 0)
	{
		/* It's already on list just move it (Might not have moved) */
		if (owner != sh_owner (new))
		{
			PrintAtEmpire (Fmt (
				"%s (#%d) changed hands from %s to %s",
				ShipName (new), nr, CountryName (new-> owner),
				CountryName (owner)));
			set_sh_owner (new, owner);
		}

/* TARL - clear mark from above "we've already seen it" */
		set_sh_marked (new, False);

		if (sh_xcd (new) == x && sh_ycd (new) == y)
			return False;
		
		set_sh_oldpos (new, sh_xcd (new), sh_ycd (new));
		set_sh_time (new, time ((time_t *) 0));
		set_sh_marked (new, False);
		MoveShip (new, to);
		return True;
	}

	new = (Ship) doalloc ((unsigned) sizeof (struct s_ship));
	bzero (new, sizeof (struct s_ship));
	set_sh_owner (new, owner);
	set_sh_nr (new, nr);
	set_sh_fleet (new, '~');
	set_sh_time (new, (time_t) 0);
	set_sh_marked (new, False);
	SetShipValues (new, ptr);
	AddShipToList (new);
	AddShipToSector (new, to);
	return True;
}


int GiveShipQuant (ship, item)
Ship ship;
char item;
{
	if (ship == (Ship) 0)
	{
		fprintf (stderr, "GiveShipQuant : NIL ship ??\n");
		leave ();
	}

	switch (item)
	{

	case 'O': return sh_owner (ship);
	case 'F': return (int) sh_fleet (ship);   /* Ugly !! */
	case 'R': return sh_radar (ship);
	case 'S': return sh_sonar (ship);
	case 'N': return sh_nr (ship);
	case 'x': return sh_xcd(ship);
	case 'y': return sh_ycd (ship);
	case 't': return sh_type (ship);

	}

	if  (! deity && ! sh_owned (ship))
		return 0;

	switch (item)
	{

	case 'E': return sh_eff (ship);
	case 'T': return sh_tech (ship);
	case 'M': return sh_mob (ship);
	case 'P': return sh_pln (ship);
	case 'c': return sh_civ (ship);
	case 'm': return sh_mil (ship);
	case 'u': return sh_uw (ship);
	case 'f': return sh_foo (ship);
	case 's': return sh_she (ship);
	case 'g': return sh_gun (ship);
	case 'p': return sh_pet (ship);
	case 'i': return sh_iron (ship);
	case 'd': return sh_dust (ship);
	case 'b': return sh_bar (ship);
	case 'o': return sh_oil (ship);
	case 'l': return sh_lcm (ship);
	case 'h': return sh_hcm (ship);
	case 'r': return sh_rad (ship);
	default:  return 0;

	}
}


	/*
	 *	int MaxShipCargo (ship, item)
	 *		Returns the maximum number of item that can be
	 *		loaded onto the ship. I also added the 'P' for 
	 *		planes. (doesn't belong here I think).
	 */


int MaxShipCargo (ship, itemchar)
Ship ship;
char itemchar;
{
	int item;

	if (ship == (Ship) 0)
	{
		fprintf (stderr, "MaxShipCargo : NIL ship ??\n");
		leave ();
	}

	if (itemchar == 'P')
	{
		if ((shiptypes [sh_type (ship)].  flags & M_PLANE) == M_PLANE)
			return ksu_version ? shiptypes [sh_type (ship)]. pla
					   : 8;
		else
			return 0;
	}

	item = CharToItem (itemchar);
	return shiptypes [sh_type (ship)].  car [item];
}
	/*
	 *	char *GiveShipQuantStr (ship, id)
	 *		Returns a string containing the value of the id-field
	 *		Whenever the id is not supported on the ship (eg
	 *		radar, sonar or #lcm when the ship can't carry lcm's)
	 *		an empty string ("    ")  is returned.
	 *
	 *		The string will be four characters long and by
	 *		efficiency the %-character is also added.
	 *
	 *		One exception is made for the fleets in which case
	 *		a string of only one character is returned.
	 */

char * GiveShipQuantStr (ship, id)
Ship ship;
char id;
{
	int i;
	char *ptr;

	if (ship == (Ship) 0)
	{
		fprintf (stderr, "GiveShipQuantStr : NIL ship ??\n");
		leave ();
	}

	i = GiveShipQuant (ship, id);
	ptr = Fmt ("%-4d", i);

	switch (id)
	{

	case 'E':
		return Fmt ("%-3d%%", sh_eff (ship));
	case 'O':
	case 'N':
	case 'T':
	case 'M':
		return ptr;
	case 'S':
		if (sh_sonar (ship) > 0)
			return ptr;
		else
			return "--  ";
	case 'R':
		if (sh_radar (ship) > 0)
			return ptr;
		else
			return "--  ";
	case 'F':
		return Fmt (" %c  ", sh_fleet (ship));
	case 'P':
	case 'c':
	case 'm':
	case 'u':
	case 'f':
	case 's':
	case 'g':
	case 'p':
	case 'i':
	case 'd':
	case 'b':
	case 'o':
	case 'l':
	case 'h':
	case 'r':
		if (i > 0)
			return ptr;
		if (MaxShipCargo (ship, id) == 0)
			return "--  ";
		break;
	default:
		return "??  ";
	}
	return "    ";
}

void SetShipQuant (ship, item, value)
Ship ship;
char item;
int value;
{
	if (ship == (Ship) 0)
	{
		fprintf (stderr, "SetShipQuant : NIL ship ??\n");
		leave ();
	}

	if  (!deity && ! sh_owned (ship))
		return;

	switch (item)
	{

	case 'c': { set_sh_civ  (ship, value); break; }
	case 'm': { set_sh_mil  (ship, value); break; }
	case 'u': { set_sh_uw   (ship, value); break; }
	case 'f': { set_sh_foo  (ship, value); break; }
	case 's': { set_sh_she  (ship, value); break; }
	case 'g': { set_sh_gun  (ship, value); break; }
	case 'p': { set_sh_pet  (ship, value); break; }
	case 'i': { set_sh_iron (ship, value); break; }
	case 'd': { set_sh_dust (ship, value); break; }
	case 'b': { set_sh_bar  (ship, value); break; }
	case 'o': { set_sh_oil  (ship, value); break; }
	case 'l': { set_sh_lcm  (ship, value); break; }
	case 'h': { set_sh_hcm  (ship, value); break; }
	case 'r': { set_sh_rad  (ship, value); break; }
	case 'F': { set_sh_fleet (ship, value); break; }
	default:  
		if (! deity)
			return;
		switch (item) {
		case 'O': { set_sh_owner (ship, value); break; }
		case 'T': { set_sh_tech  (ship, value); break; }
		case 'E': { set_sh_eff   (ship, value); break; }
		case 'M': { set_sh_mob   (ship, value); break; }
		case 'P': { set_sh_pln   (ship, value); break; }
		default:  
			return;
		}
	}
}

bool ShipHasRadar (ship)
Ship ship;
{
	return (sh_radar (ship) >= 1);
}

bool ShipHasSonar (ship)
Ship ship;
{
	return (sh_sonar (ship) >= 1);
}

bool ShipHas (ship, flags)
Ship ship;
long flags;
{
        return BIT_SET (shiptypes [sh_type (ship)]. flags, flags);
}

void DeleteEnemyShips ()
{
	Ship ship, nship;

	for (ship = shiplist; ship != (Ship) 0; ship = nship)
	{
		nship = sh_next (ship);
		if (sh_owner (ship) != my_cnum)
			DeleteShip (ship);
	}
}

Ship AskShip (x, y, quest, allow_others)
int x, y;
char *quest;
bool allow_others;
{
	Strings strings;
	Pager pager;
	Ship ship;
	int select;

	strings = InitStrings ();

	for (ship = shiplist; ship != (Ship) 0; ship = sh_next (ship))
	{
		if (! allow_others && ! deity && sh_owner (ship) != my_cnum)
			continue;
		AddStringID (strings, Fmt ("#%d @%d,%d %-18s%s",
						sh_nr (ship),
						sh_xcd (ship), sh_ycd (ship),
						ShipName (ship),
					deity ? Fmt (" owner %s", 
						CountryName (sh_owner (ship)))
					        : ""), sh_nr (ship));
	}
	if (StringsSize (strings) == 0)
	{
		FreeStrings (strings);
		Message ("No Ships !!");
		Bell ();
		return ((Ship) 0);
	}

	pager = InitPager (strings, quest);
	MapPagerFromTop (pager, map_win, x, y);
	select = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (select < 0)
		return ((Ship) 0);

	return NrToShip (select);
}

void FleetAdd (x, y)
int x, y;
{
	char first_free;
	char * quest;
	char * ans;
	char * ships;
	Ship ptr;
	char fl;

	first_free = FirstFreeFleet ();

	if (first_free == '\0')
		quest = "Add to which fleet [all used]: ";
	else
		quest = Fmt ("Add to which fleet [%c]: ", first_free);

	Bell ();
	ans = InputAtMessage (quest, 1, "a-zA-Z~");
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Fleetadd cancelled");
		return;
	}

	if (* ans == '\0' && first_free == '\0')
	{
		Message ("You must specify a fleet !");
		Bell ();
		return;
	}

	fl = * ans == '\0'  ? first_free : * ans;
	
	ships = SelectShips (x, y, ST_FLEETADD, "Select ship(s) to add");
	if (ships == (char *) 0)
		return;

		/*
		 *	Select ships marks the selected ships
		 */
		
	for ALL_SHIPS (ptr)
		if (sh_marked (ptr))
			set_sh_fleet (ptr, fl);
	
	FeedCommand (Fmt ("fleetadd %c %s", fl, ships), PRINT);
}

char * ShipCargoNames (cargo)
int cargo[];
{
	int i;
	static char buffer [100];

	buffer [0] = '\0';

	for (i = 1; i < V_MAX; i++)
		if (cargo [i] > 0)
			strcat (buffer, Fmt (" %d%c", cargo [i], ItemChar (i)));
	
	return buffer;
}

char * ShipCapNames (flags)
long flags;
{
	static char buffer [100];

	buffer [0] = '\0';

	if (BIT_SET (flags, M_FISH))
		strcat (buffer, " fish");
	if (BIT_SET (flags, M_OIL))
		strcat (buffer, " oil");
	if (BIT_SET (flags, M_SWEEP))
		strcat (buffer, " sweep");
	if (BIT_SET (flags, M_MISS))
		strcat (buffer, " missile");
	if (BIT_SET (flags, M_PLANE))
		strcat (buffer, " plane");
	if (BIT_SET (flags, M_SUB))
		strcat (buffer, " submarine");
	if (BIT_SET (flags, M_SONAR))
		strcat (buffer, " sonar");
	if (BIT_SET (flags, M_MINE))
		strcat (buffer, " mine");
	if (BIT_SET (flags, M_DCHRG))
		strcat (buffer, " dept_charge");
	if (BIT_SET (flags, M_TORP))
		strcat (buffer, " torpedo");
	if (BIT_SET (flags, M_SPY))
		strcat (buffer, " spy");
	if (BIT_SET (flags, M_LAND))
		strcat (buffer, " land");
	if (BIT_SET (flags, M_SUBT))
		strcat (buffer, " sub-torp");
	
	return buffer;
}

void ShowShipCBStrings (strings)
Strings strings;
{
	int i;
	int maint;

	AddString (strings, Fmt ("%s %s",
			"Name             lcm hcm cost   maint tech def",
			ksu_version ? "spd vis spy rng fir pla ava flags"
				    : "spd vis spy rng fir ava flags"));
	AddString (strings, "");

	for (i = 0; shiptypes [i]. nam != (char *) 0; i ++)
	{
		maint = (int) (etu_per_update * - dmin (-1.0,
				shiptypes [i]. cos * money_ship));

		AddString (strings, Fmt (
  "%-16.16s %-3d %-3d %-6s %-5s %-4d %-3d %-3d %-3d %-3d %-3d %-3d %s%-3d%s%s",
				shiptypes [i]. nam,
				shiptypes [i]. lcm,
				shiptypes [i]. hcm,
				Fmt ("$%d", shiptypes [i]. cos),
				Fmt ("$%d", maint),
				shiptypes [i]. tec,
				shiptypes [i]. def,
				shiptypes [i]. spd,
				shiptypes [i]. vis,
				shiptypes [i]. spy,
				shiptypes [i]. rng,
				shiptypes [i]. fir,
				ksu_version ? Fmt ("%-3d ",
							shiptypes [i]. pla)
					    : "",
				shiptypes [i]. ava,
				ShipCargoNames (shiptypes [i]. car),
				ShipCapNames (shiptypes [i]. flags)));
	}

}

void PageShowShipCBs ()
{
	Strings strings;

	strings = InitStrings ();
	ShowShipCBStrings (strings);

	if (StringsSize (strings) == 2)
	{
		Message ("You don't know about ships yet");
		Bell ();
		FreeStrings (strings);
		return;
	}

#ifdef TERMC_VERSION
	ShowStringsInPager (strings, "show ship c&b");
#else /* TERMC_VERSION */
	InitWMPager (strings, "show ship c&b");
#endif /* TERMC_VERSION */
}

double ShipFireRange (ship)
Ship ship;
{
	return TechFact(sh_tech (ship),
		(double) shiptypes [sh_type (ship)].rng / 2.0);
}

int ShipMaxGuns (ship)
Ship ship;
{
	return shiptypes [sh_type (ship)]. fir;
}

Sector ShipSector (ship)
Ship ship;
{
	return World (sh_xcd (ship), sh_ycd (ship), S_EXIST);
}

bool SectorHasOwnedShips (sct, n)
Sector sct;
int n;
{
	int i;
	Ship ptr;

	i = 0;
	for (ptr = s_fship (sct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
		if (sh_owned (ptr))
			if (++ i == n)
				return True;
	
	return False;
}

void DoLookout (sct, shipnr, in_navigate, print, force)
Sector sct;
int shipnr;
bool in_navigate;
int print;
bool force;
{
	Sector nxt;
	Neighb neighb;
	bool do_lookout;

	do_lookout = False;
	if (! force)
	{
		InitNeighbours (sct, & neighb);
		for (nxt = sct; NextNeighbour (& nxt, S_DESIG, neighb); )
			if (NO_INFO (nxt))
				do_lookout = True;
	}

	if (do_lookout || force)
	{
		if (in_navigate)
		{
			FeedEmpire ("l", print);
			(void) WaitForPrompt (print);
			FeedEmpire (Fmt ("%d", shipnr), print);
		}
		else
			FeedEmpire (Fmt ("lookout %d", shipnr), print);

		ScanLookout ();
		InitNeighbours (sct, & neighb);
		while (NextNeighbour (& nxt, S_DESIG, neighb))
			(void) UpdateSectorDes (nxt, '.', False);

		DrawNeighbours (sct);

		(void) WaitForPrompt (print);
	}
}

bool ShipAtWith (sct, flag)
Sector sct;
long flag;
{
	register Ship ptr;

	for (ptr = s_fship (sct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
		if (ShipHas (ptr, flag))
			return True;
	
	return False;
}

int AskCarrier (x, y, sct)
int x, y;
Sector sct;
{
	Strings strings;
	Pager pager;
	Ship ptr;
	int last_id;
	int i;

	strings = InitStrings ();
	last_id = -1;

	for (ptr = s_fship (sct); ptr != (Ship) 0; ptr = sh_nxtsct (ptr))
		if (ShipHas (ptr, M_PLANE))
		{
			AddStringID (strings, Fmt (
				"%-18.18s #%-4d (%d planes, %d petrol)",
				ShipName (ptr), sh_pln (ptr), sh_pet (ptr)),
				sh_nr (ptr));
			last_id = sh_nr (ptr);
		}
	
	if (StringsSize (strings) <= 1)
	{
		FreeStrings (strings);
		return last_id;
	}

	pager = InitPager (strings, "Land at which aircraft ?");
	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);
	return i < 0 ? -1 : i;
}
