#include "type.h"
#include "main.h"
#include "plane.h"
#include "sector.h"

bool WingEmpty (wing)
char wing;
{
	Plane plane;

	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		if (pl_wing (plane) == wing)
			return False;

	return True;
}

bool WingColocated (wing)
char wing;
{
	Plane plane;
	int x, y;
	bool found;

#ifdef lint
	x = y = 0;
#endif

	found = False;
	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		if (pl_wing (plane) == wing)
			if (found)
			{
				if (pl_xcd (plane) != x || pl_ycd (plane) != y)
					return False;
			}
			else
			{
				found = True;
				x = pl_xcd (plane);
				y = pl_ycd (plane);
			}
	return True;
}

Sector WingSector (wing)
char wing;
{
	Plane plane;

	for (plane = first_plane; plane != (Plane) 0; plane = pl_next (plane))
		if (pl_wing (plane) == wing)
			return World (pl_xcd (plane), pl_ycd (plane), S_DESIG);
	
	return (Sector) 0;
}

char NextWingInSct (sct, wing)
Sector sct;
char wing;
{
	char next;
	Plane ptr;

	next = '\0';

	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (next == '\0')
		{
			if (pl_wing (ptr) > wing)
				next = pl_wing (ptr);
		}
		else if (next > pl_wing (ptr) && pl_wing (ptr) > wing)
			next = pl_wing (ptr);

	return next;
}

char FirstWingInSct (sct)
Sector sct;
{
	Plane ptr;
	char first;

	if (s_fplane (sct) == (Plane) 0)
		return '\0';

	first = '~';
	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (pl_wing (ptr) < first)
			first = pl_wing (ptr);
			
	return first;
}

void WingJoin (from, to)
char from, to;
{
	Plane ptr;

	for (ptr = first_plane; ptr != (Plane) 0; ptr = pl_next (ptr))
		if (pl_wing (ptr) == from)
			set_pl_wing (ptr, to);
}

char GiveEscortWing ()
{
	Plane ptr;

	for (ptr = s_fplane (cursct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (BIT_SET (planetypes [pl_type (ptr)]. flags, P_F) &&
						pl_wing (ptr) != '~')
			return pl_wing (ptr);
	
	return '\0';
}

static void CalcFreeWings (upper, lower)
bool upper [], lower [];
{
	Plane ptr;
	register i;

	for (i = 0; i < 26; i ++)
		upper [i] = lower [i] = True;
	

	for ALL_PLANES (ptr)
		if (isupper (pl_wing (ptr)))	
			upper [pl_wing (ptr) - 'A'] = False;
		else if (islower (pl_wing (ptr)))
			lower [pl_wing (ptr) - 'a'] = False;
	
}

void ShowFreeWings ()
{
	char * ptr;
	bool upper [26], lower [26];

	CalcFreeWings (upper, lower);
	ptr = MakeFreeString (upper, lower);

	if (strlen (ptr) == 0)
		Message ("No free wings");
	else
		Message (Fmt ("Free wings: %s", ptr));
}

char FirstFreeWing ()
{
	int i;
	bool upper [26], lower [26];

	CalcFreeWings (upper, lower);

	for (i = 0; i < 26; i ++)
		if (lower [i])
			return 'a' + i;

	for (i = 0; i < 26; i ++)
		if (upper [i])
			return 'A' + i;

	return '\0';
}

char GiveNextWingInSct (sct, wing)
Sector sct;
char wing;
{
	char next;
	Plane ptr;

	next = wing;

	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (next < pl_wing (ptr) && pl_wing (ptr) > wing)
			next = pl_wing (ptr);

	if (next > wing)
		return next;
	
	next = '~';
	for (ptr = s_fplane (sct); ptr != (Plane) 0; ptr = pl_nxtsct (ptr))
		if (pl_wing (ptr) < next)
			next = pl_wing (ptr);

	return next;
}

char * WingId ()
{
	bool first;
	static char buffer [1024];
	Plane ptr;

	if (! WingColocated (curwing))
	{
		buffer [0] = '\0';
		first = True;

		for (ptr = s_fplane (cursct); ptr != (Plane) 0;
							ptr = pl_nxtsct (ptr))
			if (pl_wing (ptr) == curwing)
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");
				
				strcat (buffer, Fmt ("%d", pl_nr (ptr)));
			}
		
		return buffer;
	}
	else
		return Fmt ("%c", curwing);
}
