#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"
#include "var.h"
#include "nation.h"
#include "ship.h"

char * BestFlyPath (sx, sy, ex, ey)
int sx, sy, ex, ey;
{
	int dx, dy;

	static char path [100];
	path [0] = '\0';

	dx = EX (sx - ex);
	dy = EY (sy - ey);

	while (dx != 0 || dy != 0)
	{
		if (dy == 0)
		{
			if (dx > 0)
			{
				strcat (path, "g");
				dx -= 2;
			}
			else
			{
				strcat (path, "j");
				dx += 2;
			}

			continue;
		}
		
		if (dy > 0)
		{
			if (dx < 0)
			{
				strcat (path, "u");
				dx ++;
				dy --;
			}
			else
			{
				strcat (path, "y");
				dx --;
				dy --;
			}
		}
		else
		{
			if (dx < 0)
			{
				strcat (path, "n");
				dx ++;
				dy ++;
			}
			else
			{
				strcat (path, "b");
				dx --;
				dy ++;
			}
		}
	}

	return path;
}

#define MAX_PARTS	50

char * AskFlyRoute (start, max_dist, comm)
Sector start;
int max_dist;
char * comm;
{
	char * path [MAX_PARTS];
	Sector scts [MAX_PARTS];
	static char buffer [200];
	int nr, i;
	int dist;
	int x, y, button;
	Sector to;

	nr = 0;
	scts [0] = start;
	MarkSector (start);
	Message (Fmt ("Please select %s route (max_dist: %d)", comm, max_dist));
	MesBut ("View", "Cancel", "Set");
	dist = 0;

	for (;;)
	{
		if (! SelectSctCrd (& x, & y, & button))
		{
			while (nr > 0)
			{
				nr --;
				UnmarkPath (scts [nr], path [nr]);
				free (path [nr]);
			}

			UnmarkSector (scts [nr]);
			Message ("Cancelled");
			MesClearBut ();
			return (char *) 0;
		}
		
		if (button == MIDDLE_BUTTON)
		{
			if (nr == 0)
			{
				UnmarkSector (scts [0]);
				MesClearBut ();
				return (char *) 0;
			}

			nr --;
			UnmarkPath (scts [nr], path [nr]);
			dist -= strlen (path [nr]);
			free (path [nr]);
			Message (Fmt ("Select %s route (dist: %d, left: %d)",
					comm, dist, max_dist - dist));
			continue;
		}


		to = World (x, y, S_DESIG);
		if (to == (Sector) 0)
			continue;

		if (button == LEFT_BUTTON)
		{
			CensusSct (to);
			continue;
		}

		if (button != RIGHT_BUTTON)
			continue;
		
		if (to == scts [nr])
		{
			buffer [0] = '\0';
			for (i = 0; i < nr; i ++)
			{
				UnmarkPath (scts [i], path [i]);
				strcat (buffer, path [i]);
				free (path [i]);
			}

			UnmarkSector (scts [0]);
			MesClearBut ();
			return buffer;
		}

		path [nr] = BestFlyPath (s_xcd (scts [nr]), s_ycd (scts [nr]),
						x, y);

		if (dist + strlen (path [nr]) > max_dist)
		{
			Message (Fmt (
			     "%d sectors too far away! (max dist: %d, now: %d)",
				dist + strlen (path [nr]) - max_dist,
				max_dist, dist));
			Bell ();
			continue;
		}

		path [nr] = Str (path [nr]);
		MarkPath (scts [nr], path [nr]);
		dist += strlen (path [nr]);
		scts [++ nr] = to;
		Message (Fmt ("Select fly route (dist: %d, left: %d)",
					dist, max_dist - dist));
	}
}

char * ConvEff (eff)
char * eff;
{
	/* see lib/global/misc.c */

	if (strcmp (eff, "minimally") == 0)
		return "0-24%";
	else if (strcmp (eff, "partly") == 0)
		return "24-49%";
	else if (strcmp (eff, "moderately") == 0)
		return "49-74%";
	else if (strcmp (eff, "completely") == 0)
		return "74-100%";
	else
		return "???%";
}

void ParseFlyOutput (carrier)
int carrier;
{
	char * line;
	char * answer;
	char * ptri;
	char buffer [100];
	char word [50];
	char des;
#ifdef pipo
	char effic [20];
	char ownername [50];
	int owner;
	int nr;
	Strings strings;
	Pager pager;
	bool handled;
#endif
	Sector sct;
	int x, y;
	int o_hits, o_aborted, o_shotdown;
	int t_hits, t_aborted, t_shotdown;
	bool shotdown, aborted;
	WinInfo win;
	int taken, planenr, nr_interc;
	Plane plane;
	bool spy, recon;

	win = OpenWindow (census_win, 0, CENSUS_HEIGHT - 13,
					CENSUS_WIDTH - 1, 12, CHARS, MENU, 0);

	PrintB (win, 0, 0, "Aircombat report: ");
	PrintN (win, 0, 2, "# our planes:");	/* 2, 16 */
	PrintN (win, 0, 3, "# their planes:");	/* 3, 16 */
	PrintN (win, 0, 5, "           Theirs   Ours");
	PrintN (win, 0, 6, "Hits"); /*  12       21 */
	PrintN (win, 0, 7, "Aborted");
	PrintN (win, 0, 8, "Shotdown");

	PrintB (win, 16, 2, Fmt ("%d", NrMarkedPlanes ()));
	PrintB (win, 16, 3, "none");
	FlushWindow (win);

	spy = False;
	recon = False;
#ifdef pipo
	handled = True;
	strings = (Strings) 0;
#endif
	o_hits = o_shotdown = o_aborted = t_hits = t_aborted = t_shotdown = 0;
	nr_interc = 0;

	while (line = ReadEmpire (PRINT))
	{
		if (line == (char *) 0)
			return;

		if (EmpireStatus () == E_QUESTION)
		{
			PrintAtEmpire (line);

			if (StrEQ (line, "Carrier"))
			{
				FeedEmpire (Fmt ("%d", carrier), PRINT);
				continue;
			}

			/*
				if (strings == (Strings) 0)
				{
					Panic ("ParseFlyOutput", "plane/path.c",
						"strings can't be empty !");
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
					return;
				}


				if (StringsSize (strings) == 1)
				{
					InitStringList (strings);
					(void) GetNextStringID (strings, & nr);
					FeedEmpire (Fmt ("%d", nr), PRINT);
					continue;
				}

				pager = InitPager (strings,
					"Land on which carrier ?");
				MapPagerFromTop (pager, map_win, px, py);
				nr = PagerMenu (pager);
				FreePager (pager);

				if (nr < 0)
				{
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
					FreeStrings (strings);
					return;
				}

				FeedEmpire (Fmt ("%d", nr), PRINT);
				handled = True;
				continue;
			}

			*/

			Bell ();
			answer = InputAtMessage (line, 20, GS_TEXT);
			if (interrupt || answer == (char *) 0)
			{
				interrupt = False;
				Message ("Aborted");
				do {
					FeedEmpire ("aborted", PRINT);
					(void) WaitForPrompt (PRINT);
				}
				while (EmpireStatus () != E_COMMAND);
				if (nr_interc || o_hits || t_hits)
				{
					Message ("More");
					Pause ();
				}
				DestroyWindow (win);
				return;
			}

			FeedEmpire (answer, PRINT);
			continue;
		}

		if (EmpireStatus () == E_COMMAND)
		{
			PrintAtEmpire (line);
			if (nr_interc || o_hits || t_hits)
			{
				Message ("More");
				Pause ();
			}
			DestroyWindow (win);
			return;
		}

		if (StrEQ (line, "flying over"))
		{
			ptri = line + 11;
			if (! ScanWord (& ptri, buffer))
				continue;
				

			while (ScanWord (& ptri, word))
				if (strcmp (word, "at") == 0)
					break;
				else
				{
					strcat (buffer, " ");
					strcat (buffer, word);
				}

			des = CharOfDesigName (buffer);
			if (des == '\0')
				continue;
			
			if (sscanf (ptri, " %d , %d", & x, & y) == 2)
			{
				sct = World (x, y, S_DESIG);

				if (s_des (sct) != des)
				{
					UpdateSectorDes (sct, des, True);
					DrawSector (sct);
				}
			}
		}

		/*
		 
		if (sscanf (line, "(# %hd) %s %s", & nr, ownername, effic) == 2)
		{
			if (CountryId (ownername) == UNKNOWN_CNUM)
				continue;
			
			if (handled && strings != (Strings) 0)
			{
				FreeStrings (strings);
				strings = (Strings) 0;
			}

			if (strings == (Strings) 0)
				strings = InitStrings ();

			AddStringID (strings, Fmt ("#%-4d  %-10.10s %s eff %s",
				nr, ownername, ConvEff (effic), line + 33), nr);
			handled = False;
		}

		*/

		if (StrEQ (line, "SPY"))
		{
			spy = True;
			continue;
		}

		if (spy && ScanSpyLine (line))
			continue;

		if (StrEQ (line, "Reconnaissance")) {
		   line = ReadEmpire(PRINT);
		   recon = True;
		   continue;
		}

		if (recon && ScanReconLine (line))
			continue;

		if (strlen (line) > 21 && strcmp (line + strlen (line) - 21,
			" rising to intercept!") == 0)
		{
			nr_interc += atoi (line);
			PrintB (win, 16, 3, Fmt ("%-4d", nr_interc));
			FlushWindow (win);
		}
			
		ptri = index (line, '(');
		if (ptri != (char *) 0 && sscanf (ptri, "(#%d) takes %d",
					& planenr, & taken) == 2)
		{
			ptri = index (ptri, '-');
			aborted = ptri != (char *) 0 &&
					  StrEQ (ptri, "-- aborted");
			shotdown = ptri != (char *) 0 &&
					  StrEQ (ptri, "-- shot down");
			plane = NrToPlane (planenr);
			if (plane == (Plane) 0)	/* their plane */
			{
				t_hits += taken;
				PrintB (win, 12, 6, Fmt ("%-4d", t_hits));
				if (aborted)
				{
					t_aborted ++;
					PrintB (win, 12, 7, Fmt ("%-4d",
						t_aborted));
				}
				else if (shotdown)
				{
					t_shotdown ++;
					PrintB (win, 12, 8, Fmt ("%-4d",
						t_shotdown));
				}

				FlushWindow (win);
				continue;
			}
			else	/* our plane */
			{
				o_hits += taken;
				PrintB (win, 21, 6, Fmt ("%-4d", o_hits));
				if (shotdown)
				{
					DeletePlane (plane);
					o_shotdown ++;
					PrintB (win, 21, 8, Fmt ("%-4d",
							o_shotdown));
				}
				else if (aborted)
				{
					o_aborted ++;
					PrintB (win, 21, 7, Fmt ("%-4d",
							o_aborted));
					set_pl_eff (plane, pl_eff (plane) -
							taken);
				}
				else
				{
					set_pl_eff (plane, pl_eff (plane) -
							taken);
				}

				FlushWindow (win);
			}
		}
	}
}

	/*
	 *	Ask item to transport
	 */

char * AskFlyItem (x, y, max_load, mission)
int x, y;
int max_load;
Mission mission;
{
	bool ava [V_MAX];
	Pager pager;
	Strings strings;
	Plane ptr;
	int i, j;

	for (i = 1; i < V_MAX; i ++)
		ava [i] = True;
	
	for (i = 1; i < V_MAX; i ++)
		for (ptr = first_plane; ptr != (Plane) 0 && ava [i];
						ptr = pl_next (ptr))
			if (pl_marked (ptr) && pl_20mob (ptr))
				if (pl_shipnr (ptr) >= 0)
				{
					if (GiveShipQuant (NrToShip (pl_shipnr
						     (ptr)), ItemChar (i)) <= 0)
						ava [i] = False;
				}
				else
					if (GiveQuant (PlaneSector (ptr),
							ItemChar (i)) <= 0)
						ava [i] = False;
							
	strings = InitStrings ();
	if (mission == MIS_FLY)
		AddStringID (strings, "nothing", 0);

	for (i = 1; i < V_MAX; i ++)
		if (ava [i])
		{
			j = max_load / ItemWeight (i, NPKG);
			if (j <= 0)
				continue;
			AddStringID (strings, Fmt ("%-4d %s", j, ItemName (i)),
						i);
		}

	pager = InitPager (strings, mission == MIS_FLY ?
		"transport what:" : "drop off what:");

	MapPagerFromTop (pager, map_win, x, y);
	i = PagerMenu (pager);
	FreePager (pager);
	FreeStrings (strings);

	if (i < 0)
		return (char *) 0;

	if (i == 0)
		return "";

	return ItemName (i);
}

Sector FollowPath (sct, path)
Sector sct;
char * path;
{
	int x, y;

	x = s_xcd (sct);
	y = s_ycd (sct);

	while (* path != '\0')
		switch (* path ++)
		{

		case 'y':	x --;   y --; break;
		case 'u':	x ++;   y --; break;
		case 'n':	x ++;   y ++; break;
		case 'b':	x --;   y ++; break;
		case 'g':	x -= 2;       break;
		case 'j':	x += 2;       break;

		}

	return World (x, y, S_DESIG);
}

Sector FollowOwnedPath (from, path, owned)
Sector from;
char * path;
bool * owned;
{
	int x, y;
	Sector sct;
	Ship ship;

	x = s_xcd (from);
	y = s_ycd (from);

	* owned = True;
	while (* path != '\0')
	{
		switch (* path ++)
		{

		case 'y':	x --;   y --; break;
		case 'u':	x ++;   y --; break;
		case 'n':	x ++;   y ++; break;
		case 'b':	x --;   y ++; break;
		case 'g':	x -= 2;       break;
		case 'j':	x += 2;       break;

		}

		if (* owned)
		{
			sct = World (x, y, S_EXIST);
			if (sct == (Sector) 0)
			{
				* owned = False;
				continue;
			}

			if (! s_owned (sct) && ! s_owner (sct) == 0)
			{
				* owned = False;
				continue;
			}

			for (ship = s_fship (sct); ship != (Ship) 0;
					ship = sh_nxtsct (ship))
				if (! sh_owned (ship))
				{
					* owned = False;
					break;
				}
		}
	}

	return World (x, y, S_EXIST);
}


/*
 * code straight from ScanLookout, maybe we shoud make this
 * ScanLookoutLine and use it in ScanLookout and Recon
 * mta Sat Dec  1 18:08:29 EET 1990
 */
ScanReconLine(line)
char *line;
{
   char *ptri, *tmpptr, savechar, *name;
   int owner, num, x, y;
   char des;
   Sector sct;
   bool err;
   time_t tt, time ();

   tt = time ((time_t *) 0);
   ptri = line;

   SkipBlank (&ptri);

   if (*ptri == '\n' || *ptri == '\0') return;


   if (!strncmp (line, "Your ", 5))
      /* It's one of my own sectors, just skip it */
      return True;
   
   if (!strncmp (line, "No ", 3))
      /* No planes got through fighter defences */
      return False;
   
      /* check for flak guns */
   if (!strncmp (line, "firing ", 7))
      return False;
   /* check for possible interceptors */
   if  (StrStr (line, " rising to intercept!"))
       return False;
   if  (StrStr (line, " intercepts "))
     return False;
   if  (StrStr (line, " takes "))
     return False;

   name = ptri;
   ptri = index (ptri, '(');
   if (ptri == (char *) 0)
      {
	 PrintAtEmpire ("Scan L/S/C : no country");
	 PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
	 Bell ();
	 (void) EmpireMore ();
	 return False;
      }
   tmpptr = ptri;
   
   ptri += 2;
   if (! ScanDigit (&ptri, &owner))
      {
	 PrintAtEmpire ("Scan L/S/C : Bad country format");
	 PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
	 Bell ();
	 (void) EmpireMore ();
	 return False;
      }
   
   do
      tmpptr--;
   while (isspace (*tmpptr));
   
   savechar = * ++tmpptr;
   * tmpptr = '\0';
   
   
   AddCountry (owner, name);
   
   * tmpptr = savechar;
   
   
   if (*ptri != ')')
      ptri = index (ptri, ')');
   
   if (ptri == (char *) 0)
      {
	 PrintAtEmpire ("Scan L/S/C : Bad country format");
	 PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
	 Bell ();
	 (void) EmpireMore ();
	 return False;
      }
   ptri++; /* skip ')' */
   
   SkipBlank (&ptri);
   
   tmpptr = index (ptri, '#');
   
   if (tmpptr == (char *) 0)
      {
	 /* it's land */
	 int eff, civ, mil;
	 
	 des = CharOfDesigName (ptri);
	 if (des == '\0')
	    {
	       PrintAtEmpire (
			      "Scan L/S/C : Unknown Designation ?");
	       PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
	       Bell ();
	       (void) EmpireMore ();
	       return False;
	    }
	 ptri += strlen  (DesignName (des));
	 err = ! ScanDigit (&ptri, &eff) || *ptri != '%';
	 ptri++; /* Skip '%' */
	 
	 SkipBlank (&ptri);
	 
	 if (err || (strncmp (ptri, "efficient", 9) != 0))
	    {
	       PrintAtEmpire ("Scan L/S/C : Bad eff Format");
	       PrintAtEmpire ( Fmt ("Skipping \"%s\"", line));
	       Bell ();
	       (void) EmpireMore ();
	       return False;
	    }
	 ptri += 9;
	 
	 SkipBlank (&ptri);
	 
	 civ = 0;
	 mil = 0;
	 for (;;)
	    {
	       if (strncmp (ptri, "with approx", 11) == 0)
		  {
		     ptri += 12;
		     err = ! ScanDigit (&ptri, &num);
		     ptri++;
		     if (!err && *ptri == 'c')
			civ = num == 0 ? 1 : num;
		     else if (!err && *ptri == 'm')
			mil = num == 0 ? 1 : num;
		     else
			{
			   PrintAtEmpire (
					  "Scan L/S/C : Bad Lookout format");
			   PrintAtEmpire (
					  Fmt ("Skipping \"%s\"", line));
			   Bell ();
			   (void) EmpireMore ();
			   break;
			}
		     ptri += 4;
		  }
	       else
		  break;
	    }
	 
	 SkipBlank (&ptri);
	 if  (*ptri != '@' ||
	      sscanf (ptri, "@ %d,%d", &x, &y) != 2)
	    {
	       PrintAtEmpire (
			      "Scan L/S/C : Unknown @ format ?");
	       PrintAtEmpire (Fmt ( "Skipping \"%s\"", line));
	       Bell ();
	       (void) EmpireMore ();
	       return False;
	    }
	 
	 sct = World (x, y, S_RESOU);
	 
	 if (s_time (sct) == tt)
	    /* Already got it */
	    return True;
	 
	 if (s_owned (sct))
	    {
	       /* Must have been captured */
	       
	       PrintAtEmpireMode (
				  Fmt ("Your sector at %s has been captured",
				       CrdStr (sct)), BOLD);
	       Bell ();
	       DEL_INFO (sct);
	       SET_INFO_RES (sct); /* save resources */
	       set_owner (sct, UNKNOWN_CNUM);
	    }
	 /* This is most uptodate info overwrite anythin else */
	 set_des (sct, des);
	 set_owner (sct, owner);
	 set_eff (sct, eff);
	 set_civ (sct, civ);
	 set_mil (sct, mil);
	 set_time (sct, tt);
	 SET_INFO_LOO (sct);
      }
   else
      {
	 /* it's a ship */
	 
	 if (sscanf (tmpptr, "#%d @ %d,%d", &num, &x, &y) != 3)
	    {
	       PrintAtEmpire (
			      "Scan L/S/C : Unknown ship format ?");
	       PrintAtEmpire (Fmt ("Skipping \"%s\"", line));
	       Bell ();
	       (void) EmpireMore ();
	       return False;
	    }
	 
	 do
	    tmpptr--;
	 
	 while (isspace (*tmpptr));
	 
	 savechar = * ++tmpptr;
	 * tmpptr = '\0'; /* leave's in ptri shipname */
	 
	 if (AddEnemyShip (x, y, num, owner, ptri))
	    {
	       * tmpptr = savechar;
	    }
	 /* else ship already on list and at same position
	  * don't tell player what he already knows
	  */
      }
}



