#include "type.h"
#include "main.h"
#include "sector.h"
#include "plane.h"

void RedoHarden ()
{
	if (last_layout == PLANE_MODE)
	{
		Harden (Fmt ("%d", pl_nr (curplane)));
		CensusPlane (curplane);
	}
	else if (last_layout == WING_MODE)
	{
		Harden (WingId ());
		CensusWing (curwing);
	}
	else
	{
		Message ("No current plane/wing selected");
		Bell ();
	}
}

void Harden (what)
char * what;
{
	Plane ptr;
	char * ans;
	int inc;
	char buffer [BUFSIZ];
	int nr, i;
	bool first;

	UnmarkAllPlanes ();
	MarkPlanes (what);

	ans = InputAtMessage ("Increase by: ", 3, GS_PNUMBER);
	if (ans == (char *) 0 || interrupt)
	{
		interrupt = False;
		Message ("Harden cancelled");
		Bell ();
		return;
	}

	SetAgain (RedoHarden);

	if (* ans != '\0')
	{
		inc = atoi (ans);
		if (inc == 0)
		{
			Message ("harden cancelled");
			Bell ();
			return;
		}
	}
	else
		inc = 0;

	buffer [0] = '\0';
	nr = 0;
	first = True;

	for ALL_PLANES (ptr)
		if (pl_marked (ptr))
		{
			if (pl_xcd (ptr) != s_xcd (cursct) ||
			    pl_ycd (ptr) != s_ycd (cursct))
				continue;

			if (! PlaneHas (ptr, P_M))
			{
				Warning (Fmt ("%s #%d ain't a missile",
					PlaneName (ptr), pl_nr (ptr)));
				continue;
			}

			if (pl_shipnr (ptr) >= 0)
			{
				Warning (Fmt ("%s #%d is on a ship",
					PlaneName (ptr), pl_nr (ptr)));
				continue;
			}

			if (inc == 0)
			{
				ans = InputAtMessage (Fmt (
						"%s #%d, increment by? ",
						PlaneName (ptr), pl_nr (ptr)),
					3, GS_PNUMBER);

				if (ans == (char *) 0 || interrupt)
				{
					Message ("Harden cancelled");
					Bell ();
					interrupt = False;
					return;
				}

				if (* ans == '\0')
					i = 0;
				else 
					i = atoi (ans);
			}
			else
				i = inc;

			if (pl_hard (ptr) + i > 127)
				i = 127 - pl_hard (ptr);

			if (i == 0)
				continue;
			
			if (q_hcm (cursct) == 0)
			{
				Warning (Fmt ("Sector has no %shcm!",
					nr == 0 ? "" : "more "));
				break;
			}


			nr ++;
			if (q_hcm (cursct) < i)
			{
				Warning (Fmt ("Sector has only %d hcm left",
					q_hcm (cursct)));
				i = q_hcm (cursct);
				inc = 0;
			}

			if (inc == 0)
				FeedCommand (Fmt ("harden %d %d",
					pl_nr (ptr), i), PRINT);
			else
			{
				if (first)
					first = False;
				else
					strcat (buffer, "/");

				strcat (buffer, Fmt ("%d", pl_nr (ptr)));
			}

			inc_pl_hard (ptr, i);
			set_q_hcm (cursct, q_hcm (cursct) - i);
		}

	if (nr == 0)
	{
		Message ("No missiles affected");
		return;
	}

	if (strlen (buffer) > 0)
		FeedCommand (Fmt ("harden %s %d", buffer, inc), PRINT);

	Message (Fmt ("%d missiles hardened", nr));
}
