/*
 * symtab.h
 */

typedef struct _Symtab {
	char *name;
	int token;
	int type;
	int allowed_modifiers;
} SYMTAB, *Symtab;

extern SYMTAB special_chars_symtab[];
extern SYMTAB text_symtab[];

#define T_NONE		0x0000
#define T_NUMERIC	0x0001
#define T_BOOLEAN	0x0002
#define T_CHARACTER	0x0004
#define T_STRING	0x0008
#define T_SECTOR	0x0010
#define T_TOKEN		0x0020
#define T_PLAGUE	0x0040
#define T_HAPPY		0x0080

#define T_EVALUATE	(T_NUMERIC | T_BOOLEAN)


/*
 * Token modifier selection types
 */
#define MP_NONE		0x0000  /* Token has unequivocal meaning      */
#define MP_RESO		0x0001	/* Token has meaning within resource  */
#define MP_THRES	0x0002	/* Token has meaning within threshold */
#define MP_SSECT	0x0004	/* (start value)		      */
#define MP_SECT		0x0008	/* Token has meaning within sector    */
#define MP_SHIP		0x0010  /* Token has meaning within ships     */
#define MP_PLANE	0x0020  /* Token has meaning within planes    */
#define MP_NUKE		0x0040  /* Token has meaning within nukes     */

/* Commodities */
#define MP_COMM		(MP_RESO | MP_THRES | MP_SECT | MP_SHIP)

#define MP_ALL		(MP_SECT | MP_SHIP | MP_PLANE | MP_NUKE)
#define MP_ALLX		(MP_SECT | MP_SHIP | MP_PLANE)	/* All except nukes */
