/*************************************************************
 *  $Id: main.c,v 1.5 91/06/06 12:52:29 dhay Exp $
 *
 *  main.c
 *
 *  The main for the empire interface program EIF.
 *
 *  Handles runtime command arguments.
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1989,90,91.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <stdio.h>
#define MAIN
#include "cntl.h"
#include "data.h"

/* From init.c */
void set_defaults();

/* From eif.c */
void eif_away();

/* From vars.c */
void setvar_value();

/* From print.c */
extern int disable_bell_output;

#ifndef ENVARG
#define ENVARG "EIFARGS"
#endif

static void usagequit();
static void parse_env();
static void print_help();
static void version_print();

    int
main (argc, argv)
    int argc;
    char *argv[];
{
    int t;

    /* Set defaults before argument parsing */
    set_defaults();

    /* Parse any arguments in the environment variable */
    parse_env(ENVARG);

    /* Parse the runtime arguments */
    if ((t=parse_args(argc, argv)))
	usagequit(t);

    eif_away();
}

/*************************************
 * parse_env
 *
 * Check the given environment variable,
 * and if it is set, parse it as if it
 * were a command line option string.
 */

    static void
parse_env(env)
    char *env;
{
    int l;
    char *val;
    char buf[256];
    char *getenv(), *strncpy();

    if ((val=getenv(env)) == NULL)
	return;

    /* Get length of variable, make sure not too long. */
    l = strlen(val);
    if (l >= sizeof(buf))
	l = sizeof(buf)-1;

    /* Copy it into our buffer */
    (void) strncpy(buf, val, l);
    buf[l] = '\0';

    if ((l=parse_string(buf))) {
	if (l != -2)
	    fprintf(stderr, "Error in environment variable %s\n", env);
	usagequit(l);
    }
}

/*******************************************
 * parse_string
 *
 * Passed a string, make it look like an argv,
 * and then call parse_args on it.
 */
    int
parse_string(buf)
    char *buf;
{
    int n=0, inone=0;
    char *cp;
    char *pnts[100];

    pnts[n++] = buf;

    /* Find the start of all strings in it */
    cp = buf;
    while (*cp) {
	if (*cp == ' ') {
	    *cp = '\0';
	    inone = 0;
        } else {
	    if (!inone) {
		pnts[n++] = cp;
		inone = 1;
	    }
	}
	cp++;
    }
    return(parse_args(n, pnts));
}


/**********************************
 * parse_args
 *
 * Parse the command line type args.
 *
 * Returns 0 if error.
 * Otherwise, pass return code to usagequit for
 * interpretation and error printout.
 *
 *  -1 is a general parsing error, can't figure it out.
 *  -2 is a print_help return, just to exit program.
 *  anything else must be workout in usagequit.
 */

    static int
parse_args(argc, argv)
    int argc;
    char *argv[];
{
    int argi, optcont;
    char *arg;
    long atol();

    argi = 0;
    while(++argi < argc) {	/* While there are args to process */
	arg = argv[argi];
	if ( *arg == '-' ) {	/* minus options */
	    optcont = 1;
	    while ( *++arg && optcont ) {   /* while option chars */
		switch ( *arg ) {   /* case on minus option chars */
		    case 'h':    /* help */
			print_help();
			return(-2);
		    case 'v':
			version_print();
			return(-2);
		    case 'b':
			disable_bell_output = 1;
			break;
		    case 'r':
			cntl.st.readstartup = 0;
			break;
		    case 'D':
			optcont = 0;
			if (++argi < argc) {
			    char *vname, *vval;
			    vname = argv[argi];
			    if (++argi < argc) {
				vval = argv[argi];
			    } else
				vval = " ";
			    setvar_value(vname, vval);
			}
			break;
		    default:
			fprintf(stderr, "Invalid option : '%c' in '%s'\n",
					*arg, argv[argi]);
			return(-1);
		} /* switch */
		/*NOTREACHED*/
	    } /* while */
	} else if ( *arg == '+' ) {  /* plus options */
	    while ( *++arg ) {    /* while option chars */
		switch ( *arg ) {  /* case on plus option chars */
		    case 'h':    /* help */
			print_help();
			return(-2);
		    case 'v':
			version_print();
			return(-2);
		    case 'b':
			disable_bell_output = 0;
			break;
		    default:
			fprintf(stderr, "Invalid option : '%c' in '%s'\n",
					*arg, argv[argi]);
			return(-1);
		} /* switch */
		/*NOTREACHED*/
	    } /* while */
	} else if (*arg == ' ') {
	} else {	/* Not an option */
	    setvar_value("AUTOGAME", arg);
	}    /* end of if else sequence */
    }  /* end of while on arguments passed */
    return(0);
}

/*****************************************
 * usagequit
 *
 * An option was incorrect.  Tell what it should be,
 * and exit program.
 */

    static void
usagequit(typ)
    int typ;
{
    if (typ == -2) {
	exit(0);  /* Help quit. */
    } else {
	fprintf(stderr, "Usage: [+/-hv] <gamename>\n");
    }
    fprintf(stderr, "Try -h option for help.\n");
    exit(1);
}


    static void
print_help()
{
    int i;
    char *p;
    static char *help_list[] =
	    {" ",
	    "This is the Empire Interface program EIF.",
	    "",
	    "  A Doug Hay Production.",
	    "  Copyright Doug Hay, 1991.",
	    "",
	    " Options:  <too few>",
	    "   +/-h   - print this minor help display.",
	    "   +/-v   - print out the version info.",
	    "   -r     - prevent reading of the ~/.eifrc file.",
	    "   -D var val  - do a 'setenv var val'.",
	    "   +/-b   - enable/disable ^G (bell).",
#ifndef lint
	    " ", (char *)0L
#endif
    };

    i = 0;
    p = help_list[i++];
    while (p) {
	printf("%s\n", p);
	p = help_list[i++];
    }
    printf(" May set any options above, as a string, in the\n");
    printf(" environment variable %s\n", ENVARG);
    printf(" Command line options are parsed last.\n");
}

    static void
version_print()
{
    int i;
    char *p;
    static char *version_list[] = {
#include "version.h"
#ifndef lint
    (char *)0L
#endif
    };

    i = 0;
    p = version_list[i++];
    while (p) {
	printf("%s\n", p);
	p = version_list[i++];
    }
}
