/*************************************************************
 *  $Id: alias.c,v 1.4 91/05/17 12:10:28 dhay Exp $
 *
 *  alias.c
 *
 *  Maintain the user aliases.
 *
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1991.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <ctype.h>

void prt();
void eprt();

typedef struct {
	char *alias;
	char *command;
	char mark;
} alias_t;

static alias_t *alias_list;
static int numaliases = 0;
static int maxaliases = 0;

char *calloc(), *malloc();

/***********************************
 * clear_alias_marks
 *
 * Clear the alias marks so they can be reused.
 */
    void
clear_alias_marks()
{
    alias_t *ap;
    int i;

    for (ap=alias_list,i=0; (ap && i <numaliases); ap++, i++)
	ap->mark = 0;
}

/***********************************
 * find_alias_loc
 *
 * Find the matching alias, if it exists.
 */
    static alias_t *
find_alias_loc(buf)
    char *buf;
{
    alias_t *ap;
    int i;

    for (ap=alias_list,i=0; ap && i<numaliases; ap++,i++) {
	if (ap->alias && !strcmp(ap->alias, buf))
	    return(ap);
    }
    return((alias_t *) 0);
}

/***********************************
 * find_alias
 *
 * Find the alias, if it exists, and return a
 * pointer to it's command, if it hasn't been
 * marked as being used before.
 */
    char *
find_alias(buf)
    char *buf;
{
    alias_t *ap;

    if ((ap=find_alias_loc(buf)) && !ap->mark) {
	ap->mark = 1;
	return(ap->command);
    }
    return((char *) 0);
}


/***********************************
 * cmd_alias
 *
 * The alias command.
 */
    void
cmd_alias(alias, sub)
    char *alias;
    int sub;
{
    char *command, *cp, *strcpy();
    alias_t *ap;
    int i;

    /* Skip over trailing space. */
    while(isspace(*alias)) alias++;

    /* If no alias is specified, print all the aliases. */
    if (!*alias) {
	if (!numaliases)
	    prt("No aliases defined.\n");
	else
	    for (ap=alias_list,i=0; ap&&i<numaliases; ap++,i++)
		prt("alias %s \"%s\"\n", ap->alias, ap->command);
	return;
    }

    command = alias;
    while (*command && !isspace(*command)) command++;
    if (*command) {
	*command++ = '\0';
	while (isspace(*command)) command++;
	/* String "'s from the command */
	if ('\"' == *command) {
	    cp = ++command;
	    while (*cp && '\"' != *cp) cp++;
	    if ('\"' == *cp)
		*cp = '\0';
	}
    }

    /* We prevent certain keywords from being aliased. */
    /* Like, alias, unalias */
    if (!strcmp(alias, "alias") || !strcmp(alias, "unalias")) {
	eprt("Too dangerous to allow that\n");
	return;
    }

    /* If we find a matching alias, either print it or replace it. */
    if ((ap=find_alias_loc(alias))) {
	if (*command) {
	    (void)free(ap->command);
	} else {
	    prt("alias %s \"%s\"\n", ap->alias, ap->command);
	    return;
	}
    } else {
	if (!*command) {
	    prt("%s undefined.\n", alias);
	    return;
	}
	numaliases++;
	if (numaliases >= maxaliases) {
	    alias_t *tp;

	    maxaliases += 10;
	    if (!(tp = (alias_t *) calloc((unsigned) maxaliases,
				sizeof(alias_t))))
		exit(1);
	    if (alias_list)
		bcopy((char *) alias_list, (char *) tp,
				((numaliases-1) * sizeof(alias_t)));
	    (void)free((char *)alias_list);
	    alias_list = tp;
	}
	ap = &alias_list[numaliases - 1];
	i = strlen(alias);
	ap->alias = malloc((unsigned)i+1);
	(void)strcpy(ap->alias, alias);
    }
    i = strlen(command);
    ap->command = malloc((unsigned)i+1);
    (void)strcpy(ap->command, command);
    return;
}

/***********************************
 * cmd_unalias
 *
 * The unalias command.
 */
    void
cmd_unalias(buf, sub)
    char *buf;
    int sub;
{
    char *alias, *cp;
    alias_t *ap, *bp;
    int i;

    alias = buf;
    /* Skip over trailing space. */
    while (isspace(*alias)) alias++;
    
    if (!alias) {
	eprt("Expecting alias to remove.\n");
	return;
    }

    cp = alias;
    while (!isspace(*cp)) cp++;
    *cp = '\0';

    if ('*' == *alias && !*(alias+1)) {
	for (ap=alias_list,i=0; (ap && i <numaliases); ap++, i++) {
	    (void)free(ap->alias);
	    (void)free(ap->command);
	    ap->alias = (char *) 0;
	}
	numaliases = 0;
	prt("All aliases removed.\n");
	return;
    }

    if(!(ap = find_alias_loc(alias))) {
	eprt("Alias '%s' not found.\n", alias);
	return;
    }
    (void)free(ap->alias);
    (void)free(ap->command);
    bp = ap++;
    while (ap->alias) {
	bp->alias = ap->alias;
	bp->command = ap->command;
	bp = ap++;
    }
    bp->alias = (char *) 0;

    prt("Alias '%s' deleted.\n", alias);
    numaliases--;
    return;
}
