#ifndef lint
static char *RCSid = "$Header: main.c,v 1.11 91/06/09 12:54:19 mr-frog Locked $";
#endif /* not lint */

/*
 * main.c
 *
 * front end to empire
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "bit.h"

#include <stdio.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>
#include <time.h>
#include <sys/socket.h>
#include <netinet/in.h>

extern int errno;

int	interrupt;
int	sock;

main(argc, argv)
	int	argc;
	char	*argv[];
{
	extern	char *getenv();
	int	intr();
	extern	char empireport[];
	extern	char empirehost[];
	bit_fdmask mask;
	bit_fdmask savemask;
	struct	passwd *pwd;
	struct	sockaddr_in sin;
	int	n;
	char	*cname;
	char	*pname;
	char	buf[4096];

	mask = bit_newfdmask();
	savemask = bit_newfdmask();
	pwd = getpwuid(getuid());
	if (pwd == NULL) {
		fprintf(stderr, "You don't exist.  Go away\n");
		exit(1);
	}
	if (!hostport(getenv("EMPIREPORT"), &sin) &&
	    !hostport("empire", &sin) &&
	    !hostport(empireport, &sin)) {
		fprintf(stderr, "No empire port\n");
		exit(1);
	}
	if (!hostaddr(getenv("EMPIREHOST"), &sin) && 
	    !hostaddr(empirehost, &sin)) {
		fprintf(stderr, "No empire host\n");
		exit(1);
	}
	if ((sock = hostconnect(&sin)) < 0)
		exit(1);
	cname = NULL;
	if (argc > 1)
		cname = argv[1];
	pname = NULL;
	if (argc > 2)
		pname = argv[2];
	if (!login(sock, pwd->pw_name, cname, pname))
		exit(1);
	mask = bit_newfdmask();
	BIT_SETB(0, savemask);
	BIT_SETB(sock, savemask);
	(void) signal(SIGINT, intr);
	(void) signal(SIGPIPE, SIG_IGN);
	while (BIT_ISSETB(sock, savemask)) {
		bit_copy(savemask, mask);
		n = select(sock+1, mask, 0, 0, 0);
		if (interrupt) {
			if (!handleintr(sock))
				break;
			errno = 0;
			continue;
		}
		if (n < 0) {
			perror("select");
			break;
		}
		if (BIT_ISSETB(0, mask)) {
			n = read(0, buf, sizeof(buf));
			if (n == 0) {
				sendeof(sock);
				continue;
			}
			if (write(sock, buf, n) < 0) {
				perror("game write");
				break;
			}
		}
		if (BIT_ISSETB(sock, mask)) {
			n = read(sock, buf, sizeof(buf));
			if (n < 0) {
				perror("game read");
				break;
			}
			if (n == 0) {
				printf("Game EOF\n");
				break;
			}
			write(1, buf, n);
		}
	}
	exit(0);
}

intr()
{
	interrupt++;
#ifdef hpux
	signal(SIGINT, intr);
#endif
}

int
handleintr(s)
	int	s;
{
	extern	int interrupt;

	if (interrupt) {
		/* tacky, but it works */
		if (write(s, "\naborted\n\r", 1+7+1) <= 0)
			return 0;
		interrupt = 0;
	}
	return 1;
}
