#include <stdio.h>
#include "angband.h"

/* mage order: begin,conj,inca,sorc,mord,raal,kelek,resist,tenser */
/* instead of resist,mord,kelek,tenser,raal */
int magestart[9] =
{0,  9, 18, 26, 49, 33, 44, 54, 38};
int magenrspells[9] =
{9,  9,  8,  7,  5,  5,  5,  5,  6};	/* last 5 blank */

/* priest order: begin,wis,chants,exor,godly,puri,wrath,holy,ether */
/* instead of ether,godly,puri,holy,wrath */
int prieststart[9] =
{0,  8, 16, 25, 52, 31, 36, 46, 41};
int priestnrspells[9] =
{8,  8,  9,  6,  6,  5,  5,  6,  5};	/* last 6 blank */

int find_spell_from_bookidx (int class, int book, int spell);

int
main ()
{
  FILE *spelltab;
  int class, book, spell;
  int spellindex;

  char classname[6][10] =
  {"Warrior", "Mage", "Priest", "Rogue", "Ranger", "Paladin"};
  char magebooks[9][30] =
  {
    "Magik for Beginners",
    "Conjurings and Tricks",
    "Incantations and Illusions",
    "Sorcery and Evocations",
    "Resistance of Scarabtarices",
    "Mordenkainen's Escapes",
    "Kelek's Grimoire of Power",
    "Tenser's Transformations",
    "Raal's Tome of Destruction"};

  char priestbooks[9][30] =
  {
    "Beginners Handbook",
    "Words of Wisdom",
    "Chants and Blessings",
    "Exorcism and Dispelling",
    "Ethereal Openings",
    "Godly Insights",
    "Purifications and Healing",
    "Holy Infusions",
    "Wrath of God"};


  spelltab = fopen ("frits-dumpspells.c", "w");
  fprintf (spelltab, "/* This file was automatically generated from dumptables */\n");
  fprintf (spelltab, "/* spell tables from angband version %d.%d pl %d */\n", CUR_VERSION_MAJ, CUR_VERSION_MIN, CUR_PATCH_LEVEL);

  /*** MANACOST ***/

  fprintf (spelltab, "\n/* manacost[auto_pclass][book][spell] */\n");
  fprintf (spelltab, "\nint manacost[6][9][9] =\n{\n");
  for (class = 0; class < 6; class++)
    {

      fprintf (spelltab, "  /** %s **/\n  {\n", classname[class]);

      for (book = 0; book < 9; book++)
	{
	  if ((class == 1) || (class == 3) || (class == 4))
	    fprintf (spelltab, "    /* %s */\n", magebooks[book]);
	  if ((class == 2) || (class == 5))
	    fprintf (spelltab, "    /* %s */\n", priestbooks[book]);
	  fprintf (spelltab, "    {");

	  for (spell = 0; spell < 9; spell++)
	    {

	      if (class == 0)
		{
		  fprintf (spelltab, " 999");
		}
	      else
		{
		  spellindex = find_spell_from_bookidx (class, book, spell);
		  switch (spellindex)
		    {
		    case -1:
		      fprintf (spelltab, "                               999");
		      break;
		    case -2:
		      fprintf (spelltab, "                               999");
		      break;
		    default:
		      if ((class == 1) || (class == 3) || (class == 4))
			fprintf (spelltab, "/* % 24s */", spell_names[0][spellindex]);
		      else
			fprintf (spelltab, "/* % 24s */", spell_names[1][spellindex]);
		      fprintf (spelltab, " % 3d", magic_spell[class - 1][spellindex].smana);
		      break;
		    }

		}

	      switch (spell)
		{
		case 0:
		case 2:
		case 4:
		case 6:
		  fprintf (spelltab, ",    ");
		  break;
		case 1:
		case 3:
		case 5:
		case 7:
		  fprintf (spelltab, ",\n     ");
		  break;
		case 8:
		  fprintf (spelltab, "\n     ");
		  break;
		}

	    }			/* next spell */

	  fprintf (spelltab, "}");
	  if (book != 8)
	    fprintf (spelltab, ",");
	  fprintf (spelltab, "\n\n");
	}			/* next book */
      fprintf (spelltab, "  }");
      if (class != 5)
	fprintf (spelltab, ",");
      fprintf (spelltab, "\n");
    }				/* next class */
  fprintf (spelltab, "};\n\n");


  /*** SPELL LEVEL ***/

  fprintf (spelltab, "\n/* splevel[auto_pclass][book][spell] */\n");
  fprintf (spelltab, "\nint splevel[6][9][9] =\n{\n");
  for (class = 0; class < 6; class++)
    {

      fprintf (spelltab, "  /** %s **/\n  {\n", classname[class]);

      for (book = 0; book < 9; book++)
	{
	  if ((class == 1) || (class == 3) || (class == 4))
	    fprintf (spelltab, "    /* %s */\n", magebooks[book]);
	  if ((class == 2) || (class == 5))
	    fprintf (spelltab, "    /* %s */\n", priestbooks[book]);
	  fprintf (spelltab, "    {");

	  for (spell = 0; spell < 9; spell++)
	    {
	      if (class == 0)
		{
		  fprintf (spelltab, " 99");
		}
	      else
		{
		  spellindex = find_spell_from_bookidx (class, book, spell);
		  switch (spellindex)
		    {
		    case -1:
		      fprintf (spelltab, "                               99");
		      break;
		    case -2:
		      fprintf (spelltab, "                               99");
		      break;
		    default:
		      if ((class == 1) || (class == 3) || (class == 4))
			fprintf (spelltab, "/* % 24s */", spell_names[0][spellindex]);
		      else
			fprintf (spelltab, "/* % 24s */", spell_names[1][spellindex]);
		      fprintf (spelltab, " % 2d", magic_spell[class - 1][spellindex].slevel);
		      break;
		    }

		}

	      switch (spell)
		{
		case 0:
		case 2:
		case 4:
		case 6:
		  fprintf (spelltab, ",    ");
		  break;
		case 1:
		case 3:
		case 5:
		case 7:
		  fprintf (spelltab, ",\n     ");
		  break;
		case 8:
		  fprintf (spelltab, "\n     ");
		  break;
		}


	    }			/* next spell */

	  fprintf (spelltab, "}");
	  if (book != 8)
	    fprintf (spelltab, ",");
	  fprintf (spelltab, "\n\n");
	}			/* next book */
      fprintf (spelltab, "  }");
      if (class!=5) fprintf(spelltab,",");
      fprintf (spelltab, "\n");
    }				/* next class */
  fprintf (spelltab, "};\n\n");


  fclose (spelltab);
  exit (0);
}

int
find_spell_from_bookidx (class, book, spell)
     int class;
     int book;
     int spell;
{
  int spellindex = -3;

  switch (class)
    {
    case 1:
    case 3:
    case 4:
      /* MAGE */
      if (spell >= magenrspells[book])
	return (-1);
      spellindex = magestart[book] + spell;
      if (magic_spell[class - 1][spellindex].smana == 0)
	return (-2);
      break;

    case 2:
    case 5:
      /* PRIEST */
      if (spell >= priestnrspells[book])
	return (-1);
      spellindex = prieststart[book] + spell;
      if (magic_spell[class - 1][spellindex].smana == 0)
	return (-2);
      break;

    }
  return (spellindex);
}
