;  This file will translate Function key sequences into those expected by
;  MicroEMACS Version 3.10.  Note that termcap entry definitions will take
;  precedence over this but does not cover all keys.
;
; Adapte aux touches de fonction Sun par Bertrand Decouty, decouty@irisa.fr,
;	22/11/89
;  Expected character sequence is ^[[xxxz
;    where the ^[[ is bound to this procedure
;          the xxx is a three digits number
;          the z ends the sequence
;            (the strings below give the code/key mappings)
;
;----------------------------------------------------------------------------
;
;Richard G. Knowles                            richk@pogo.WV.TEK.COM
;Graphics Printing and Imaging          "Richard G Knowles"@email.HUB.TEK.COM
;Tektronix, Inc; D/S 63-356                        (503) 685-3860
;Wilsonville, Or 97070                        or just yell "Hey, Rich!"
;

set %olddiscmd $discmd
set $discmd "FALSE"


set %fkin1 	"23"
set %fkin22 	"456789"
set %fkout22	"123456"
set %fkin23 	"012"
set %fkout23	"789"
set %skin1 	"012"
set %skin20 	"89"
set %skout20	"12"
set %skin21 	"0123456789"
set %skout21	"3456789:;<"
set %skin22 	"012"
set %skout22	"=>?"

store-procedure key-handler
;set $debug "TRUE"
    set %key3  ""
    set %key2  ""
    set %olddiscmd $discmd
    set $discmd "TRUE"
    set %oldmode $cmode
;;  add-mode "EXACT"  -- BAD! causes the cursor to move and mode line updated
    set $cmode &bor $cmode 8
    set %key1 &gtkey	; get lead-in character

    !if &not &sequal %key1 "2"	; esc[2

	!if &sequal %key1 "A"	; esc[A  ^
		set %key "FNP"
		!goto done2
	!endif
	!if &sequal %key1 "B"	; esc[B  v
		set %key "FNN"
		!goto done2
	!endif
	!if &sequal %key1 "C"	; esc[C ->
		set %key "FNF"
		!goto done2
	!endif
	!if &sequal %key1 "D"	; esc[D	<-
		set %key "FNB"
		!goto done2
	!endif
        !goto quit		; not recognized
    !endif

    set %key2 &gtkey	  ; get real function key character
	!if &sequal %key2 "0" 			;  esc [ 20
	        set %key3 &gtkey  
		set %keyx &sindex %skin20 %key3	; esc[20 8/9
		!if %keyx
			set %key &cat "S-FN" &mid %skout20 %keyx 1
			!goto done
		!endif
	        !goto quit	; not recognized
	!endif

	!if &sequal %key2 "1" 			;  esc[21
	        set %key3 &gtkey  
		set %keyx &sindex %skin21 %key3	;  esc[21 0...9
		!if %keyx
			set %key &cat "S-FN" &mid %skout21 %keyx 1
			!goto done
		!endif
	        !goto quit	; not recognized
	!endif

	!if &sequal %key2 "2" 			;  esc[22
	        set %key3 &gtkey  
		set %keyx &sindex %skin22 %key3	;  esc[22 0,1,2
		!if %keyx
			set %key &cat "S-FN" &mid %skout22 %keyx 1
			!goto done
		!endif
		set %keyx &sindex %fkin22 %key3	;  esc[22 4,...,9
		!if %keyx
			set %key &cat "FN" &mid %fkout22 %keyx 1
			!goto done
		!endif
	        !goto quit	; not recognized
	!endif

	!if &sequal %key2 "3" 			;  esc[23
	        set %key3 &gtkey  
		set %keyx &sindex %fkin23 %key3	;  esc[23 0,1,2
		!if %keyx
			set %key &cat "FN" &mid %fkout23 %keyx 1
			!goto done
		!endif
	        !goto quit	; not recognized
	!endif
;
*quit
    write-message &cat &cat &cat &cat "[Unknown function key: ~"esc[" %key1 %key2 %key3 "~" ]"
    insert-string &chr 27
    insert-string "["
    insert-string %key1
    insert-string %key2
    insert-string %key3

    set $cmode %oldmode
    set $discmd %olddiscmd
    !return

; On a decode une touche de fonction  esc[2xx. Normalement, un 'z' doit suivre
*done
    set %lastkey &gtkey			; z ?
    !if &not &sequal %lastkey "z"
	set %key3 &cat %key3 %lastkey 
	!goto quit			; not a 'z'
    !endif
; on a decode une touche de deplacement du curseur. il n'y a pas de 'z'
*done2
    set $cmode %oldmode
    set %func &bind %key
    !if &sequal %func "ERROR"
        write-message &cat &cat "[Unbound function key: ~"" %key "~" ]"
    !else
        !if &sequal &left %func 1 "["  ; procedures are in brackets
            set %func &mid %func 2 &sub &length %func 2
            !force execute-procedure %func ; user procedure
        !else
            !force execute-named-command %func ; try for built-in
        !endif
    !endif
    set $discmd %olddiscmd
;set $debug "FALSE"
!endm

macro-to-key key-handler M-[
set $discmd %olddiscmd

