;  ftex.cmd:	Procedures pour saisie de texte francais en TeX et LaTeX 
;		traitement des lettres accentuees, du c cedille, des
;		ligatures oe et OE et de l'espace force avant : ; ! ?
;		ainsi que les begin/end des environnements LaTeX et les {} ,
;		le "TeXage" du tampon courant ainsi que l'impression du dvi
;		resultant.
;		Version Unix
;		Auteur : Eric Picheral au CICB <picheral@cicb.cicb.fr>
;			18 septembre 1989
;		Modifications: Bertrand Decouty (bd) <decouty@irisa.fr>
;
;	07/11/89: ajout "y" comme reponse positive, en plus de "o"
;	13/11/89: ajout \fguill (>>) et \oguill (<<)
;	14/12/89: ajout set-ftex-mode et unset-ftex-mode (from E. Picheral)
;	          modifs ^X-O ^X-0 ^X-P ==> appel $bufhook (- idem -      )
;	14/02/90: ajout ^X^T (toggle-tex-mode) -bd-
;	14/02/90: ajout traitement environnement math (\[ \] \( \) $ $$) -bd-
;	21/02/90: - modif tex-buffer et tex-print pour qu'il n'y ait pas les log
;		    latex et dvips simultanement a l'ecran;
;		  - prise en compte du fait que les log sont dans ./    -bd-
;    	22/02/90: nouveau latex-cenv (picheral)
;	23/02/90: ajout 'remove-mark' en fin de tex-buffer	(bd)
;	01/03/90: ajout '.dvi' au nom de fichier passe a dvips	(bd)
;	08/03/90: test si $cfname se termine bien par '.tex'	(bd)
;		: ajout mode 'view' au buffer [LaTeX log]	(bd)

;set $discmd FALSE	; on laisse ceci a l'appelant

store-procedure aigu
    !if &or &not %ftex-mode &and &equal $curcol 0 &equal $curline 1
	insert-string "'"
	!return
    !endif
    backward-character
    !if &or &sequal &chr $curchar e &sequal &chr $curchar E
	insert-string &cat &cat "\'{" &chr $curchar "}"
	delete-next-character
    !else
	forward-character
	insert-string "'"
    !endif
!endm

store-procedure grave
    !if &or &not %ftex-mode &and &equal $curcol 0 &equal $curline 1
	insert-string "`"
	!return
    !endif
    backward-character
    !if &greater &sindex "aeuAEU" &chr $curchar 0
	insert-string &cat &cat "\`{" &chr $curchar "}"
	delete-next-character
    !else
	forward-character
	insert-string "`"
    !endif
!endm

store-procedure circ
    !if &or &not %ftex-mode &and &equal $curcol 0 &equal $curline 1
	insert-string "^"
	!return
    !endif
    backward-character

    !if &sequal &chr $curchar i
	insert-string "\^{\i}"
	delete-next-character
    !else
        !if &greater &sindex "aeouAEIOU" &chr $curchar 0
	    insert-string &cat &cat "\^{" &chr $curchar "}"
   	    delete-next-character
	!else
	    forward-character
	    insert-string "^"
	!endif
    !endif
!endm

store-procedure cedille
    !if  &or &not %ftex-mode &and &equal $curcol 0 &equal $curline 1
	insert-string "~~"
	!return
    !endif
    backward-character
    !if &or &sequal &chr $curchar c &sequal &chr $curchar C
	insert-string &cat &cat "\c{" &chr $curchar "}"
	delete-next-character
    !else
	forward-character
	insert-string "~~"
    !endif
!endm

store-procedure trema
    !if &or &not %ftex-mode  &and &equal $curcol 0 &equal $curline 1
	insert-string "#"
	!return
    !endif
    backward-character
    !if &sequal &chr $curchar i
	insert-string "\~"{\i}"
	delete-next-character
    !else
	!if &greater &sindex "euEIU" &chr $curchar 0
	    insert-string &cat &cat "\~"{" &chr $curchar "}"
            delete-next-character
    	!else
	    forward-character
	    insert-string "#"
	!endif
    !endif
!endm

store-procedure ligat-oe
    !if &or &not %ftex-mode  &and &equal $curcol 0 &equal $curline 1
	insert-string &chr $lastkey
	!return
    !endif
    backward-character
    !if &sequal &chr $curchar o
	print ""
	set %fligat @"ligature oe ? (o/n, [o])"
	!if &or &sequal %fligat "o" &or &sequal %fligat "y" &equal &length %fligat 0
	    insert-string "\oe{}"
	    delete-next-character
	!else
	    forward-character
	    insert-string "e"
	!endif
    !else
	forward-character
	insert-string "e"
    !endif
!endm


store-procedure ligat-OE
    !if &or &not %ftex-mode  &and &equal $curcol 0 &equal $curline 1
	insert-string &chr $lastkey
	!return
    !endif
    backward-character
    !if &sequal &chr $curchar O
	print ""
	set %fligat @"ligature oe ? (o/n, [o])"
	!if &or &sequal %fligat "o" &or &sequal %fligat "y" &equal &length %fligat 0
	    insert-string "\OE{}"
	    delete-next-character
	!else
	    forward-character
	    insert-string "E"
	!endif
    !else
	forward-character
	insert-string "E"
    !endif
!endm

;
; << --> \oguill
;
store-procedure oguill
    !if &or &not %ftex-mode &and &equal $curcol 0 &equal $curline 1
	insert-string "<"
	!return
    !endif

    backward-character
    !if &sequal &chr $curchar <
	insert-string "\oguill "
	delete-next-character
    !else
	forward-character
	insert-string "<"
    !endif
!endm
;
; >> --> \fguill
;
store-procedure fguill
    !if &or &not %ftex-mode &and &equal $curcol 0 &equal $curline 1
	insert-string ">"
	!return
    !endif

    backward-character
    !if  &sequal &chr $curchar >
	insert-string "\fguill "
	delete-next-character
    !else
	forward-character
	insert-string ">"
    !endif
!endm

store-procedure dbl-ponct
    !if &or &not %ftex-mode  &and &equal $curcol 0 &equal $curline 1
	insert-string &chr $lastkey
	!return
    !endif
    backward-character
    !while &or &equal $curchar 32 &sequal &chr $curchar "~t"
	delete-next-character
	backward-character
    !endwhile
    !if &not &sequal &chr $curchar "~~"
	forward-character
	insert-string "~~"
    !else
	forward-character
    !endif
    insert-string &chr $lastkey
!endm

store-procedure tex-braces
	insert-string "{}"
	backward-character
!endm

store-procedure tex-cbrace
    set %pile 1
    set-mark
    end-of-file
    set %ff $curline
    goto-mark
    !while &greater %pile 0
	!if &equal $curchar &ascii "{"
	    backward-character
	    !if &not &equal $curchar &ascii "\"
		set %pile &add %pile 1
	    !endif
	    forward-character
	!endif
	!if &equal $curchar &ascii "}"
	    backward-character
	    !if &not &equal $curchar &ascii "\"
		set %pile &sub %pile 1
	    !endif
	    forward-character
	!endif
	!if &equal %ff $curline
	    print "accolade } manquante"
	    goto-mark
	    !return
	!endif
	forward-character
    !endwhile
!endm

store-procedure latex-style
	open-line
	beginning-of-file
	set %style @"style de document ?"
	set %options @"options ?"
	!if &greater &length %options 0
	    set %options1 &cat &cat "[" %options "]"
	!else
	    set %options1 ""
	!endif
	insert-string &cat &cat &cat &cat "\documentstyle" %options1 "{" %style "}~n~n"
	insert-string "\begin{document}~n"
	9 set-mark
	end-of-file
	insert-string "~n\end{document}~n"
	9 goto-mark
!endm

store-procedure latex-env
	set %group @"environnement ?"
	insert-string &cat &cat "~n\begin{" %group "}~n~n\end{"
	insert-string &cat  %group "}~n"
	2 previous-line
!endm
;
store-procedure latex-cenv
	set $discmd FALSE
	set %error FALSE
	0 set-mark
	end-of-file
	set %dlig $curline
	set %dcol $curcol
	0 goto-mark
	set %svmode $cmode
	add-mode "magic"
	!while &not %error
	    test-begin-end
	    !if &sequal %marque begin
	        saut-end-env
	    !else
	        !if &sequal %marque end
		    set $cmode %svmode
		    set $discmd TRUE
	            !return
		!endif
	    !endif
	!endwhile
        print "\\end{...} manquant"
	0 goto-mark
	set $cmode %svmode
	set $discmd TRUE
!endm

store-procedure saut-end-env
	set %pile 1
	!while &greater %pile 0
	    test-env
	    !if %error
	        !return
	    !endif
	    !if &sequal %ee begin
	        set %pile &add %pile 1
	    !else
	        !if &sequal %ee end
		    set %pile &sub %pile 1
		!else
		    set %error TRUE
		    !return
		!endif
	    !endif
	!endwhile
!endm

store-procedure test-env    
    set %ligb %dlig
    set %colb %dcol
    2 set-mark
    !force search-forward &cat &cat "\\begin *{" %env "}"
    !if $status
        1 set-mark
        set %ligb $curline
	set %colb $curcol
	2 goto-mark
    !endif
    !force search-forward &cat &cat "\\end *{" %env "}"
    !if $status
	!if &greater $curline %ligb
	    set %ee begin
	    1 goto-mark
	!else
	    !if &sequal $curline %ligb
	        !if &greater $curcol %colb
		    set %ee begin
		    1 goto-mark
		!else
		    set %ee end
		!endif
	    !else
	        set %ee end
	    !endif
	!endif
    !else
	set %error TRUE
	set %ee ""
	!return
    !endif
!endm

store-procedure test-begin-end
    set %ligb %dlig
    set %colb %dcol
    2 set-mark
    !force search-forward "\\begin *{[^{]*}"
    !if $status
        1 set-mark
	set %ligb $curline
	set %colb $curcol
	set %env $match
	set %finenv &length %env
	set %debenv &add &sindex %env "{" 1
	set %env &mid %env %debenv &sub %finenv %debenv
	2 goto-mark
    !endif
    !force search-forward "\\end *{[^{]*}"
    !if $status
	!if &greater $curline %ligb
	    set %marque begin
	    1 goto-mark
	!else
	    !if &equal $curline %ligb
	        !if &greater $curcol %colb
		    set %marque begin
		    1 goto-mark
		!else
		    set %marque end
		!endif
	    !else
	        set %marque end
	    !endif
	!endif
    !else
	set %marque ""
	set %error TRUE	    
    !endif
!endm

store-procedure tex-buffer
	set %unique &right $cfname 4
	!if &not &seq %unique ".tex"
		print "[Le fichier doit avoir le suffixe '.tex']"
		!return
	!endif
	set %ligerr $curline
    beginning-of-file
    0 set-mark
    set %svmode $cmode
    add-mode "magic"
    search-forward "[^ ^~t^~r]"
    set $cmode %svmode
    backward-character
    kill-region
    set $line &trim $line
    !if &equal &sindex $line "\documentstyle" 1
	set %appeltex "latex "
    !else
	set %appeltex "tex "
    !endif
    open-line
    insert-string "\batchmode"
	set %unique &mid $cfname 1 &sub &len $cfname 4 ; extraction prefixe
;	set %logtex &cat %unique ".log"
	save-file
	!force shell-command &cat  %appeltex $cfname
; on enleve la ligne \batchmode
	beginning-of-file
	kill-to-end-of-line
	kill-to-end-of-line
	save-file
	set %curbuf $cbufname
; destruction du buffer "command" (qui peut contenir dvips.log).
	set %bufname "command"
	run set-window
	!if %found
		delete-window
	!endif
; si buffer courant = Function Keys, on le resize et on change de fenetre
	!if &sequal $cbufname "Function Keys"
		!force 5 resize-window
		set %bufname %curbuf
		run set-window	; en principe, elle existe puisqu'on en vient!
	!endif
; recherche de la fenetre [LaTeX log]. 
; Si elle n'existe pas, on la cree a partie de la fenetre d'appel
	set %read $readhook
	set %buf  $bufhook
	set $readhook nop
	set $bufhook nop
	set %bufname "[LaTeX log]"
	run set-window
	!if &not %found
		split-current-window
	!endif
	select-buffer "[LaTeX log]"
	delete-mode "view"
	beginning-of-file
	set-mark
	end-of-file
	kill-region
	unmark-buffer
; creation du nom du .log qui est dans le repertoire courant.
	set %radix %unique
*loop
	set %pos &sindex %radix "/"	; recherche du 1er "/"
	!if &not &equ %pos 0		; s'il existe, on conserve ce qui suit
		set %radix &right %radix &sub &len %radix %pos
		!goto loop
	!endif
	read-file &cat %radix ".log"
	set $readhook %read
	set $bufhook %buf
	add-mode "exact"
	add-mode "magic"
	add-mode "view"
    !force search-forward "^l\.[0-9][0-9]* "
	!if $status
		set %ligerr &mid $match 3 &sub &length $match 2
		set %ligerr &sub %ligerr 1 ; on a rajoute une ligne dans .tex!
		write-message "[Erreur(s) de'tecte'e(s)]"
	!else
		write-message "[Pas d'erreur]"
	!endif
; on se repositionne dans la fenetre d'appel
	set %bufname %curbuf 
	run set-window
	%ligerr goto-line
; on enleve la marque 0, pour eviter un ^W intempestif
	remove-mark
!endm

; recherche de la prochaine erreur en avant
store-procedure error-fwd
	set %search-fw TRUE
	run tex-error
!endm

; recherche de la prochaine erreur en arriere
store-procedure error-rev
	set %search-fw FALSE
	run tex-error
!endm

; procedure de recherche de la prochaine erreur
; recherche en avant si %search-fwd TRUE, en arriere sinon
;
store-procedure tex-error
	set %curbuf $cbufname
	set %ligerr $curline
; recherche de la fenetre "[LaTeX log]"
	set %bufname "[LaTeX log]"
	run set-window
	!if &not %found
		write-message "[Executez LaTeX d'abord! (^X^L)]"
		!return
	!endif
	!if %search-fw
		!force search-forward "^l\.[0-9][0-9]* "
		!if $status
			set %ligerr &mid $match 3 &sub &length $match 3
			set %ligerr &sub %ligerr 1 ; on a rajoute une ligne dans .tex!
		!else
			write-message "[Plus d'erreur]"
		!endif
	!else
		!force search-reverse "^l\.[0-9][0-9]* "
		!if $status
; $match contient le debut du mot suivant alors qu'on est en debut de ligne
; bug ???
			delete-mode "view"
			next-word
			set $kill ""
			delete-next-word
			yank
			beginning-of-line
			unmark-buffer
			add-mode "view"
			set %ligerr $kill
                        set %ligerr &sub %ligerr 1 ; on a rajoute une ligne dan$
		!else
			write-message "[Plus d'erreur]"
		!endif
	!endif
	set %bufname %curbuf
	run set-window
	%ligerr goto-line
!endm

store-procedure tex-print
;set $debug TRUE
	set %buf $bufhook
	set %read $readhook
	set $bufhook nop
	set $readhook nop
	set %curbuf $cbufname
	set %unique &mid $cfname 1 &sub &len $cfname 4 ; extraction prefixe
; extraction du nom du nom du fichier sans le chemin d'acces
	set %radixdvi %unique
*loop
	set %pos &sindex %radixdvi "/"	; recherche du 1er "/"
	!if &not &equ %pos 0		; s'il existe, on conserve ce qui suit
		set %radixdvi &right %radixdvi &sub &len %radixdvi %pos
		!goto loop
	!endif
; Le fichier %radixdvi.dvi existe-t-il?
	!if &not &exist &cat %radixdvi ".dvi"
		print &cat &cat "Le fichier '" %radixdvi ".dvi' n'existe pas!"
		!goto quit
	!endif
; A-t-on execute' au moins une fois latex (=> %radix == %radixdvi) 
; sur le fichier courant?
	!if &not &seq %radix %radixdvi
		print "LaTeX n'a pas e'te' exe'cute' sur ce fichier. On imprime quand me^me (o/n)? "
		set %key &gtk
		!if &not &or &seq %key "o" &seq %key "y"
			print "[Annule']"
			!goto quit
		!endif
	!endif
; On regarde s'il ne faudrait pas re-executer LaTeX d'abord
	!if &and $cbflags 2        ; Si buffer modifie...
		print "Le fichier a e'te' modifie'. On imprime quand me^me (o/n)? "
		set %key &gtk
		!if &not &or &seq %key "o" &seq %key "y"
			print "[Annule']"
			!goto quit
		!endif
	!endif
; destruction du buffer "command"	-INDISPENSABLE-
	set %bufname "command"
	run set-window
	!if %found
		delete-window
	!endif
; destruction de la fenetre "LaTeX log" - pour plus de clarte
	set %bufname "[LaTeX log]"
	run set-window
        !if %found
                delete-window
        !endif
; si buffer courant = Function Keys, on le resize et on change de fenetre
	!if &sequal $cbufname "Function Keys"
		!force 5 resize-window
		set %bufname %curbuf
		run set-window	; en principe, elle existe puisqu'on en vient!
	!endif
; appel dvips
	write-message "[Appel dvips]"
	!force pipe-command &cat &cat "dvips -d2 " %radixdvi ".dvi 2> dvips.log | lpr"
	!if &not $status	; echec appel/execution dvips
		split-current-window
		find-file "dvips.log"
		name-buffer "command"
	!else
		read-file "dvips.log"
	!endif
	unmark-buffer
	end-of-file		; on se positionne a la fin
	update-screen
	&div $wline 2 move-window-up
	write-message "[Fin]"
;	set %key &gtkey		; inutile d'attendre une reponse
*quit
	set $bufhook %buf
	set $readhook %read
	set %bufname %curbuf
	run set-window
;	clear-message-line
!endm

store-procedure tex-queue
	set %oldcmd	$discmd
	set $discmd FALSE
	9 set-mark
	end-of-file
	update-screen
	shell-command "lpq"
        write-message "[Fin]"
        set %key &gtkey
	9 goto-mark
	set $discmd %oldcmd
!endm
;
store-procedure set-ftex-mode
	set $discmd FALSE
	macro-to-key aigu "'"
	macro-to-key grave "`"
	macro-to-key circ "^"
	macro-to-key cedille ~~
	macro-to-key trema "#"
	macro-to-key ligat-oe "e"
	macro-to-key ligat-OE "E"
	macro-to-key dbl-ponct "!"
	macro-to-key dbl-ponct "?"
	macro-to-key dbl-ponct ":"
	macro-to-key dbl-ponct ";"
	macro-to-key open-math "["
	macro-to-key open-math "("
	macro-to-key close-math "]"
	macro-to-key close-math ")"
	macro-to-key dollar	"$"
	macro-to-key tex-braces M-{
	macro-to-key tex-cbrace M-}
	macro-to-key latex-style ^X^A
;	macro-to-key latex-env	^X^G		; pour compatibilite CICB
	macro-to-key latex-env	^X^E		; E pour environnement
	macro-to-key latex-cenv ^X^H
	macro-to-key tex-buffer	^X^L		; L pour LaTeX
	macro-to-key tex-buffer ^XT		; pour compatibilite CICB
	macro-to-key error-fwd	^X^N
	macro-to-key error-rev	^X^P
	macro-to-key tex-print 	^X^D		; D pour dvips
	macro-to-key tex-queue 	^XQ		; pour compatibilite CICB
	macro-to-key tex-queue	^X^Q
	macro-to-key toggle-tex-mode ^X^T	; 14/02/90 - T pour toggle
	macro-to-key oguill 	"<"
	macro-to-key fguill 	">"
; macro communes
	macro-to-key 	eacute		""	; alt-e
	macro-to-key 	egrave		""	; alt-g
	macro-to-key 	ugrave		""	; alt-u
	macro-to-key 	ccedille	""	; alt-c
	macro-to-key 	agrave		""	; alt-a
	macro-to-key 	eflex		""	; alt-6
	macro-to-key 	itrema		""	; alt-i
	macro-to-key	insbegin	""	; alt-B
	macro-to-key	insend		""	; alt-E
	macro-to-key	insitem		""	; alt-I
; macro-to-key pour uniterm (emul vt220 sur atariST) 
;              clavier par defaut et clavier VT220
	!if &seq &env "TERM" "uniterm"
		macro-to-key eacute	""	; e accent aigu 	(VT)
		macro-to-key egrave	""	; e accent grave	(VT)
		macro-to-key ugrave	""	; u accent grave	(VT)
		macro-to-key ccedille	""	; c cedille		(VT)
		macro-to-key agrave	""	; a accent grave	(VT)
		macro-to-key itrema	""	; i trema (en fait trema seul)
		macro-to-key eflex	""	; e circonflex (paragraphe)
; pour uniterm en config de clavier standard (codes generes=codes Atari ST)
		macro-to-key eacute	""
		macro-to-key egrave	""
		macro-to-key ugrave	""
		macro-to-key ccedille	""
		macro-to-key agrave	""
		macro-to-key eflex	""
; pour uniterm en mode Meta (alt-CapsLock)
		macro-to-key instilde	""	; ~ = alt-|
		macro-to-key insarob	""	; @ = alt-#
		macro-to-key inscro1	""	; [ = alt-^
		macro-to-key inscro2	""	; ] = alt-$
		macro-to-key insaco2	""	; } = alt-*
; alt-trema et alt-ugrave generent le meme code!
; => pour avoir les caracteres \ et { enlever le mode Meta 
	!endif
	set %ftex-mode TRUE
	write-message "fTeX mode ON"
	set $discmd TRUE
!endm
;
;
store-procedure instilde
	insert-string "~~"
!endm
;
store-procedure insarob
	insert-string "@"
!endm
;
store-procedure insbacksla
	insert-string "\"
!endm
;
store-procedure inscro1
	insert-string "["
!endm
;
store-procedure inscro2
	insert-string "]"
!endm
;
store-procedure insaco1
	insert-string "{"
!endm
;
store-procedure insaco2
	insert-string "}"
!endm
;
store-procedure eacute
	insert-string "\'{e}"
!endm
;
store-procedure egrave
	insert-string "\`{e}"
!endm
;
store-procedure ugrave
	insert-string "\`{u}"
!endm
;
store-procedure ccedille
	insert-string "\c{c}"
!endm
;
store-procedure agrave
	insert-string "\`{a}"
!endm
;
store-procedure itrema
	insert-string "\~"{\i}"
!endm
;
store-procedure eflex
	insert-string "\^{e}"
!endm
;
store-procedure insbegin
	insert-string "~n\begin{"
!endm
;
store-procedure insend
	insert-string "~n\end{"
!endm
;
store-procedure insitem
	insert-string "~n\item "
!endm
;
store-procedure unset-ftex-mode
	set %ftex-mode FALSE
	write-message "fTeX mode OFF"
; ajouter ici les unbind-key
!endm
;
; traitement des caracteres [ et (
;
store-procedure open-math
	insert-string &chr $lastkey
	!if &equal $curcol 1	; si le caractere est le 1er de la ligne...
	!return
	!endif
	2 backward-character
	!if &sequal &chr $curchar "\"	; si \[ ou \( ...
		unset-ftex-mode
	!endif
	2 forward-character
!endm
;
; traitement des caracteres ] et )
;
store-procedure close-math
	insert-string &chr $lastkey
	!if &equal $curcol 1	; si le caractere est le 1er de la ligne...
	!return
	!endif
	2 backward-character
	!if &sequal &chr $curchar "\"	; si \[ ou \( ...
		set-ftex-mode
	!endif
	2 forward-character
!endm
;
; traitement du caractere $ (et $$)
;
store-procedure dollar
	insert-string &chr $lastkey
	!if &sequal $curcol 1	; si le caractere est le 1er de la ligne...
		toggle-tex-mode
		!return
	!endif
	2 backward-character
	!if &sequal &chr $curchar "\"  ; si le caractere precedent est un \
		2 forward-character
		!return
	!endif
	!if &not &sequal &chr $curchar "$"	; si car /= $
		toggle-tex-mode
		2 forward-character
		!return
	!endif
; config: $$, on regarde s'il y a un \ avant. Si oui -> toggle, si non: rien
	backward-character
	!if &sequal &chr $curchar "\"
		toggle-tex-mode
	!endif
	3 forward-character
!endm
;
; inverse le mode TeX  - bd, 14/02/90
;
store-procedure toggle-tex-mode
	!if %ftex-mode
		unset-ftex-mode
	!else
		set-ftex-mode
	!endif
!endm
;
store-procedure n-window
	next-window
	winhook
!endm
;
store-procedure p-window
	previous-window
	winhook
!endm
;
store-procedure d-window
	delete-window
	winhook
!endm
;
store-procedure winhook
	!if &sequal $bufhook ""
		!return
	!endif
	!force execute-named-command $bufhook	; bufhook='execute-macro-ii'
	!return
!endm
;
macro-to-key n-window ^XO
macro-to-key p-window ^XP
macro-to-key d-window ^X0
;
set %radix FALSE	; pour tex-print la 1ere fois
write-message "[fTeX mode charg\'{e}]"
;set $discmd TRUE

