; enhance.cmd
;
; MicroEMACS 3.9 macros
;
; In the ^X! macro, note the line that prints "[End]" and wait for a
; keypress; MicroEMACS 3.9e apparently has a bug in that under some OS's,
; including Unix, shell-command always waits for a keystroke after
; running, while in others, such as MS-DOS, it only does so if it's not
; being run from a macro.  Comment that line out if you haven't fixed
; that bug for Unix (it just involves adding an "if (clexec == FALSE)
; {...}" around the four lines of code in spawn.c that wait for the
; keypress).
; 
; I have the contents of enhance.cmd in my .emacsrc; I load spell.cmd when
; I need it with M-x execute-file.
; 
; David MacKenzie
; 
; I.  New bindings
;    A.  ESC-ESC -> execute command line
;    B.  ESC-^X  -> execute current buffer
;    C.  ESC-TAB -> toggle OVERstrike mode
;    D.  ESC-#   -> filter region through a program
; II.  Enhancements to existing bindings
;    B.  ^X! allows response of "!" to repeat previous command
;    C.  ^X^F, ^X^V, ^X^R, ^X^I, ^X^W, ^X^N expand ~/file properly
;    D.  ^X^F, ^X^V, ^X^R, ^X^I check if the file exists only in
;        compressed form (ending with ".Z"), and if so, uncompress it
;
; David MacKenzie
; Latest revision: 09/08/88


; Set up ESC-ESC to execute a macro language command from keyboard.
bind-to-key execute-command-line M-^[

; Set up ESC-Ctrl-X to execute the current buffer.
1 store-macro
    execute-buffer $cbufname
!endm
bind-to-key execute-macro-1 M-^x

; Set up M-TAB to toggle insert/overstrike.
2 store-macro
    set $cmode &bxor $cmode 32
!endm
bind-to-key execute-macro-2 M-^I

; Add !! (repeat previous command) capability to shell-command.
; Activated by a response of "!<Return>".
set %prev-cmd "!"
3 store-macro
    set %shell-cmd @"!"
    !if &sequal %shell-cmd "ERROR"  ; Ctrl-G hit.
        !return
    !endif
    !if &sequal %shell-cmd "!"
        !if &sequal %prev-cmd "!"
            write-message "[No previous command]"
            !return
        !endif
        ; Echo the command we're repeating for reference, a la csh.
        write-message &cat "!"  &cat %prev-cmd "~r~n"; CRLF
        set %shell-cmd %prev-cmd
    !else
        set %prev-cmd %shell-cmd
    !endif
    shell-command %shell-cmd
    write-message "[End]"
    set %rckey &gtkey
!endm
bind-to-key execute-macro-3 ^X!

; If %fname starts with "~/", substitute the value of HOME from environ.
store-procedure tildesub
    ; ~ is MicroEMACS's escape character so we need to escape it.
    !if &sequal &left %fname 2 "~~/"
        set %fname &cat  &env "HOME"  &right %fname &sub &length %fname 1
    !endif
!endm

; If %fname exists only as a compressed file, uncompress it first.
store-procedure zcheck
    !if &and &not &exi %fname  &exi &cat %fname ".Z"
        shell-command &cat "uncompress -v " %fname
    !endif
!endm

; Add tilde substitution on file finding, viewing, etc.
4 store-macro
    set %fname @"Find file: "
    !if &sequal %fname "ERROR"  ; Ctrl-G hit.
        !return
    !endif
    run tildesub
    run zcheck
    find-file %fname
!endm
bind-to-key execute-macro-4 ^X^F

5 store-macro
    set %fname @"View file: "
    !if &sequal %fname "ERROR"
        !return
    !endif
    run tildesub
    run zcheck
    view-file %fname
!endm
bind-to-key execute-macro-5 ^X^V

6 store-macro
    set %fname @"Read file: "
    !if &sequal %fname "ERROR"
        !return
    !endif
    run tildesub
    run zcheck
    read-file %fname
!endm
bind-to-key execute-macro-6 ^X^R

7 store-macro
    set %fname @"Insert file: "
    !if &sequal %fname "ERROR"
        !return
    !endif
    run tildesub
    run zcheck
    insert-file %fname
!endm
bind-to-key execute-macro-7 ^X^I

8 store-macro
    set %fname @"Write file: "
    !if &sequal %fname "ERROR"
        !return
    !endif
    run tildesub
    write-file %fname
!endm
bind-to-key execute-macro-8 ^X^W

9 store-macro
    set %fname @"Name: "
    !if &sequal %fname "ERROR"
        !return
    !endif
    run tildesub
    change-file-name %fname
!endm
bind-to-key execute-macro-9 ^XN

; Filter the region through an external command.
10 store-macro
    set %filt-cmd @"#"
    !if &or  %sequal %filt-cmd "ERROR"  &sequal %filt-cmd ""
        !return
    !endif
    write-message "[Filtering region]"
    kill-region
    2 split-current-window
    select-buffer "[temp]"
    yank
    end-of-file
    delete-previous-character ; Remove unwanted extra newline.
    unmark-buffer

    filter-buffer %filt-cmd

    beginning-of-file
    set-mark
    end-of-file
    kill-region
    unmark-buffer
    delete-window
    yank
    delete-buffer "[temp]"
    write-message "[Region filtered]"
!endm
bind-to-key execute-macro-10 M-#
