/*
 * xmalloc.c --
 *	stubs for system memory allocator to prevent bad things from
 *	happening when malloc fails
 */

#ifndef lint
static char *rcsid =
"$Id: xmalloc.c,v 1.3 1992/07/31 00:12:31 stolcke Exp $ ICSI (Berkeley)";
#endif lint

#include <stdio.h>

#include "sprite.h"
#include "xmalloc.h"
#include "xlog.h"

#undef malloc
#undef realloc

static void
memory_error_and_abort (nbytes)
     int nbytes;
{
  xlog (XLOG_FATAL, "Less than %d bytes of memory left--aborting.\n", nbytes);
  abort ();
}

void *
xmalloc (nbytes)
     int nbytes;
{
  char *temp = malloc (nbytes);

  if (!temp)
    memory_error_and_abort (nbytes);

  return ((void *)temp);
}

void *
xrealloc (pointer, nbytes)
     char *pointer;
     int nbytes;
{
  char *temp = realloc (pointer, nbytes);

  if (!temp)
    memory_error_and_abort (nbytes);

  return ((void *)temp);
}

