#
#  Makefile for the parallel Make program.
#  Note that this Makefile is formatted for PMake itself, rather than make.
#
# This file is to be included by the makefiles in unix, customs and sprite.
#
# Use "make" and "makefile" to compile it the first time...
#
#  $Id: common.mk,v 1.11 1992/04/21 18:19:49 stolcke Exp $ SPRITE (Berkeley)
#
# No makemake.

#
# Path variables:
#	DESTDIR			Installation root
#	BINDIR			where pmake should be installed.
#	LIBDIR			place to store pmake's canned makefiles
#				(e.g. system.mk -- DEFSYSPATH in config.h)
#	SYSTEM_MK    	    	Actual name for the system makefile. I
#				use system.mk.
#	LIBSRC			where the pmake libraries are stored:
#		SPRITEDIR	where the Sprite->UNIX spriteibility
#				library is located.
#		LSTDIR		location of linked-list library
#		INCLUDE		where the sprite include files are
#
DESTDIR		=
BINDIR		= $(DESTDIR)/usr/local/bin
LIBDIR		= $(DESTDIR)/usr/local/lib/pmake
SYSTEM_MK	= system.mk \
		  sys-sun3.mk \
		  sys-sun4.mk \
		  sys-mips.mk \
		  sys-next.mk \
		  sys-hpux.mk

#
# The install program.  You will need something that behaves like
# BSD install, i.e., understands -m, -o and -g flags. Or, you may set this to
# /bin/cp, but then the flag macros below and in customs/Makefile have to be
# set to nothing and permissions will have to be adjusted by hand.
#
#ifdef NeXT
INSTALL		= install -c -u
#else
INSTALL		= install -c
#endif
#
# Install flags for library files
#
LIBMODE		= -m 444

LIBSRC		= ../lib
SPRITEDIR	= $(LIBSRC)/sprite
LSTDIR		= $(LIBSRC)/lst
INCLUDE		= $(LIBSRC)/include
MKDIR		= $(LIBSRC)/mk

#if make(prof) && !defined(sun)
LISTLIB		= -llst_p
SPRITELIB	= -lsprite_p
#else
LISTLIB		= -llst
SPRITELIB	= -lsprite
#endif

#
# FLAG DEFINITIONS -- Flag variables for the various compilers, syntax
# checkers and whatnots
# CCFLAGS are for defining additional flags on the command line...
#
COFLAGS 	=
LDFLAGS		= $(.LIBS) 
LNFLAGS		= -b
XCFLAGS		=
CFLAGS		= $(.INCLUDES) $(XCFLAGS)

#
# SPECIAL TARGETS AND TRANSFORMATION RULES
# Note that the transformation rules from RCS files to standard ones includes
# the removal of any created .o file as well as the checked-out file.
# If you don't like this, nuke it.
#
.SUFFIXES	: .ln
	

.PATH.h		: # Clear out .h path
.PATH.h		: ../src $(LSTDIR) $(INCLUDE)
.PATH.a		: # Clear out .a path
.PATH.a		: $(LSTDIR) 
.PATH.ln	: $(LSTDIR) 
.PATH.c		: ../src

.DEFAULT	:
	co $(.TARGET)

.c.o		: .EXPORTSAME
	$(CC) $(CFLAGS) -c $(.IMPSRC)

#if	!defined(VARS_ONLY)

#
# Alter egos you want to support. smake and vmake both do System V
# impersonations, while just make pretends to be Make
#
#ALIASES		= make smake vmake
ALIASES		= vmake

#
# SOURCE DEFINITIONS -- All Sources for this program:
#
HDRS		= make.h nonints.h ar.h config.h
OBJS		= arch.o compat.o cond.o dir.o make.o job.o main.o parse.o \
		suff.o targ.o rmt.o str.o var.o
SRCS		= arch.c compat.c cond.c dir.c make.c job.c main.c parse.c \
		suff.c targ.c rmt.c str.c var.c
#ifdef SYSV
OBJS		+= utimes.o
SRCS		+= utimes.c
#endif SYSV

LLIBS		= llib-llst.ln
LIBS		= -llst -lsprite

MAKEFILES	= linksprite.mk po.mk makelib.mk makelint.mk shx.mk \
                  makedepend.mk $(SYSTEM_MK)

.MAIN		: pmake

#
# The actual installation of pmake itself is assumed to be done by the
# including makefile, but we need to set up the aliases and install the canned
# makefiles.
#
#if empty(.MAKEFLAGS:M*C*)
install		:: .NOEXPORT
	# Use `pmake -C install'
#else
install		:: installlib
#endif

installlib	:: .NOEXPORT
#if !empty(.MAKEFLAGS:M*C*)
	-mkdir $(LIBDIR)
	for i in $(MAKEFILES); do
	    $(INSTALL) $(LIBMODE) $(MKDIR)/$i $(LIBDIR)/`basename $i`
	done
	for i in  $(ALIASES); do
	    rm -f $(BINDIR)/$i
	    ln -s pmake $(BINDIR)/$i
	done
#endif

nonints		: $(SRCS) .NOTMAIN
	rm -f ../src/nonints.h
	$(LIBSRC)/findni $(.ALLSRC) > /tmp/mni$$
	sed -e 's/(.*)/()/' /tmp/mni$$ > ../src/nonints.h
	chmod 444 ../src/nonints.h
	rm -f /tmp/mni$$

clean		:: .NOTMAIN .NOEXPORT
	rm -f $(OBJS)


tags		: $(HDRS) $(SRCS) .NOTMAIN
	@ctags -u $(.OODATE)

lint		:: $(SRCS) $(LLIBS) .NOTMAIN
	lint $(LNFLAGS) $(CFLAGS) $(.ALLSRC) > FLUFF 2>&1

co		: $(HDRS) $(SRCS) .NOTMAIN
	@chmod 664 $(.OODATE)

ci		: .NOTMAIN
	@ci $(SRCS) $(HDRS) < /dev/tty > /dev/tty 2>&1

#endif

DEPFILE		?= Makefile
#include	<makedepend.mk>

#ifdef HOST
rdist		: $(HDRS) $(SRCS) .NOTMAIN
	rdist -cyw $(SRCS) $(HDRS) $(LSTDIR) $(WILDDIR) \
		$(HOST):/sprite/src/cmds/pmake
#endif HOST
