/*
   dbview.c  : mSQL database structure view utility
               version 0.7 March, 24th 1996
               (C) 1996 Gian Paolo Ciceri
               gp.ciceri@pn.itnet.it

 Usage: dbview [-h host] database [-t table]
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "msql.h"
#define	MAX_LEN 90
#define VERSION "0.7"

void usage(void);
void close_conn(int sock);
int row_count(int sock, char *table);
void print_fields(int sock, char *table);
char *decode_type(int type);
char *decode_flags(int flag);
int main(int argc, char *argv[]);

void usage(void)
{

  (void)fprintf(stderr,"\n\nUsage : dbview [-h host] database [-t table]\n\n");
  exit(-3);
}

void close_conn(int sock)
{
  /* close connection */
  msqlClose(sock);
  printf("\n\nsocket %d closed.\n", sock);
}

int row_count(int sock, char *table)
{
m_result *Selected;
char query[MAX_LEN];
int result = 0;
m_result *FieldList;
m_field  *FieldInfo;
int j;
int numfields = 0;
int rowcount  = 0;
int keyedtable = 0;
int notnull    = 0;

FieldList = msqlListFields(sock, table);
msqlFieldSeek(FieldList, 0);
FieldInfo = msqlFetchField(FieldList);
for (j = 1; (FieldInfo != NULL); j++ )
  {
    if ( !notnull && IS_PRI_KEY(FieldInfo->flags) )
      {
	keyedtable = 1;
	notnull = 1;
	sprintf(query, "select %s from %s", FieldInfo->name, table);
	if ((result = msqlQuery(sock, query))< 0)
	  {
	    printf("\nERROR: Unable to get Row number");
	    printf("\nReturn Code : \t %i\n", result);
	    exit (-1);
	  }
	Selected = msqlStoreResult();
	rowcount =  msqlNumRows(Selected);
	msqlFreeResult(Selected);
      }
    else if ( !notnull && IS_NOT_NULL(FieldInfo->flags) )
      {
	notnull = 1;
	sprintf(query, "select %s from %s", FieldInfo->name, table);
	if ((result = msqlQuery(sock, query))< 0)
	  {
	    printf("\nERROR: Unable to get Row number");
	    printf("\nReturn Code : \t %i\n", result);
	    exit (-1);
	  }
	Selected = msqlStoreResult();
	rowcount =  msqlNumRows(Selected);
	msqlFreeResult(Selected);
      }
    msqlFieldSeek(FieldList, j);
    FieldInfo = msqlFetchField(FieldList);
  }
msqlFreeResult(FieldList);

 if ( !keyedtable && !notnull )
      {
        sprintf(query, "select * from %s", table);
	if ((result = msqlQuery(sock, query))< 0)
	  {
	    printf("\nERROR: Unable to get Row number");
	    printf("\nReturn Code : \t %i\n", result);
	    exit (-1);
	  }
	Selected = msqlStoreResult();
	rowcount =  msqlNumRows(Selected);
	msqlFreeResult(Selected);
      }
return(rowcount);
}

void print_fields(int sock, char *table)
{
  m_result *FieldList;
  m_field  *FieldInfo;
  int j;
  int numfields = 0;
  FieldList = msqlListFields(sock, table);
  msqlFieldSeek(FieldList, 0);
  FieldInfo = msqlFetchField(FieldList);
  printf("Field \t\tType \tLength \tFlags");
  for (j = 1; (FieldInfo != NULL); j++ )
    {
      printf("\n%s \t\t%s \t%i \t%s", FieldInfo->name, decode_type(FieldInfo->type), FieldInfo->length, decode_flags(FieldInfo->flags));
      msqlFieldSeek(FieldList, j);
      FieldInfo = msqlFetchField(FieldList);
      ++numfields;
    }
  if (numfields == 0) printf("\nNo Columns found for Table '%s': perhaps table does not exist.\n", table);
  msqlFreeResult(FieldList);
}


char *decode_type(int type)
{
  if (type == INT_TYPE)  return("INT ");
  if (type == CHAR_TYPE) return("CHAR");
  if (type == REAL_TYPE) return("REAL");
}

char *decode_flags(int flag)
{
  if ( !IS_PRI_KEY(flag) && !IS_NOT_NULL(flag) ) return("");
  if ( !IS_PRI_KEY(flag) && IS_NOT_NULL(flag)  ) return("NOT_NULL");
  if ( IS_PRI_KEY(flag)  && IS_NOT_NULL(flag)  ) return("PRI_KEY NOT_NULL");
}

main(int argc, char *argv[])
{
const char *version= VERSION;
char *hostname = NULL;
char *dbname  = NULL;
char *tabname = NULL;
int conn_sock;
int conn_db;
m_result *TableList;
m_result *FieldList;
m_field *FieldInfo;
int NumTab;
int NumTab2;
int NumField;
m_row TabInfo;
m_row TabInfo_2;
int i = 0;

/* Step 0: parse arguments     */
switch( argc )
  {
  case 2:
      hostname = (char *)getenv("HOSTNAME");
      dbname   = argv[1];
      break;
  case 4:
      if (!strcmp(argv[1],"-h"))
	{
	 hostname = argv[2];
         dbname   = argv[3];
	 break;
       }
      if (!strcmp(argv[2],"-t"))
	{
         hostname = (char *)getenv("HOSTNAME");
	 tabname = argv[3];
         dbname   = argv[1];
	 break;
       }
      usage();
  case 6:
      if (strcmp(argv[1],"-h") || strcmp(argv[4],"-t")) usage();
      hostname = argv[2];
      dbname   = argv[3];
      tabname  = argv[5];
      break;
  default:
      usage();
  }

/* Step 1: get connection      */

/* open connection             */
if ((conn_sock = msqlConnect(hostname)) < 0)
{
  printf("ERROR : %s\n", msqlErrMsg);
  exit(1);
}
  printf("\n - dbview %s - \n", version);
  printf("\n\nConnection Info:\n");
  printf("\nConnected to Server: %s\t socket %d open", hostname, conn_sock);

/* select database & table          */
if ((conn_db = msqlSelectDB(conn_sock, dbname))< 0)
{
  printf("\nERROR: Unable to connect to DB: '%s'\t", dbname);
  printf("\nReturn Code : \t %i\n", conn_db);
  return 0;
}
  printf("\n\nDB selected        : %s", dbname);
  TableList = msqlListTables(conn_sock);
  NumTab = msqlNumRows(TableList);
  printf("\tNumber of Tables in DB %s:   %d", dbname, NumTab);
  printf("\nTable selected     : %s\n", tabname);

/* end of Step 1               */

/* Step 2: get tables          */

/* get table list              */
if (tabname == NULL)
{
  printf("\n\nTable Info:\n\n");
  /* exit if there are no tables */
  if (NumTab == 0)
    {
      printf("\nSorry, no tables.");
      close_conn(conn_sock);
      return 0;
    }

  /* get the table names */
  i = 0;
  for(i = 0; (i < NumTab); ++i)
    {
      msqlDataSeek(TableList, i);
      TabInfo = msqlFetchRow(TableList);
      printf("Table #%d: \t%s \t\t", i, TabInfo[0]);
      printf("Records  : %i\n", row_count(conn_sock, TabInfo[0]));
    }
}
/* end of Step 2               */

/* Step 3: get tables          */
/* get table details           */
printf("\n\nColumn Info:");
if (tabname == NULL)
{
  for(i = 0; i < NumTab; i++)
    {
      msqlDataSeek(TableList, i);
      TabInfo = msqlFetchRow(TableList);
      printf("\n\nColumns of Table #%i: %s\n", i, TabInfo[0]);

      /* get the field names */
      print_fields(conn_sock, TabInfo[0]);
    }
  /* free the result of the query */
  msqlFreeResult(TableList);
}
else
{
 printf("\n\nColumns of Table   : %s", tabname);
 printf("\tNumber of Records  : %d\n\n", row_count(conn_sock, tabname));
 print_fields(conn_sock, tabname);
}

/* close connection */
close_conn(conn_sock);
return(0);
}












