/*
 * m-file.c : File menu routines
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <X11/Intrinsic.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/StringDefs.h>
#include "xarchie.h"
#include "menu.h"

/*
 * Functions defined here:
 */
void initFileMenu();
static void fileMenuCallback();

/*
 * Data defined here:
 */
static Widget fileMenu;

/*	-	-	-	-	-	-	-	-	*/

void
initFileMenu()
{
    fileMenu = createMenu("fileMenu","fileMenuItem",7,NULL,
			  fileMenuCallback);
}

/* Callback procedure */

/*ARGSUSED*/
static void
fileMenuCallback(w,client_data,call_data)
Widget w;
XtPointer client_data;	/* item */
XtPointer call_data;	/* ignored */
{
    int item = (int)client_data;

    switch (item) {
	case 0: /* About */
	    XtCallActionProc(toplevel,"about",NULL,NULL,0);
	    break;
	case 1: /* Open */
	    XtCallActionProc(toplevel,"browser-open-all",NULL,NULL,0);
	    break;
	case 2: /* Get */
	    XtCallActionProc(toplevel,"ftp-get",NULL,NULL,0);
	    break;
	case 3: /* Save */ 
	    XtCallActionProc(toplevel,"file-save",NULL,NULL,0);
	    break;
	case 4: /* Load */ 
	    XtCallActionProc(toplevel,"file-load",NULL,NULL,0);
	    break;
	case 5: /* Write */ 
	    XtCallActionProc(toplevel,"file-write",NULL,NULL,0);
	    break;
	case 6: /* Quit */
	    XtCallActionProc(toplevel,"quit",NULL,NULL,0);
    }
}
