/*
 * appres.h : External defs for files needing the application
 *	resources.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 12 Nov 1991.
 * Version 2.0: 23 Apr 1993.
 */

#ifndef APP_RESOURCES_H
#define APP_RESOURCES_H

#include "types.h"		/* for SearchType and SortType */

typedef struct _AppResources {
    SearchType	searchType;
    SortType	sortType;
    String	archieHost;
    int		numHosts;
    int		maxHits;
    int		offset;
    int		timeout;
    int		retries;
    int		niceLevel;
    String	ftpLocalDir;
    String	ftpType;
    Boolean	ftpPrompt;
    Boolean	ftpTrace;
    Boolean	ftpStrip;
    String	ftpMailAddress;
    int		debugLevel;
    Boolean	fileWriteOnePerLine;
    XFontStruct	*xarchieFont;
    XFontStruct	*xarchieBoldFont;
    String	hostWeights;
    Boolean	autoScroll;
    Boolean	pasteBuffer;
    String	visualType;
    Pixmap	defaultIcon;
    Pixmap	busyIcon;
} AppResources;

extern AppResources appResources;

#endif /* APP_RESOURCES_H */
