/*
 * $Author: djh $ $Date: 1992/07/30 10:00:58 $
 * $Header: /mac/src/cap60/support/capd/RCS/capd.c,v 2.2 1992/07/30 10:00:58 djh Rel djh $
 * $Revision: 2.2 $
 */

/*
 * capd - general purpose CAP daemon
 *
 * djh@munnari.OZ.AU
 *
 */

#include <stdio.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/types.h>
#ifdef PHASE2
#include <sys/socket.h>
#ifndef ultrix
#include <sys/sockio.h>
#endif  ultrix
#include <net/if.h>
#endif PHASE2
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netat/appletalk.h>

extern char interface[50];		/* which ethernet device	*/
extern char this_zone[34];		/* zone for this host		*/
extern struct in_addr bridge_addr;	/* IP address for local bridge	*/
extern byte bridge_node;		/* the local bridge		*/
extern word bridge_net;			/* the local bridge		*/
extern byte this_node;			/* this host node		*/
extern word this_net;			/* this host node		*/
extern byte nis_node;			/* atis running here		*/
extern word nis_net;			/* atis running here		*/
#ifdef PHASE2
extern word net_range_start;		/* phase 2 network range start	*/
extern word net_range_end;		/* phase 2 network range end	*/
#endif PHASE2

extern short lap_proto;			/* our LAP mechanism		*/

int dlevel=0;				/* debug level			*/

main(argc, argv)
int argc;
char *argv[];
{
	int c;
	char *cp, *ep;
	extern int optind;
	extern char *optarg;
	short capdIdent();
	void run();

	while ((c = getopt(argc, argv, "D:d:l:")) != EOF) {
	  switch (c) {
	  case 'D':
	    dlevel = atoi(optarg);
	    if (dlevel > L_LVLMAX)
	      dlevel = L_LVLMAX;
	    break;
	  case 'd':
	    dbugarg(optarg);
	    dlevel = 1;
	    break;
	  case 'l':
	    logitfileis(optarg, "w");
	    break;
	  }
	}
	set_debug_level(dlevel);
	
	openetalkdb(NULL);		/* open/create etalk.local */

	nis_net = this_net = 0;		/* assume that we don't know */
	nis_node = this_node = 0;
	bridge_net = bridge_node = 0;
  	bridge_addr.s_addr = inet_addr("127.0.0.1");

#ifdef PHASE2
	this_net = htons(0xff00);	/* the startup range */
	net_range_start = htons(0);	/* the total range */
	net_range_end = htons(0xfffe);
#endif PHASE2

	lap_proto = capdIdent();

	if (argc == (optind+2)) {
	  /* arg list supplied interface & zone names */
	  strncpy(interface, argv[optind++], sizeof(interface));
	  strncpy(this_zone, argv[optind++], sizeof(this_zone));
	}

	if (optind != argc) {
	  fprintf(stderr,
	    "usage: capd [-D level] [-d opt] [-l log] [interface zone]\n");
	  exit(1);
	}

	if (*interface == '\0') {
	  fprintf(stderr, "No ethernet interface specified\n");
	  exit(1);
	}
	ep = NULL;
	for (cp = interface; *cp != '\0'; cp++) {
	  if (*cp >= '0' && *cp <= '9')
	    ep = cp;
	}
	if (ep == NULL) { /* interface, but no number */
	  fprintf(stderr, "Specified interface invalid: %s\n", interface);
	  exit(1);
	}
	if (*this_zone == '\0') {
	  fprintf(stderr, "No zone name specified\n");
	  exit(1);
	}

	etalkdbupdate(NULL);	/* rewrite gleaned information	*/

	if (!dbug.db_flgs && (dlevel == 0))
	  disassociate();

	run(); /* do all the CAPD work */

	(void)fprintf(stderr, "capd: run() returned!\n");
	exit(1);
}

disassociate()
{
	int i;
	/* disassociate */
	if (fork())
	  _exit(0);			/* kill parent */
	for (i=0; i < 3; i++) close(i); /* kill */
	(void)open("/",0);
#ifdef NODUP2
	(void)dup(0);			/* slot 1 */
	(void)dup(0);			/* slot 2 */
#else  NODUP2
	(void)dup2(0,1);
	(void)dup2(0,2);
#endif NODUP2
#ifdef TIOCNOTTY
	if ((i = open("/dev/tty",2)) > 0) {
	  (void)ioctl(i, TIOCNOTTY, (caddr_t)0);
	  (void)close(i);
	}
#endif TIOCNTTY
#ifdef POSIX
	(void) setsid();
#endif POSIX
}
