/*
 * (re)build/dump CAP desktop files .IDeskTop and .ADeskTop
 *
 * Copyright (c) 1993, The University of Melbourne.
 * All Rights Reserved. Permission to publicly redistribute this
 * package (other than as a component of CAP) or to use any part
 * of this software for any purpose, other than that intended by
 * the original distribution, *must* be obtained in writing from
 * the copyright owner.
 *
 * djh@munnari.OZ.AU
 * 15 February 1993
 * 30 November 1993
 *
 * Refer: "Inside Macintosh", Volume 1, page I-128 "Format of a Resource File"
 *
 * $Author: djh $
 * $Revision: 2.1 $
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/dir.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/fcntl.h>

#ifdef hpux
# include <netinet/in.h>
#endif hpux

/*
 * header for .ADeskTop
 *
 */

struct adt {
  long magic;
  u_char creat[4];
  u_char userb[4];
  long dlen;
  long flen;
  /* names follow */
};

/*
 * header for .IDeskTop
 *
 */

struct idt {
  long magic;
  long isize;
  u_char creat[4];
  u_char ftype[4];
  u_char itype;
  u_char pad1;
  u_char userb[4];
  u_char pad2[2];
  /* bitmap follows */
};

/*
 * headers for .finderinfo files
 *
 */

struct fi {
  u_char ftype[4];
  u_char creat[4];
  u_short flags;
  u_short locn[2];
  u_short win;
  u_short iconID;
  u_short pad[4];
  u_short commID;
  u_long dirID;
};

struct finfo {
  struct fi fi;
  u_short attr;
#define FMAGIC1	255
  u_char magic1;
#define FVERS	0x10
  u_char version;
#define FMAGIC2	0xda
  u_char magic2;
  u_char pad1;
  /* ignore rest */
};

/*
 * headers for .resource files
 *
 */

/* resource hdr */
struct rhdr {
  long rdataOffset;
  long rmapOffset;
  long rdataLength;
  long rmapLength;
  u_char filler[240];
};

/* resource map */
struct rmap {
  u_char filler[24];
  short listOffset;
  short nameOffset;
};

/* resource type list */
struct tlist {
  u_char rtype[4];
  short rnum;
  short roff;
};

/* resource reference list */
struct rlist {
  short rsrcID;
  short nameOffset;
  u_long attrOff;
  u_long handle;
};

/* bundle header */
struct bhdr {
  u_char creat[4];
  u_short version;
  short numType;
};

/* bundle data */
struct bdata {
  u_char btype[4];
  short numID;
};

/* bundle IDs */
struct bids {
  short localID;
  short actualID;
};

/* FREF header */
struct fdata {
  u_char ftype[4];
  short localID;
  /* ignore filename */
};

/* defines */

#define MAGIC	0x00010002
#define IFILE	".IDeskTop"
#define AFILE	".ADeskTop"
#define RSRCF	".resource"
#define FNDRI	".finderinfo"
