static char rcsid[] = "$Author: djh $ $Date: 1993/09/06 02:40:41 $";
static char rcsident[] = "$Header: /mac/src/cap60/applications/lwsrv/RCS/lwsrv.c,v 2.32 1993/09/06 02:40:41 djh Rel djh $";
static char revision[] = "$Revision: 2.32 $";

/*
 * lwsrv - UNIX AppleTalk spooling program: act as a laserwriter
 *  driver: handles setup and farms out incoming jobs
 *
 * AppleTalk package for UNIX (4.2 BSD).
 *
 * Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University in the
 * City of New York.
 *
 * Edit History:
 *
 *  Feb  15, 1987	Schilit		Created, based on lsrv
 *  Mar  17, 1987	Schilit		Fixed nonprintables, added -r
 *  May  15, 1987	CCKim		Add support for LaserPrep 4.0
 *					Make multifork by default (turn
 *					off by defining SINGLEFORK)
 *  Feb	 15, 1991	djh		Various cleanups & patches
 *  Feb  20, 1991	rapatel		improve wait code, add lpr logging
 *  Jan  21, 1992	gkl300		add simple pass thru (for PC's)
 *
 */

/* PATCH: Rutgers1/lwsrv.c.diffs, djh@munnari.OZ.AU, 16/11/90 */
/* PATCH: XENIX/file.3, *UNTESTED* djh@munnari.OZ.AU, 20/11/90 */

char copyright[] = "Copyright (c) 1986, 1987, 1988 by The Trustees of Columbia University in the City of New York";

#include <stdio.h>
#include <ctype.h>
#include <assert.h>
#include <signal.h>
#include <sys/param.h>
#ifndef _TYPES
# include <sys/types.h>			/* assume included by param.h */
#endif  _TYPES
#include <sys/file.h>
#include <sys/ioctl.h>
#ifdef xenix5
#include <sys/ndir.h>
#else xenix5
#include <sys/dir.h>
#endif xenix5
#include <sys/stat.h>
#include <sys/time.h>

#include <netat/appletalk.h>		/* include appletalk definitions */
#include <netat/compat.h>
#include <netinet/in.h>
#include "../../lib/cap/abpap.h"	/* urk, puke, etc */

#ifdef USESTRINGDOTH
# include <string.h>
#else  USESTRINGDOTH
# include <strings.h>
#endif USESTRINGDOTH

#ifdef NEEDFCNTLDOTH
# include <fcntl.h>
#endif NEEDFCNTLDOTH

#include "papstream.h"

#if defined (LWSRV_AUFS_SECURITY) | defined (RUN_AS_USER)
#include <pwd.h>
#endif LWSRV_AUFS_SECURITY | RUN_AS_USER
#ifdef RUN_AS_USER
#ifndef USER_FILE
#define USER_FILE "/usr/local/lib/cap/macusers"
#endif  USER_FILE
#ifndef REFUSE_MESSAGE
#define REFUSE_MESSAGE "/usr/local/lib/cap/refused"
#endif  REFUSE_MESSAGE
#else  RUN_AS_USER
#undef USER_REQUIRED
#endif RUN_AS_USER

private u_char *prtname = NULL;
private char *tracefile = NULL;
private char *fontfile = NULL;
private char *logfile = NULL;
private char *unixpname = NULL;
private char *prttype = "LaserWriter";
private char *dictdir = ".";		/* assume local dir */
private int rflag = FALSE;		/* remove print file */
private int hflag = TRUE;		/* default to print banner */
private int singlefork = FALSE;
private PAPStatusRec *statbuffp;		/* status buffer */
export int capture = TRUE;
export int verbose = 0;
#ifdef PAGECOUNT
export int pagecount;
export int pcopies;
#endif PAGECOUNT

#ifdef __hpux
#define MAXJOBNAME 64
private char username[32],jobname[MAXJOBNAME],jobtitle[MAXJOBNAME];
#else  __hpux
private char username[128],jobname[1024];
#endif __hpux

private char buf[1024];
private int srefnum;

#ifndef TEMPFILE
# define TEMPFILE "/tmp/lwsrvXXXXXX"	/* temporary file holds job */
#endif TEMPFILE

#define RFLOWQ atpMaxNum
#define BUFMAX (PAPSegSize*RFLOWQ)+10

#ifdef LWSRV_AUFS_SECURITY
private int requid, reqgid;
private char *aufsdb = NULL;		/* budd */
char *bin, *tempbin;
int tempbinlen;
#endif LWSRV_AUFS_SECURITY
#ifdef LWSRV_LPR_LOG
private char *requname = NULL;
#endif LWSRV_LPR_LOG
#ifdef NeXT
char *nextdpi = NULL;			/* NeXT printer resolution */
#endif NeXT

#ifdef USESYSVLP
# ifndef LPRCMD
#  define LPRCMD "/usr/bin/lp"
# endif  LPRCMD
#endif USESYSVLP

#ifndef LPRCMD
# ifdef xenix5
#  define LPRCMD "/usr/bin/lpr"
# else xenix5
#  define LPRCMD "/usr/ucb/lpr"
# endif xenix5
#endif  LPRCMD

private char *lprcmd = LPRCMD;

#ifdef LPRARGS
private char *lprargsbuf[16];
private char **lprargs = lprargsbuf;
#endif LPRARGS

private struct printer_instance {
    u_char *prtname;	/* NBP registered printername */
    char *unixpname;	/* UNIX printer name */
    char *tracefile;	/* .. individual tracefile option */
    PAPStatusRec statbuf;
    int srefnum;	/* returned by SLInit */
    char nbpbuf[128];   /* registered name:type@zone */
    int rcomp;		/* flag: waiting for job? */
    int cno;		/* connection number of next job */
} prtlist[NUMSPAP], *prtp;
private int nprt = 0;

private void
usage(s,err) 
char *s,*err;
{
  if (err != NULL)
    fprintf(stderr,"%s: %s\n",s,err);
  fprintf(stderr,"usage: %s -n <PrinterName> -p <unix printer name>\n",s);
  fprintf(stderr,"usage:\t\t-a <DictionaryDirectory> -f <FontFile>\n");
  fprintf(stderr,"usage:\t\t[-l <LogFile>] [-t <TraceFile>] [-r] [-h]\n");
#ifndef LWSRV_AUFS_SECURITY
  fprintf(stderr,"usage:\t\t[-T crtolf] [-T quote8bit]\n\n");
#else LWSRV_AUFS_SECURITY
  fprintf(stderr,"usage:\t\t[-T crtolf] [-T quote8bit] [-X userlogindb]\n\n");
#endif LWSRV_AUFS_SECURITY
  fprintf(stderr,"\t-p*<unix printer name> is the unix printer to print to\n");
  fprintf(stderr,"\t-n*<PrinterName> specifies the name lwsrv registers.\n");
  fprintf(stderr,"\t-a*<DictionaryDirectory> is the ProcSet directory.\n");
  fprintf(stderr,"\t-f*<FontFile> contains an font coordination list.\n");
  fprintf(stderr,"\t-t <Tracefile> stores session and appledict in\n");
  fprintf(stderr,"\t   <Tracefile> without printing.\n");
  fprintf(stderr,"\t-l <LogFile> specifies a file to log the lwsrv session\n");
  fprintf(stderr,"\t-e Allow an eexec to occur in a procset\n");
  fprintf(stderr,"     warning: this may cause problems, use carefully\n");
  fprintf(stderr, "\t-N Turns off capturing of new procsets\n");
  fprintf(stderr,"\t-r Will retain temp print file for inspection\n");
  fprintf(stderr,"\t-h means to print without a banner page\n");
  if (is_simple_dsc()) 
    fprintf(stderr,"\t-A [on*|off] means to turn on or off Adobe document\n");
  else
    fprintf(stderr,"\t-A [on|off*] means to turn on or off Adobe document\n");
  fprintf(stderr,"\tstructuring revision 2 compatibility\n");
  fprintf(stderr,"\t(this can cause problems, *'ed item is default)\n");
  fprintf(stderr,"\t-C <cmd> Specify print spooler rather than lp/lpr\n");
#ifdef LPRARGS
  fprintf(stderr,"\t-L <arg> Argument to pass to lpr (multiple use)\n");
#endif LPRARGS
#ifdef PASS_THRU
  fprintf(stderr,"\t-P lwsrv pass through (no adobe preprocessing)\n");
#endif PASS_THRU
#ifdef NeXT
  fprintf(stderr,"\t-R <dpi> Specify resolution for NeXT printer\n");
#endif NeXT
  fprintf(stderr,"\t-S single lwsrv fork (default is multiforking)\n");
  fprintf(stderr,"\t-T Transcript compatibilty options\n");
  fprintf(stderr,"\t-T crtolf: translate cr to lf for Transcript filters\n");
  fprintf(stderr,"\t-T quote8bit: quote 8 bit chars for Transcript\n");
  fprintf(stderr,"\t-T makenondscconformant: make non DSC conformant: use\n");
  fprintf(stderr,"\t   if psrv only works with DSC 1.0 conventions\n");
#ifdef LWSRV_AUFS_SECURITY
 fprintf(stderr,"\t-X <database directory> use aufs for validation\n");/*budd*/
#endif LWSRV_AUFS_SECURITY
  fprintf(stderr,"\nexample: %s -n Laser -p ps -a/usr/lib/ADicts\n",s);
  fprintf(stderr,"\t\t-f /usr/lib/LW+Fonts\n");
  fprintf(stderr,"\t(note the starred items above are required)\n");
  exit(0);
}

private void
inc_nprt(progname)
char *progname;
{
    
    if (prtp->unixpname == NULL)
      usage(progname,"Missing Unix Printer Name");

    if (prtp->prtname == NULL)
      usage(progname,"Missing AppleTalk Printer Name");

    if (++nprt >= NUMSPAP)
	usage("lwsrv","too many printers");

    prtp++;
    unixpname = tracefile = NULL;
    prtname = NULL;
}
    
private void
doargs(argc,argv)
int argc;
char **argv;
{
  int c;
  extern char *optarg;
  extern int optind;
  extern boolean dochecksum;
  static char optlist[64] = "a:f:l:p:t:d:n:krehNT:A:C:Sv";
#ifdef ISO_TRANSLATE
  void cISO2Mac();
#endif ISO_TRANSLATE
  
#ifdef LWSRV_AUFS_SECURITY
  strcat(optlist, "X:");
#endif LWSRV_AUFS_SECURITY
#ifdef LPRARGS
  strcat(optlist, "L:");
#endif LPRARGS
#ifdef PASS_THRU
  strcat(optlist, "P");
#endif PASS_THRU
#ifdef NeXT
  strcat(optlist, "R:");
#endif NeXT

  nprt = 0; prtp = prtlist;

  while ((c = getopt(argc,argv,optlist)) != EOF) {
    switch (c) {
    case 'a':
      if (index(optarg, '/') == NULL) {
	dictdir = (char *)malloc(strlen(optarg)+4);
	strcpy(dictdir, "./");
	strcat(dictdir, optarg);
      } else 
	dictdir = optarg;	/* remember dictionary directory */
      break;
    case 'd':
      dbugarg(optarg);
      break;
    case 'f':
      fontfile = optarg;		/* -f fontfile */
      break;
    case 'l':				/* -l logfile */
      logfile = optarg;
      break;
    case 'n':				/* lwsrv printer name */
      if (prtname != NULL)
	inc_nprt(argv[0]);
#ifdef ISO_TRANSLATE
      cISO2Mac(optarg);
#endif ISO_TRANSLATE
      prtp->prtname = prtname = (u_char *)optarg;
      break;
    case 'p':				/* -p unix printer name */
      if (unixpname != NULL)
	inc_nprt(argv[0]);
      prtp->unixpname = unixpname = optarg;
      break;
    case 'k':				/* no DDP checksum */
      dochecksum = 0;
      break;
    case 'h':
      hflag = FALSE;			/* do not print banner */
      break;
    case 'r':				/* do not remove file */
      rflag = TRUE;
      break;
    case 't':				/* -t tracefile */
      prtp->tracefile = tracefile = optarg;
      break;
    case 'e':
      setflag_encrypted_instream(TRUE);	/* maybe "eexec" in code */
      break;
    case 'T':
      if (simple_TranscriptOption(optarg) < 0)
	usage(argv[0], NULL);
      break;
    case 'A':
      if (simple_dsc_option(optarg) < 0)
	usage(argv[0], NULL);
      break;
    case 'C':
      lprcmd = optarg;
      break;
#ifdef LPRARGS
    case 'L':
      *lprargs++ = optarg;
      break;
#endif LPRARGS
#ifdef PASS_THRU
    case 'P':
      set_simple_pass_thru();		/* -P pass through PC jobs */
      break;
#endif PASS_THRU
    case 'S':
      singlefork = TRUE;
      fprintf(stderr, "lwsrv: single fork\n");
      break;
#ifdef LWSRV_AUFS_SECURITY
    case 'X':				/* budd... */
      aufsdb = optarg;
      fprintf(stderr, "lwsrv: aufs db directory in %s\n", aufsdb );
      break;				/* ...budd */
#endif LWSRV_AUFS_SECURITY
#ifdef NeXT
    case 'R':
      nextdpi = optarg;
      break;
#endif NeXT
    case 'N':
      capture = FALSE;
      break;
    case 'v':
      verbose++;
      break;
    case '?':				/* illegal character */
      usage(argv[0],NULL);		/* usage and exit */
      break;
    }
  }
  if (optind < argc) {
    fprintf(stderr, "%s: surplus arguments starting from \"%s\"\n",
      argv[0],argv[optind]);
    usage(argv[0], NULL);
  }

  inc_nprt(argv[0]);

  if (fontfile == NULL)
    usage(argv[0],"No FontFile specified");    
#ifdef LPRARGS
  *lprargs = NULL;
  lprargs = lprargsbuf;
#endif LPRARGS

}

void 
set_printer(p)
struct printer_instance *p;
{
    prtname = p->prtname;
    unixpname = p->unixpname;
    tracefile = p->tracefile;
    statbuffp = &(p->statbuf);
    srefnum = p->srefnum;
}
    
private void
childdone()
{
  WSTATUS status;

  (void)wait(&status);
  signal(SIGCHLD, childdone);
}

/*
 * delete the NBP name
 *
 */

private int is_child = 0;

private void
cleanup()
{
    int i;

    if (is_child)
      exit(0);

    for (i=0; i<nprt; i++) {
	srefnum = prtlist[i].srefnum;
	SLClose(srefnum);		/* close server for child */
	PAPRemName(srefnum, prtlist[i].nbpbuf);
    }
    exit(0);
}

openlogfile()
{
    int i;

    if (logfile != NULL) {
      if ((i = open(logfile,O_WRONLY|O_APPEND)) < 0) {
	if ((i = creat(logfile,0666)) < 0) {
	  fprintf(stderr, "Cannot open/create logfile (%s)\n", logfile);
	  exit(1);
	}
      }
      if (i != 2) {
#ifndef NODUP2
	(void) dup2(i,2);
#else   NODUP2
	close(2);			/* try again */
	(void) dup(0);			/* for slot 2 */
#endif  NODUP2
	(void) close(i);
      }
#ifdef LWSRV_LPR_LOG	/* Set up logfile to be also stdout/stderr for lpr */
#ifdef NODUP2
      close(1);
      dup(2);
#else  NODUP2
      dup2 (2, 1);
#endif NODUP2
#endif LWSRV_LPR_LOG
    }
}

main(argc,argv)
int argc;
char **argv;
{
  int err,i,cno,errcount;
  int prtno,prtcount;
  void cleanup();
  void childdone();
#ifdef ISO_TRANSLATE
  void cMac2ISO(), cISO2Mac();
#endif ISO_TRANSLATE

  doargs(argc,argv);			/* handle args */
  
#ifdef LWSRV_AUFS_SECURITY
  requid = getuid();			/* budd */
  reqgid = getgid();			/* budd */
#endif LWSRV_AUFS_SECURITY

#ifdef AUTHENTICATE
  if (nprt == 1)
    initauthenticate(*argv, (char *)prtlist[0].prtname);
#endif AUTHENTICATE

  signal(SIGHUP, cleanup);
  signal(SIGINT, cleanup);
  signal(SIGQUIT, cleanup);
  signal(SIGTERM, cleanup);

  if (!dbug.db_flgs) {			/* disassociate */
    if (fork())
      exit(0);				/* kill off parent */
    for (i=0; i < 20; i++)
      close(i);				/* close all files */
    (void) open("/dev/null",0);
#ifndef NODUP2
    (void) dup2(0,1);
#else   NODUP2
    (void)dup(0);			/* for slot 1 */
#endif  NODUP2
    if (logfile == NULL) {
#ifndef NODUP2
      (void) dup2(0,2);
#else   NODUP2
      (void) dup(0);			/* for slot 2 */
#endif  NODUP2
    } else
      openlogfile();
#ifndef POSIX
#ifdef TIOCNOTTY
    if ((i = open("/dev/tty",2)) > 0) {
      ioctl(i, TIOCNOTTY,(char *) 0);
      close(i);
    }
#endif TIOCNOTTY
#ifdef xenix5
    /*
     * USG process groups:
     * The fork guarantees that the child is not a process group leader.
     * Then setpgrp() can work, whick loses the controllong tty.
     * Note that we must be careful not to be the first to open any tty,
     * or it will become our controlling tty.  C'est la vie.
     */
    setpgrp();
#endif xenix5
#else  POSIX
    (void) setsid();
#endif POSIX
  }

/*  dbug.db_pap = TRUE; */
  
  abInit(FALSE);		/* initialize appletalk driver */
  nbpInit();			/* initialize NBP routines */
  PAPInit();			/* init PAP printer routines */

  set_printer(&prtlist[0]);	/* for definiteness */
#ifdef ISO_TRANSLATE
  cMac2ISO(prtname);
  fprintf(stderr,"lwsrv: Spooler starting for %s.%s.*\n",
    (char *)prtname, prttype);
  cISO2Mac(prtname);
#else  ISO_TRANSLATE
  fprintf(stderr,"lwsrv: Spooler starting for %s.%s.*\n",
    (char *)prtname, prttype);
#endif ISO_TRANSLATE
  if (!spool_setup(tracefile, fontfile, (char *)prtname, dictdir)) {
    usage(argv[0]);
    exit(1);
  }

  if (!singlefork)
    signal(SIGCHLD, childdone);

  errcount = 0;
  for (prtp=prtlist,i=0; i<nprt; prtp++,i++) {
      sprintf(prtp->nbpbuf,"%s:%s@*",(char *)prtp->prtname,prttype);
      cpyc2pstr(prtp->statbuf.StatusStr,"status: idle");
      err = SLInit(&(prtp->srefnum), prtp->nbpbuf, 8, &(prtp->statbuf));
      if (err != noErr) {
#ifdef ISO_TRANSLATE
	 cMac2ISO(prtp->nbpbuf);
         fprintf(stderr,"lwsrv: SLInit %s failed: %d\n", prtp->nbpbuf, err);
	 cISO2Mac(prtp->nbpbuf);
#else  ISO_TRANSLATE
         fprintf(stderr,"lwsrv: SLInit %s failed: %d\n", prtp->nbpbuf, err);
#endif ISO_TRANSLATE
	 errcount++;
      }
      /* GetNextJob is asynchronous, so call it for each printer */
      err = GetNextJob(prtp->srefnum, &(prtp->cno), &(prtp->rcomp));
      if (err != noErr) {
#ifdef ISO_TRANSLATE
	cMac2ISO(prtp->prtname);
        fprintf(stderr,"lwsrv: GetNextJob %s failed: %d\n",
	  (char *)prtp->prtname, err);
	cISO2Mac(prtp->prtname);
#else  ISO_TRANSLATE
        fprintf(stderr,"lwsrv: GetNextJob %s failed: %d\n",
	  (char *)prtp->prtname, err);
#endif ISO_TRANSLATE
        errcount++;
      }
#ifdef ISO_TRANSLATE
      cMac2ISO(prtp->nbpbuf);
      fprintf(stderr, "lwsrv: %s ready and waiting\n", prtp->nbpbuf);
      cISO2Mac(prtp->nbpbuf);
#else  ISO_TRANSLATE
      fprintf(stderr, "lwsrv: %s ready and waiting\n", prtp->nbpbuf);
#endif ISO_TRANSLATE
  }

  if (errcount == nprt) {
    fprintf(stderr, "lwsrv: no printers successfully registered!\n");
    exit(1);
  }

  prtno = 0; prtcount = 0;
  while (TRUE) {
#ifdef LWSRV_AUFS_SECURITY
    AddrBlock addr;			/* budd */
#endif LWSRV_AUFS_SECURITY
    openlogfile();
    NewStatus("idle");

  /* scan each printer in turn, processing each one as "normal" if there
   * is work available. If no work was available then abSleep for a while
   */
    while (prtno<nprt && prtlist[prtno].rcomp > 0) prtno++;
    if (prtno == nprt) {
	if (prtcount == 0) {
	    abSleep(20,TRUE);	/* wait for some work */
        }
        prtno = 0;	/* start scan again */
        continue;
    }

    prtp = &prtlist[prtno];
    set_printer(prtp); 	/* set the global variables etc */
    cno = prtp->cno;

    /* GetNextJob is asynchronous, so announce readiness for more work */
    /* WTR: is this right - should it depend on singlefork? */
    err = GetNextJob(prtp->srefnum, &(prtp->cno), &(prtp->rcomp));
    if (err != noErr) {
#ifdef ISO_TRANSLATE
      cMac2ISO(prtp->prtname);
      fprintf(stderr,"lwsrv: GetNextJob %s failed: %d\n",
	(char *)prtp->prtname, err);
      cISO2Mac(prtp->prtname);
#else  ISO_TRANSLATE
      fprintf(stderr,"lwsrv: GetNextJob %s failed: %d\n",
	(char *)prtp->prtname, err);
#endif ISO_TRANSLATE
    }

#ifdef ISO_TRANSLATE
    cMac2ISO(prtname);
    fprintf(stderr,"lwsrv: Starting print job for %s\n", (char *)prtname);
    cISO2Mac(prtname);
#else  ISO_TRANSLATE
    fprintf(stderr,"lwsrv: Starting print job for %s\n", (char *)prtname);
#endif ISO_TRANSLATE

#ifdef LWSRV_AUFS_SECURITY
    /*** budd.... */
    if ((err = PAPGetNetworkInfo(cno, &addr)) != noErr)
      fprintf(stderr, "Get Network info failed with error %d", err);
    else
      fprintf(stderr,"Connection %d from [Network %d.%d, node %d, socket %d]\n",
	      cno, nkipnetnumber(addr.net),
	      nkipsubnetnumber(addr.net),
	      addr.node, addr.skt);

    if( aufsdb != NULL ) {
	char fname[ 256 ];
	char filename[ 256 ];
	int f, cc, ok = 0;
	struct passwd *pw;
	struct stat statbuf;
#ifdef HIDE_LWSEC_FILE
	char protecteddir[MAXPATHLEN];
	(void) strcpy(protecteddir, aufsdb);
	make_userlogin(filename, protecteddir, addr);
	(void) strcpy(protecteddir, filename);
	filename[0] = '\0';
	make_userlogin(filename, protecteddir, addr);
#else  HIDE_LWSEC_FILE
	make_userlogin( filename, aufsdb, addr );
#endif HIDE_LWSEC_FILE

	if( (f = open( filename, 0)) >= 0) {
	   if( (cc = read( f, fname, sizeof( fname )-1 )) > 0 ) {
	    if( fname[cc-1] == '\n' )
		fname[cc-1] = '\0';
	    fprintf( stderr, "Found username in aufsdb (%s): %s\n",
		    aufsdb, fname );

	    if ((tempbin = rindex(fname,':')) != NULL) {
	      *tempbin='\0';
	      tempbin++;
	      bin=(char *) malloc(strlen(tempbin)+1);
	      strcpy(bin,tempbin);
	    }
	    
	    (void) stat(filename, &statbuf);
	    if ( (pw = getpwuid((int) statbuf.st_uid)) != NULL ) {
	      if ( strcmp(pw->pw_name, fname) == 0) {
		requid = pw->pw_uid;
		reqgid = pw->pw_gid;
#ifdef LWSRV_LPR_LOG
		requname = pw->pw_name;
#endif LWSRV_LPR_LOG
		ok = 1;
	      }
	    }
	    else
	      if( (pw = getpwnam( fname )) != NULL ) {
		requid = pw->pw_uid;
		reqgid = pw->pw_gid;
#ifdef LWSRV_LPR_LOG
		requname = pw->pw_name;
#endif LWSRV_LPR_LOG
		ok = 1;		/* true */
	      } /* pwnam ok */
	    } /* read OK */
	    close(f);  /* close the file */
	  } /* open OK */
	if( !ok ) {	/* dump connection with error message */
	    char message[ 512 ];
	    fprintf( stderr, "No username (or invalid) confirmation.\n");
	    gethostname( fname, sizeof( fname )-1 ); /* ick */

	    /* THIS DOES NOT WORK! */
	    sprintf(message, "error: please login to host %s via appleshare",
		    fname );
	    NewStatus( message );
	    sleep( 3 );			/* bleh!! */
/*	    PAPShutdown( cno );		/*  */
	    PAPClose( cno, TRUE );	/* arg2 is ignored!! */
					/* what does it mean? */

	    continue;
	} /* not ok */
    } /* have aufsdb */
    /* ....budd ***/
#endif LWSRV_AUFS_SECURITY

    if (!singlefork) {
      if (logfile != NULL)
	close(2);		/* close log file */
      if (fork() != 0) {
	PAPShutdown(cno);	/* kill off connection */
	continue;
      }
      SLClose(srefnum);		/* close server for child */
      nbpShutdown();		/* shutdown nbp for child */
    } else NewStatus("busy, processing job");
    /* need for multi-forking, nice for single forking */
    /* handle the connection in cno */
    openlogfile();
    signal(SIGCHLD,SIG_IGN);
#ifdef AUTHENTICATE
    if (nprt != 1)
      initauthenticate(*argv, (char *)prtlist[prtno].prtname);
#endif AUTHENTICATE
    childjob(p_opn(cno, BUFMAX)); 
    if (!singlefork)
      exit(0);
  }
}

#ifdef RUN_AS_USER
/*
 * Conversion table, macintosh ascii with diacriticals to plain ascii.
 * In addition, an ':' also maps to an underscore for obvious reasons.
 * All other junk maps to an underscore.
 *
 */

static unsigned char convert [256] = {
/*       0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f */
/* 0 */ '_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_',
/* 1 */ '_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_',
/* 2 */ ' ','!','"','#','$','%','&','\'','(',')','*','+',',','-','.','/',
/* 3 */ '0','1','2','3','4','5','6','7','8','9','_',';','<','=','>','?',
/* 4 */ '@','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
/* 5 */ 'p','q','r','s','t','u','v','w','x','y','z','[','\\',']','^','_',
/* 6 */ '`','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o',
/* 7 */ 'p','q','r','s','t','u','v','w','x','y','z','{','|','}','~','_',
/* 8 */ 'a','a','c','e','n','o','u','a','a','a','a','a','a','c','e','e',
/* 9 */ 'e','e','i','i','i','i','n','o','o','o','o','o','u','u','u','u',
/* a */ '_','_','c','$','_','*','_','_','r','c','_','_','_','_','_','o',
/* b */ '_','_','_','_','_','m','d','s','p','p','_','a','o','_','_','o',
/* c */ '?','!','_','_','_','_','_','_','_','_','_','a','a','o','_','_',
/* d */ '_','_','_','_','_','_','_','_','y','_','_','_','_','_','_','_',
/* e */ '_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_',
/* f */ '_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_'
};

static void
unixize(name)
char *name;
{
  register unsigned char *p = (unsigned char *)name;

  while (*p) {
    *p = convert[*p];
    p += 1;
  }
}

static char *
getmacname(name, line, file)
char *name; /* mac name */
char *line; /* line buffer to use */
char *file; /* name of file containing table */
{
  FILE *f;
  char *index();
  char *m, *nl;

  if ((f = fopen(file, "r")) == NULL)
    return(NULL);

  while (fgets(line, 255, f) != NULL) {
    if (*line == '#' || *line == '\n')
      continue;		/* skip comment line */
    if ((m = index(line, ':')) == NULL )
      continue;		/* line in error */
    *m++ = '\0';
    if ((nl = index(m, '\n')) != NULL)
      *nl = '\0';	/* take trailing newline */
    unixize(m);
    if (strcmp(m, name) == 0) {
      fclose(f);
      return(line);
    }
  }
  fclose(f);
  return(NULL);
}

/*
 * We try to find a unix username to match the name from the mac.
 * The approach is simple. We use a simple file to convert mac names
 * to unix login names. The file needs only contain mac names that can't
 * be resolved into unix names by simple means. The other ones are found
 * automaticly. This means that 'Maarten' is resolved into 'maarten' without
 * intervention, whereas 'El Gringo' needs to be in the file to be resolved
 * to 'dolf'.
 *
 * Example file:
 * #comment line
 * dolf:El Gringo
 *
 */

static int
unixuid(macname)
char *macname;
{
  struct passwd  *pw;
  char line[256];
  char name[256];
  char *n;

  strcpy(name, macname);
  unixize(name);

  if ((n = getmacname(name, line, USER_FILE)) == NULL)
    n = name;

  if ((pw = getpwnam(n)) == NULL)
    return(0);
  else
    return(pw->pw_uid);
}
#endif RUN_AS_USER

export
childjob(pf)
PFILE *pf;
{
  long t;
  int argc, i;
  FILE *outfile;
  char tname[256],status[256];
  char pbuf[256],rhbuf[16],jbuf[1024];
  char *childargv[64];
#ifdef LWSRV_AUFS_SECURITY
  char bbuf[256];
#endif LWSRV_AUFS_SECURITY
#ifdef NeXT
  char dpistring[6];
#endif NeXT
#ifdef RUN_AS_USER
  int uid;
#endif RUN_AS_USER

  int waitret;
  WSTATUS waitstatus;

#ifdef AUTHENTICATE
  register PAPSOCKET *ps;
  register unsigned net;
#ifdef ISO_TRANSLATION
  void cMac2ISO(), cISO2Mac();
#endif ISO_TRANSLATION

  if((ps = cnotopapskt(pf->p_cno)) == NULL || !authenticate(net =
   ntohs(ps->addr.net), ps->addr.node)) {
    p_cls(pf);				/* close out the pap connection */
    (void)time(&t);
    fprintf(stderr,"lwsrv: Authentication failed: net %u.%u node %u; on %s",
     ((unsigned)net >> 8), (unsigned)(net & 0xff), (unsigned)ps->addr.node,
     ctime(&t));
    return;
  }
#endif AUTHENTICATE
  
  jobname[0] = username[0] = '\0';

  if (tracefile != NULL)		/* is this a trace? */
    strcpy(tname,tracefile);		/* yes... then output is tracefile */
  else {				/* otherwise use a temp file */
    strcpy(tname,TEMPFILE);
    mktemp(tname);
  }
  
  if ((outfile = fopen(tname, "w+")) == NULL) {
    perror(tname);
  }

  if (singlefork)
    NewStatus("initializing");

#ifdef ISO_TRANSLATE
  cMac2ISO(prtname);
  sprintf(status,"receiving job for %s", (char *)prtname);
  cISO2Mac(prtname);
#else  ISO_TRANSLATE
  sprintf(status,"receiving job for %s", (char *)prtname);
#endif ISO_TRANSLATE

  scandicts(dictdir);

#ifdef PAGECOUNT
  pagecount = -1;
  pcopies = 0;
#endif PAGECOUNT

  while (getjob(pf,outfile)) {	/* while still open... */
    if (singlefork)
      NewStatus(status);
    /* don't send out real eof - causes real problems */
    /* given that we are prepending procsets */
    fprintf(outfile,"%% *EOF*\n");
  }

  fclose(outfile);

  (void) time(&t);

#ifdef RUN_AS_USER
#ifdef LWSRV_AUFS_SECURITY
  if (((uid = requid) != 0)
   || (uid = unixuid(username)))
#else  LWSRV_AUFS_SECURITY
  if ((uid = unixuid(username)))
#endif LWSRV_AUFS_SECURITY
    chown(tname, uid, -1);
#ifdef USER_REQUIRED
  else {
    int n;
    FILE *infile;
    char buffer[BUFSIZ];

    fprintf(stderr, "lwsrv: Job refused for macuser %s\n", username);
    /* NewStatus ("Unknown user, job refused"); */
    unlink(tname);
    if ((outfile = fopen(tname, "w+")) != NULL) {
      fprintf(outfile, "\n\nMacintosh user name: %s\nJob: %s\n",
          username, jobname);
      fprintf(outfile, "\nJob refused. ");
      fprintf(outfile,
        "Can't map Macintosh user name to a Unix user name\n\n");
      if ((infile = fopen(REFUSE_MESSAGE, "r")) != NULL) {
        while ((n = fread(buffer, 1, BUFSIZ, infile)) > 0)
          fwrite(buffer, 1, n, outfile);
        fclose(infile);
      } else
        fprintf(outfile, "No detailed message available\n");
      fclose(outfile);
    }
  }
#endif USER_REQUIRED
#endif RUN_AS_USER

  if (tracefile != NULL)
    fprintf(stderr,"lwsrv: Tracing to file: %s; job %s; user %s; on %s\n",
	    tracefile,jobname,username,ctime(&t));
  else {
    if (rflag)
      fprintf(stderr,"lwsrv: Preserving file in %s\n",tname);

/*
 * this way lies madness ...
 */

#ifdef RUN_AS_USER
    if (uid)
#endif RUN_AS_USER
      fprintf(stderr,"lwsrv: Printing job: %s; user %s; on %s\n",
	    jobname,username,ctime(&t));
#ifdef RUN_AS_USER
    else
      fprintf(stderr,"lwsrv: Printing notification: %s; user %s; on %s\n",
	    jobname,username,ctime(&t));
#endif RUN_AS_USER

	argc = 0;
#ifdef USESYSVLP
	childargv[argc++]="lp";
#else  USESYSVLP
	childargv[argc++]="lpr";
#endif USESYSVLP
#ifdef MELBOURNE
	childargv[argc++]="-v";
#endif MELBOURNE
#ifdef VUW
	childargv[argc++]="-l";
#endif VUW
#ifdef xenix5
	childargv[argc++]="-og";
	sprintf(pbuf,"-d%s",unixpname); /* name of the printer */
	childargv[argc++]=pbuf;
#else xenix5
#ifdef USESYSVLP
	sprintf(pbuf,"-d%s",unixpname); /* name of the printer */
#else  USESYSVLP
	sprintf(pbuf,"-P%s",unixpname); /* name of the printer */
#endif USESYSVLP
	childargv[argc++]=pbuf;
	if (hflag) {			/* want a burst page */
#ifdef USESYSVLP
#ifdef DOCNAME
#ifdef __hpux
	  for (i = 0; i < MAXJOBNAME-1; i++)
	    if (isspace(jobname[i]))
	      jobtitle[i] = '_';
	    else
	      jobtitle[i] = jobname[i];
	  jobtitle[MAXJOBNAME-1] = '\0';
	  sprintf(jbuf,"-tMacJobName:%s",jobtitle);
#else  __hpux
	  sprintf(jbuf,"-tMacUser: %s Job: %s",username,jobname); /* job name */
#endif __hpux
#else  DOCNAME
	  sprintf(jbuf,"-tMacUser: %s",username); /* job name */
#endif DOCNAME
#else  USESYSVLP
	  childargv[argc++]="-J";
#ifdef DOCNAME
	  sprintf(jbuf,"MacUser: %s Job: %s",username,jobname); /* job name */
#else  DOCNAME
	  sprintf(jbuf,"MacUser: %s",username); /* job name */
#endif DOCNAME
#endif USESYSVLP
#ifdef PAGECOUNT
	  if (pagecount >= 0) {
	    if (pcopies <= 0)
	      pcopies = 1;
#ifdef __hpux
	    sprintf(&jbuf[strlen(jbuf)], "_Pages:_%04d", pcopies*pagecount);
#else  __hpux
	    sprintf(&jbuf[strlen(jbuf)], " Pages: %d", pcopies*pagecount);
#endif __hpux
	  }
#endif PAGECOUNT
	  childargv[argc++]=jbuf;
        }
#ifndef hpux
	else
#ifdef USESYSVLP
	  childargv[argc++]="-o-h";	/* suppress burst page */
#else  USESYSVLP
	  childargv[argc++]="-h";	/* suppress burst page */
#endif USESYSVLP
#endif hpux
#endif xenix5
#ifdef LWSRV_AUFS_SECURITY
	if (aufsdb && bin != NULL) {
#ifdef RUTGERS
	  sprintf(bbuf, "-B%s", bin);
#else  RUTGERS
	  sprintf(bbuf, "-C%s", bin);
#endif RUTGERS
	  childargv[argc++]=bbuf;
	}
#endif LWSRV_AUFS_SECURITY
#ifdef NeXT
        if (nextdpi) {
	  sprintf(dpistring, "-R%s", nextdpi);
	  childargv[argc++]=dpistring;
	}
#endif NeXT
#ifdef xenix5
	/* will this work ... ? */
	sprintf(rhbuf,"-%s%s",rflag ? "" : "r",hflag ? "" : "ob");
#else  xenix5
#ifdef __hpux
	sprintf(rhbuf,"-c");
#else  __hpux
	sprintf(rhbuf,"-%s",rflag ? "" : "r");
#endif __hpux
#endif xenix5
	if (rhbuf[1] != '\0') 
	  childargv[argc++]=rhbuf;	/* include h and/or r flags */
#ifndef USESYSVLP
	childargv[argc++]="-s";		/* better for > 1M files */
#endif USESYSVLP
#ifdef LPRARGS
	while(*lprargs)
	  childargv[argc++] = *lprargs++;
	lprargs=lprargsbuf;
#endif LPRARGS
        childargv[argc++]=tname;	/* our temporary file name */
        childargv[argc]=(char *) 0;	/* end of argument list */

	switch (fork()) {
	case 0:
#ifdef RUN_AS_USER
#ifndef LWSRV_AUFS_SECURITY
	    setuid(uid);
#endif  LWSRV_AUFS_SECURITY
#endif RUN_AS_USER
#ifdef LWSRV_AUFS_SECURITY
	    if (aufsdb) {
	/*
	 * dissassociate from any tty to make sure
	 * lpr uses our requid instead of getlogin()
	 *
	 */
#ifndef LWSRV_LPR_LOG
		for(i = 0 ; i < 10 ; i++)
	          (void) close(i);
	 	(void) open("/", 0);
		(void) dup2(0, 1);
		(void) dup2(0, 2);
#else LWSRV_LPR_LOG
		for(i = 3 ; i < 10 ; i++)
		  (void) close(i);
	/* 
	 * stderr is the logfile; stdin and stdout are already 
	 * using /dev/null, therefore disassociated from any tty;
	 * The Rutgers hack requires stdout to be the logfile if
	 * one exists.
	 *
	 */
		/* (void) open("/", 0);	*/
		/* (void) dup2(0, 1);	*/
		/* (void) dup2(0, 2);	*/
#endif LWSRV_LPR_LOG
		chown(tname, requid, reqgid);
		setuid(requid);
		setgid(reqgid);
	    }
#endif LWSRV_AUFS_SECURITY
#ifdef LWSRV_LPR_LOG
	/*
	 * log all lpr invocations for troubleshooting
	 * printing problems
	 *
	 */
	    fprintf(stderr, "Invoking lpr as user %s using execv: %s",
	        (requname) ? requname : "<unknown>", lprcmd);
	    for ( i = 1 ; i < argc ; i++) 
	      fprintf(stderr," %s",childargv[i]);
	    fprintf(stderr, "\n");
#endif LWSRV_LPR_LOG
	    if (execv(lprcmd,childargv)) {
		fprintf(stderr,"exec of %s failed\n", lprcmd);
		perror("exec");
		exit(-1);
	    }
	    break;
	case -1:
	    fprintf(stderr,"fork failed trying to run %s\n", lprcmd);
	    perror("fork");
	    break;
	default:

	/*
	 * This code is important, since lwsrv relies upon lpr to remove
	 * the temporary files, we must remove them if lpr fails for any
	 * reason (unless rflag TRUE).
	 *
	 */

	    /* wait for the lpr to do its thing */

	    if ((waitret = wait(&waitstatus)) == -1 ) {
#ifdef UTS
		waitstatus = 0; /* wait can return early */
#else  UTS
		perror("wait");
		exit(-1);
#endif UTS
	    }

#ifdef hpux
	    if (!rflag)
	        unlink(tname);
#else  hpux
	    if (WIFEXITED(waitstatus)) {
		if (W_RETCODE(waitstatus) != 0 ) {
		  fprintf(stderr,"lpr exited with status %d, %sremoving %s\n",
		    W_RETCODE(waitstatus), (rflag) ? "not " : "", tname);
		  if (!rflag)
		    unlink(tname);
		}
	    }
#endif hpux
	    break;
	}
  }
  p_cls(pf);				/* close out the pap connection */
}

export void
setjobname(ts)
char *ts;
{
  strncpy(jobname, ts, sizeof(jobname));
}

setusername(ts)
char *ts;
{
#ifdef RUN_AS_USER
  if (*username != '\0')
	return;
#endif RUN_AS_USER
  strcpy(username, ts);
}

export
NewStatus(status)
char *status;
{
  char tmp[1024];

  if (*username != '\0')
    sprintf(tmp,"job: %s for %s; status: %s",
	    jobname,username,status);
  else
    sprintf(tmp,"status: %s",status);
  cpyc2pstr(statbuffp->StatusStr, tmp);
  abSleep(0,TRUE);			/* make sure protocol runs */
}

#ifdef LWSRV_AUFS_SECURITY
/**************** budd... ****************/
/* duplicated in aufs.c and lwsrv.c sigh */
make_userlogin( buf, dir, addrb )
    char *buf, *dir;
    AddrBlock addrb;
{
    sprintf( buf, "%s/net%d.%dnode%d",
	    dir,
	    nkipnetnumber(addrb.net), nkipsubnetnumber(addrb.net),
	    addrb.node
	    );
}
#endif LWSRV_AUFS_SECURITY
