/*
 *  $Source: /sources/cvsrepos/majordomo/digest/wrapper.c,v $
 *  $Revision: 1.1.1.1 $
 *  $Date: 1994/01/18 23:28:25 $
 *  $Author: rouilj $
 *  $State: Exp $
 *
 *  $Locker:  $
 *  
 */

#ifndef lint
static char rcs_header[] = "$Header: /sources/cvsrepos/majordomo/digest/wrapper.c,v 1.1.1.1 1994/01/18 23:28:25 rouilj Exp $";
#endif

#include <stdio.h>

#ifndef STRCHR
#  define STRCHR(s,c) strchr(s,c)
#endif

#ifndef BIN
#  define BIN "/usr/local/mail/majordomo"
#endif

#ifndef PATH
#  define PATH "PATH=/bin:/usr/bin:/usr/ucb"
#endif

#ifndef HOME
#  define HOME "HOME=/usr/local/mail/majordomo"
#endif

#ifndef SHELL
#  define SHELL "SHELL=/bin/csh"
#endif

char * new_env[] = {
    HOME,		/* 0 */
    PATH,		/* 1 */
    SHELL,		/* 2 */
#ifdef MAJORDOMO_CF
    MAJORDOMO_CF,	/* 3 */
#endif
    0,		/* possibly for USER or LOGNAME */
    0,		/* possible for LOGNAME */
    0
};
    
main(argc, argv, env)
    int argc;
    char * argv[];
    char * env[];

{
    char * prog;
    int e, i;

    if (argc < 2) {
	fprintf(stderr, "USAGE: %s program [<arg> ...]\n", argv[0]);
	exit(1);
    }

    /* if the command contains a /, then don't allow it */
    if (STRCHR(argv[1], '/') != NULL) {
	/* this error message is intentionally cryptic */
	fprintf(stderr, "%s: error: insecure usage\n", argv[0]);
	exit(2);
    }

    if ((prog = (char *) malloc(strlen(BIN) + strlen(argv[1]) + 2)) == NULL) {
	fprintf(stderr, "%s: error: malloc failed\n", argv[0]);
	exit(3);
    }

    sprintf(prog, "%s/%s", BIN, argv[1]);

    /*  copy the "USER=" and "LOGNAME=" envariables into the new environment,
     *  if they exist.
     */

#ifdef MAJORDOMO_CF
    e = 4; /* the first unused slot in new_env[] */
#else
    e = 3; /* the first unused slot in new_env[] */
#endif

    for (i = 0 ; env[i] != NULL ; i++) {
	if ((strncmp(env[i], "USER=", 5) == 0) ||
		(strncmp(env[i], "LOGNAME=", 8) == 0)) {
	    new_env[e++] = env[i];
	}
    }

#ifdef POSIX_GID
    setgid(POSIX_GID);
#else
    setgid(getegid());
#endif

#ifdef POSIX_UID
    setuid(POSIX_UID);
#else
    setuid(geteuid());
#endif

    if ((getuid() != geteuid()) || (getgid() != getegid())) {
	fprintf(stderr, "%s: error: recompile with POSIX flags.\n", argv[0]);
	exit(4);
    }

    execve(prog, argv+1, new_env);

    /* the exec should never return */
    perror(argv[1]);
    exit(5);
}
