/*
   TESTG.I
   This file runs mesh plot movies. It should produce the same
   results as the grbench C program.

   $Id: testg.i,v 1.1 1993/08/27 18:50:06 munro Exp $
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

func testg
/* DOCUMENT testg
     runs a Yorick near-equivalent of Steve Langer's grbench graphics
     timing benchmark.
   SEE ALSO: lissajous, grtest
 */
{
  /* set parameters */
  NMID= 26;
  N= 2*NMID-1;
  xmax= ymax= 1.0;
  alpha= 0.5;
  dphi= 2.0*pi/8.3;
  npass= 50;
  ampy= cos(span(0.0, pi, N));

  /* set the maximum color index to use */
  /* maxcolr= 192;
     200 is the Yorick default -- grbench uses 192...
     Could use pldefault, maxcolors=192 to be sure.   */

  /* create room for the x-coordinates of the mesh */
  xmesh= array(double,N,N);
  /* the y-coordinates of the mesh are fixed */
  ymesh= span(0.0,ymax,N)(-:1:N,);

  /* be sure expose event is handled before starting into plots --
     otherwise nothing will show */
  window, 0, wait=1;

  if (is_void(dont_plot) || !dont_plot) {
    do_hollow, 0;
    do_filled, 0;
    do_hollow, 1;
    do_filled, 1;
  }
}

/* do a hollow mesh */
func do_hollow(animation)
{
  if (animation) animate, 1;
  else animate, 0;
  fma;

  write, format="%d frames of hollow %d-by-%d mesh %s\n",\
    npass, N, N, (animation? " animated" : " direct");
  now= yorick= gist= array(0.0, 3);
  timer, now;

  phi= -dphi;
  for(np=1 ; np<=npass ; np++) {
    phi= phi+dphi;
    xdif= alpha*sin(phi);
    xmj= 0.5*xmax*(1.0+xdif*ampy);

    for(j=1; j<=N; j++) {
      xmesh(1:NMID,j)= span(0.0, xmj(j), NMID);
      xmesh(NMID:N,j)= xmj(j)+span(0.0, xmax-xmj(j), NMID);
    }

    timer, now, yorick;
    if (!animation) plsys, 0;  /* animation only works in systems */
    plm, .48*ymesh+.41, .48*xmesh+.16;
    fma;
    timer, now, gist;
  }

  timer_print, "Yorick interpreter", yorick, "Gist graphics", gist,\
    "Yorick+Gist total", yorick+gist;

  if (animation) animate, 0;
  else plsys, 1;
}

/* do a filled mesh */
func do_filled(animation)
{
  if (animation) animate, 1;
  else animate, 0;
  fma;

  write, format="%d frames of filled %d-by-%d mesh %s\n",\
    npass, N, N, (animation? " animated" : " direct");
  now= yorick= gist= array(0.0, 3);
  timer, now;

  dxmin= xmax*(1.0-alpha)/(2.0*NMID);
  dxmax= xmax*(1.0+alpha)/(2.0*NMID);
  phi= -dphi;
  for(np=1 ; np<=npass ; np++) {
    phi= phi+dphi;
    xdif= alpha*sin(phi);
    xmj= 0.5*xmax*(1.0+xdif*ampy);

    for(j=1; j<=N; j++) {
      xmesh(1:NMID,j)= span(0.0, xmj(j), NMID);
      xmesh(NMID:N,j)= xmj(j)+span(0.0, xmax-xmj(j), NMID);
    }

    timer, now, yorick;
    if (!animation) plsys, 0;  /* animation only works in systems */
    if (is_void(use_pli) || !use_pli)
      plf, xmesh(dif,2:N),.48*ymesh+.41,.48*xmesh+.16, cmin=dxmin,cmax=dxmax;
    else
      pli, xmesh(dif,2:N), cmin=dxmin,cmax=dxmax;
    fma;
    timer, now, gist;
  }
  timer, now, gist;

  timer_print, "Yorick interpreter", yorick, "Gist graphics", gist,\
    "Yorick+Gist total", yorick+gist;

  if (animation) animate, 0;
  else plsys, 1;
}

#if 0
Results 23/Nov/92 running on miggle, diplaying to tonto

50 frames of hollow 51-by-51 mesh  direct
               Timing Category     CPU sec  System sec    Wall sec
            Yorick interpreter       2.630       0.050       2.750
                 Gist graphics       6.220       1.020      16.510
             Yorick+Gist total       8.850       1.070      19.260
 -----Total Elapsed Times-----       9.690       1.510      40.790
50 frames of filled 51-by-51 mesh  direct
               Timing Category     CPU sec  System sec    Wall sec
            Yorick interpreter       4.030       0.020       4.130
                 Gist graphics      14.540       2.640      38.500
             Yorick+Gist total      18.570       2.660      42.630
 -----Total Elapsed Times-----      37.250       4.950     102.530
50 frames of hollow 51-by-51 mesh  animated
               Timing Category     CPU sec  System sec    Wall sec
            Yorick interpreter       2.710       0.020       2.760
                 Gist graphics       6.260       0.750      16.250
             Yorick+Gist total       8.970       0.770      19.010
 -----Total Elapsed Times-----      18.660       2.290      59.860
50 frames of filled 51-by-51 mesh  animated
               Timing Category     CPU sec  System sec    Wall sec
            Yorick interpreter       4.200       0.040       4.400
                 Gist graphics      14.500       2.260      37.160
             Yorick+Gist total      18.700       2.300      41.560
 -----Total Elapsed Times-----      55.970       7.250     144.160

#endif

func lissajous(animation)
/* DOCUMENT lissajous
     runs the Yorick equivalent of an old graphics performance test
     used to compare PLAN, ALMA, and Basis with LTSS TMDS graphics.
   SEE ALSO: testg, grtest
 */
{
  /* Two figures with (x,y)= (cx,cy) + size*(cos(na*t), sin(nb*t+phase))
     -- the centers describe semi-circular arcs of radius rc.  */
  t= span(0, 2*pi, 400);
  na1= 1;    nb1= 5;
  na2= 2;    nb2= 7;
  rc1= 40.;  rc2= 160.;
  size= 40.;
  phase= theta= 0.;

  n= 50;   /* number of frames in animation */
  dtheta= pi/(n-1);
  dphase= 2*pi/(n-1);

  window, 0, wait=1;
  if (animation) animate, 1;
  else animate, 0;
  fma;

  split= now= array(0.0, 3);
  timer, now;

  for (i=0 ; i<n ; i++) {
    cost= cos(theta);
    sint= sin(theta);
    x= rc1*cost+size*cos(na1*t);  y= rc1*sint+size*sin(nb1*t+phase);
    plg, y, x;
    x= rc2*cost+size*cos(na2*t);  y= rc2*sint+size*sin(nb2*t+phase);
    plg, y, x;
    fma;
    theta+= dtheta;
    phase+= dphase;
  }

  timer, now, split;
  timer_print, "Lissajous test", split;

  if (animation) {
    /* turn off animation and pop up final frame again */
    animate, 0;
    x= -rc1+size*cos(na1*t);  y= size*sin(nb1*t);
    plg, y, x;
    x= -rc2+size*cos(na2*t);  y= size*sin(nb2*t);
    plg, y, x;
  }
}

func grtest
/* DOCUMENT grtest
     Perform a comprehensive test of Yorick's graphics package.
 */
{
}
