C  $Id: cfft2.f,v 1.1 1993/08/06 23:10:08 munro Exp $
C
C     EXTENSION TO SWARZTRAUBER FFT ROUTINES TO ALLOW FOR
C     MULTIDIMENSIONAL FFTS
C
C     CALL CFFT2(IDIR, C, ISTD, N, N2, WS)
C
C     IDIR    1 FOR FORWARD TRANSFORM (CFFTF),
C            -1 FOR BACKWARD TRANSFORM (CFFTB)
C     C      THE COMPLEX ARRAY TO BE TRANSFORMED (IN PLACE)
C     ISTD   THE STRIDE OF THE DIMENSION OF C TO BE TRANSFORMED
C            ISTD=1 MEANS THE FIRST DIMENSION OF C IS TO BE TRANSFORMED,
C            ISTD=LEN1 WHERE LEN1 IS THE LENGTH OF THE FIRST DIMENSION
C                      MEANS TO TRANSFORM THE SECOND DIMENSION
C            ISTD=LEN1*LEN2 TRANSFORMS THE THIRD DIMENSION, AND SO ON
C     N      THE LENGTH OF THE DIMENSION TO BE TRANSFORMED
C     N2     THE PRODUCT OF ALL DIMENSION LENGTHS AFTER THE DIMENSION
C            TO BE TRANSFORMED -- THE TRANSFORM OF LENGTH N WILL BE
C            REPEATED A TOTAL OF ISTD*N2 TIMES
C     WS     THE WORKING ARRAY FILLED BY CFFTI
C            IF ISTD=1, ONLY 4*N+15 ELEMENTS OF STORAGE WILL BE USED,
C            AS FOR CFFTF OR CFFTB
C            IF ISTD>1, WS NEEDS TO HAVE 6*N+15 ELEMENTS OF STORAGE
C            (AS A WORKING ARRAY FOR THE DIMENSION BEING TRANSFORMED)
C
      SUBROUTINE CFFT2(IDIR, C, ISTD, N, N2, WS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       C(2,ISTD,N,N2)       ,WS(1)
      IF (N .EQ. 1) RETURN
      IW1 = N+N+1
      IW2 = IW1+N+N
      IW3 = IW2+15
      DO 900 I2=1,N2
         IF (ISTD .LT. 2) GOTO 600
C        IF (ISTD .GE. 2) THEN
           DO 500 I0=1,ISTD
              DO 100 J=1,N
                 WS(IW3+2*J-2)= C(1,I0,J,I2)
                 WS(IW3+2*J-1)= C(2,I0,J,I2)
 100          CONTINUE
              IF (IDIR .LT. 0) GOTO 200
C             IF (IDIR .GT. 0) THEN
                 CALL CFFTF1 (N,WS(IW3),WS,WS(IW1),WS(IW2))
              GOTO 300
C             ELSE (IDIR .LT. 0)
 200          CONTINUE
                 CALL CFFTB1 (N,WS(IW3),WS,WS(IW1),WS(IW2))
C             ENDIF (IDIR)
 300          CONTINUE
               DO 400 J=1,N
                 C(1,I0,J,I2)= WS(IW3+2*J-2)
                 C(2,I0,J,I2)= WS(IW3+2*J-1)
 400          CONTINUE
 500       CONTINUE
        GOTO 800
C       ELSE (ISTD .LT. 2)
 600    CONTINUE
           IF (IDIR .LT. 0) GOTO 650
C          IF (IDIR .GT. 0) THEN
              CALL CFFTF1 (N,C(1,1,1,I2),WS,WS(IW1),WS(IW2))
           GOTO 700
C          ELSE (IDIR .GT. 0)
 650       CONTINUE
              CALL CFFTB1 (N,C(1,1,1,I2),WS,WS(IW1),WS(IW2))
C          ENDIF (IDIR)
 700       CONTINUE
C       ENDIF (ISTD)
 800    CONTINUE
 900  CONTINUE
      RETURN
      END
