.TH A60 1 "June 1991"
.SH NAME
a60 \- An Algol 60 Interpreter
.SH SYNOPSIS
.B a60
[
.B "options"
]
[
.B "<input-file>"
]
.SH DESCRIPTION
A60 is an Algol 60 interpreter, based on the standard of the ``Revised
Report on the Algorithmic Language Algol 60''.
.SH OPTIONS
.TP
.B -h
Give a usage help.
.TP
.B -V
Print the version string and exit.
.TP
.B -v
Be verbose.
.TP
.B -n
Do not execute the input. Parse and check only.
.TP
.B -i
Do not check, nor execute the input. Parse only.
.TP
.B -t
Trace the line numbers running the input.
.TP
.B -strict
Follow strict a60 convention. Skip whites in entire input, except in
strings. So keywords must be enclosed in quotes.
.TP
.B -c
Create C output from the given input. This is experimentally.
.TP
.B -C
Create a executable from the given input. This is -c with an C
compiler run (gcc is used).
.TP
.B -o "<output-file>"
Use <output-file> for output. Used with -c or -C option.
.TP
.B <input-file>
Specification of the inputfile to be interpreted. It woud be nice, if
it is of the form: foobar.a60
.SH FILES
 ../a60-mkc.inc - a C include file, used for C-code generation.
.SH DIAGNOSTICS
For explanation of the parse- and runtime error messages, look into the
a60.info documentation (not written yet - sorry).
.SH BUGS
There are surely many bugs. Be proud about them: This software written
by a human.
.br
The interpreter is still growing.
.br
The standard is not exactly implemented; many things are still untested.
.SH AUTHORS
Erik Schoenfelder (schoenfr@ibr.cs.tu-bs.de)
.br
June 1991
