/*
 * java.net.InetAddress.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <assert.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>
#include <native.h>
#include "../../kaffevm/itypes.h"
#include "java.net/InetAddress.h"
#include "nets.h"

#define	HOSTNMSZ	80

/*
 * Get localhost name.
 *  Is this my name or "localhost" ?
 */
struct Hjava_lang_String*
java_net_InetAddress_getLocalHostName()
{
	char hostname[HOSTNMSZ];

	if (gethostname(hostname, HOSTNMSZ-1) < 0) {
		strcpy("localhost", hostname);
	}
	return (makeJavaString(hostname, strlen(hostname)));
}

/*
 * Provide one of my local address (I guess).
 */
void
java_net_InetAddress_makeAnyLocalAddress(struct Hjava_net_InetAddress* this)
{
	unhand(this)->hostName = 0;
	unhand(this)->address = htonl(INADDR_ANY);
	unhand(this)->family = AF_INET;
}

/*
 * Convert a hostname to the primary host address.
 */
HArrayOfByte*
java_net_InetAddress_lookupHostAddr(struct Hjava_lang_String* str)
{
	char name[MAXHOSTNAME];
	struct hostent* ent;
	object* obj;

	javaString2CString(str, name, sizeof(name));

	ent = gethostbyname(name);
	if (ent == 0) {
		SignalError(0, "java.net.UnknownHostException", SYS_HERROR);
	}

	/* Copy in the network address */
	obj = (object*)alloc_array(4, TYPE_Byte);
	assert(obj != 0);
	*(long*)obj->data = *(long*)ent->h_addr_list[0];

	return (obj);
}

/*
 * Convert a hostname to an array of host addresses.
 */
HArrayOfArray* /* HArrayOfArrayOfBytes */
java_net_InetAddress_lookupAllHostAddr(struct Hjava_lang_String* str)
{
	char name[MAXHOSTNAME];
	struct hostent* ent;
	object* obj;
	object* array;
	int i;

	javaString2CString(str, name, sizeof(name));

	ent = gethostbyname(name);
	if (ent == 0) {
		SignalError(0, "java.net.UnknownHostException", SYS_HERROR);
	}

	array = (object*)alloc_objectarray(ent->h_length, "[[B");
	assert(array != 0);

	for (i = 0; i < ent->h_length; i++) {
		/* Copy in the network address */
		obj = (object*)alloc_array(4, TYPE_Byte);
		assert(obj != 0);
		*(long*)obj->data = *(long*)ent->h_addr_list[i];
		((object**)array->data)[i] = obj;
	}

	return (obj);
}

/*
 * Convert a network order address into the hostname.
 */
struct Hjava_lang_String*
java_net_InetAddress_getHostByAddr(long addr)
{
	struct hostent* ent;

	abort(); /* DONT KNOW THE ARGUMENTS */
	ent = gethostbyaddr(0, 0, 0);
	if (ent == 0) {
		SignalError(0, "java.net.UnknownHostException", SYS_HERROR);
	}

	return (makeJavaString((char*)ent->h_name, strlen(ent->h_name)));
}

/*
 * Return the inet address family.
 */
long
java_net_InetAddress_getInetFamily()
{
	return (AF_INET);
}
