/*
 * java.lang.Float.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdlib.h>
#include <native.h>
#include "defs.h"
#include "java.lang/Number.h"
#include "java.lang/Float.h"

/*
 * Convert float into a string.
 */
struct Hjava_lang_String*
java_lang_Float_toString(float val)
{
	char str[MAXNUMLEN];

	sprintf(str, "%g", val);
	return (makeJavaString(str, strlen(str)));
}

/*
 * Convert string to float object.
 */
struct Hjava_lang_Float*
java_lang_Float_valueOf(struct Hjava_lang_String* str)
{
	struct Hjava_lang_Float* obj;
	char buf[MAXNUMLEN];

	javaString2CString(str, buf, sizeof(buf));

	obj = (struct Hjava_lang_Float*)execute_java_constructor(0, "java.lang.Float", 0, "()V");
	unhand(obj)->value = atof(buf);

	return (obj);
}

/*
 * Convert float to bits.
 */
long
java_lang_Float_floatToIntBits(float val)
{
	return (*(long*)&val);
}

/*
 * Convert bits to float.
 */
float
java_lang_Float_intBitsToFloat(long val)
{
	return (*(float*)&val);
}
