/*
 * java.io.RandomAccessFile.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include "files.h"
#include "java.io/RandomAccessFile.h"
#include "java.io/FileDescriptor.h"

/*
 * Open a file for random access.
 */
void
java_io_RandomAccessFile_open(struct Hjava_io_RandomAccessFile* this, struct Hjava_lang_String* name, long /* bool */ rw)
{
	int fd;
	char str[MAXPATHLEN];

	javaString2CString(name, str, sizeof(str));

	fd = open(str, (rw == 0 ? O_RDONLY : O_RDWR));
	unhand(unhand(this)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Return length of file.
 */
long long
java_io_RandomAccessFile_length(struct Hjava_io_RandomAccessFile* this)
{
	struct stat buf;
	int r;

	r = fstat(unhand(unhand(this)->fd)->fd, &buf);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	return (buf.st_size);
}

/*
 * Seek into file.
 */
void
java_io_RandomAccessFile_seek(struct Hjava_io_RandomAccessFile* this, long long pos)
{
	int r;

	r = lseek(unhand(unhand(this)->fd)->fd, pos, SEEK_SET);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Read in bytes from file.
 */
long
java_io_RandomAccessFile_readBytes(struct Hjava_io_RandomAccessFile* this, HArray* bytes, long off, long len)
{
	long ret;

	ret = read(unhand(unhand(this)->fd)->fd, &bytes->data[off], len);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (ret);
}

/*
 * Read a byte from file.
 */
long
java_io_RandomAccessFile_read(struct Hjava_io_RandomAccessFile* this)
{
	long ret;
	unsigned char byte;

	ret = read(unhand(unhand(this)->fd)->fd, &byte, 1);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}

	return (byte);
}

/*
 * Write a byte to file.
 */
void
java_io_RandomAccessFile_write(struct Hjava_io_RandomAccessFile* this, long data)
{
	long ret;
	unsigned char byte;

	byte = data;

	ret = write(unhand(unhand(this)->fd)->fd, &byte, 1);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Write a number of bytes to file.
 */
void
java_io_RandomAccessFile_writeBytes(struct Hjava_io_RandomAccessFile* this, HArray* bytes, long off, long len)
{
	long ret;

	ret = write(unhand(unhand(this)->fd)->fd, &bytes->data[off], len);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Get current file position.
 */
long long
java_io_RandomAccessFile_getFilePointer(struct Hjava_io_RandomAccessFile* this)
{
	long long r;

	r = lseek(unhand(unhand(this)->fd)->fd, 0, SEEK_CUR);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (r);
}

/*
 * Close file.
 */
void
java_io_RandomAccessFile_close(struct Hjava_io_RandomAccessFile* this)
{
	int r;

	r = close(unhand(unhand(this)->fd)->fd);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}
