/*
 * file.h
 * File support routines.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __file_h
#define __file_h

#include <stdio.h>
#include "gtypes.h"

inline
void
readu1(u1* c, FILE* f)
{
	*c = getc(f);
}

inline
void
readu2(u2* c, FILE* f)
{
	*c = (getc(f) << 8) | getc(f);
}

inline
void
readu4(u4* c, FILE* f)
{
	*c = (getc(f) << 24)|(getc(f) << 16)|(getc(f) << 8)|getc(f);
}

#endif
