/*
 * main.c
 * Kick off program.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include "classMethod.h"
#include "baseClasses.h"
#include "thread.h"

static void machine_initialise(void);

stringClass*		makeJavaString(char*, int);

#define	MAIN		"main"
#define	MAINSIG		"([Ljava/lang/String;)V"
#define	STRINGSIG	"Ljava/lang/String;"

/*
 * MAIN
 */
main(int argc, char* argv[])
{
	classes* class;
	void* func;
	object* args;
	stringClass** str;
	int i;

	/* Get the class name to start with */
	if (argc < 2) {
		fprintf(stderr, "No class specified.\n");
		exit(1);
	}

	/* Machine specific initialisation */
	machine_initialise();

	/* Initialise */
	initialise();

	/* Convert any '.' in name to '/' */
	classname2pathname(argv[1], argv[1]);

	/* Build an array of strings as the arguments */
	args = alloc_objectarray(argc-2, STRINGSIG);

	/* Build each string and put into the array */
	str = (stringClass**)args->data;
	for (i = 2; i < argc; i++) {
		str[i-2] = makeJavaString(argv[i], strlen(argv[i]));
	}

	/* Kick it */
	do_execute_java_class_method(argv[1], MAIN, MAINSIG, args);
	killThread(currentThread);
	/* This should never return */
	exit(1);
}

/*
 * Machine specific initialisation.
 */

#if defined(__bsdi__)

#include <math.h>
void const *bsdi_ref;

#endif

static
void
machine_initialise(void)
{
#if defined(__bsdi__)
        dlopen (NULL, 0);
        bsdi_ref = tan;
#endif  
}
