# include	<stdio.h>
# include	<ingres.h>
# include	<aux.h>
# include	<access.h>
# include	<lock.h>
# include	<pv.h>
# include       <ctlmod.h>
# include	<sccs.h>

SCCSID(@(#)helpr.c	8.2	2/8/85)

struct _cm_t	Cm;		/* the system topography map */
struct _ctx_t	Ctx;		/* the current context */
int		Syncs[CM_MAXPROC];/* expected SYNC's from each proc */

/* General System Information */
jmp_buf		CmReset;	/* restart addr on interrupt */

# ifdef xMONITOR
struct monitor	CmMonBuf;	/* monitor buffer for CM overhead */
# endif xMONITOR



extern int	Status;
short		tTdbu[100];
DESC		Btreesec;
int		Btree_fd;
char		*Fileset;

main(argc, argv)
int	argc;
char 	*argv[];
{
	extern struct out_arg	Out_arg;
	register char		**av;
	register int		i;
	register char		*p;
	extern char		*Parmvect[];
	extern char		*Flagvect[];
	extern char		*Dbpath;
	int			nc;
	PARM			newpv[PV_MAXPC];
	PARM			*nv;
	char			*qm;
	char			*qmtest();

	argv[argc] = NULL;

#	ifdef xSTR1
	tTrace(argv, 'T', tTdbu, 100);
#	endif

	i = initucode(argc, argv, TRUE, NULL, M_SHARE);
#	ifdef xSTR2
	if (tTf(0, 1))
		printf("initucode=%d, Dbpath='%s'\n", i, Dbpath);
#	endif
	switch (i)
	{
	  case 0:
	  case INDIRECT:
		break;

	  case NODB:
	  case INDNODB:
		printf("Database %s does not exist\n", Parmvect[0]);
		exit(-1);

	  case NOACCESS:
		printf("You are not authorized to access this database\n");
		exit(-1);

	  case INVALIDUSR:
		printf("You are not a valid INGRES user\n");
		exit(-1);

	  case NODBNAME:
		printf("No database name specified\n");
	usage:
		printf("usage: helpr database [relname ...]\n");
		exit(-1);

	  default:
		syserr("initucode %d", i);
	}

/*
	if (Flagvect[0] != NULL)
	{
		printf("No flags are allowed for this command\n");
		goto usage;
	}
*/

	if (chdir(Dbpath) < 0)
		syserr("cannot access data base %s", p);
#	ifdef xTTR2
	if (tTf(1, 0))
		printf("entered database %s\n", Dbpath);
#	endif

	/* initialize access methods (and Admin struct) for user_ovrd test */
	acc_init();
#	ifdef xTTR3
	if (tTf(2, 0))
		printf("access methods initialized\n");
#	endif

	set_so_buf();

	av = &Parmvect[1];	/* get first param after database name */
	p = *av;
	if (p == NULL)
	{
		/* special case of no relations specified */
		newpv[0].pv_type = PV_INT;
		newpv[0].pv_val.pv_int = RELIST;
		newpv[1].pv_type = PV_EOF;
#		ifdef xTTR3
		if (tTf(3, 0))
			printf("calling help, no relations specified\n");
#		endif
		help(1, newpv);

	}
	else
	{
		do
		{
			nc = 0;
			nv = newpv;

			if ((qm = qmtest(p)) != NULL)
			{
				/* either help view, integrity or protect */
				av++;
				while ((p = *av++) != NULL)
				{
					if ((i = (int) qmtest(p)) != NULL)
					{
						/* change of qmtest result */
						qm = (char *) i;
						continue;
					}
					(nv)->pv_type = PV_STR;
					(nv++)->pv_val.pv_str = qm;
					(nv)->pv_type = PV_STR;
					(nv++)->pv_val.pv_str = p;
					nc += 2;
				}
#				ifdef xTTR3
				if (tTf(3, 0))
					printf("calling display\n");
#				endif
				nv->pv_type = PV_EOF;
				/*
				display(nc, newpv);
				*/
			}
			else
			{
				/* help relname */
				while ((p = *av++) != NULL && qmtest(p) == NULL)
				{
					if (sequal("all", p))
					{
						(nv)->pv_type = PV_INT;
						(nv++)->pv_val.pv_int = ALLRELINFO;
						nc++;
					}
					else
					{
						(nv)->pv_type = PV_INT;
						(nv++)->pv_val.pv_int = RELINFO;
						(nv)->pv_type = PV_STR;
						(nv++)->pv_val.pv_str = p;
						nc += 2;
					}
				}
				nv->pv_type = PV_EOF;
#				ifdef xTTR3
				if (tTf(3, 0))
					printf("calling help\n");
#				endif
				help(nc, newpv);
				/* this backs av up one step, so 
				 * that it points at the keywords (permit,
				 * integrity, view) or the NULL
				 */
				--av;
			}
		} while (p != NULL);
	}
	fflush(stdout);
	exit(0);
}



char *qmtest(p)
register char	*p;
{
	if (sequal("view", p))
		return ("4");
	else if (sequal("permit", p))
		return ("5");
	else if (sequal("integrity", p))
		return ("6");
	else
		return (NULL);
}

void
rubproc()
{
	exit(1);
}

