/*
 * as_menuh.c:  procedures for creating menus recursively
 */

/*
 * Copyright 1991 - 1993,  Andrzej Stochniol, London, UK
 *
 * ASEDIT text editor, both binary and source (hereafter, Software) is
 * copyrighted by Andrzej Stochniol (hereafter, AS) and ownership remains
 * with AS.
 *
 * AS grants you (hereafter, Licensee) a license to use the Software
 * for academic, research and internal business purposes only, without a
 * fee.  Licensee may distribute the binary and source code (if released)
 * to third parties provided that the copyright notice and this statement
 * appears on all copies and that no charge is associated with such copies.
 *
 * Licensee may make derivative works.  However, if Licensee distributes
 * any derivative work based on or derived from the Software, then
 * Licensee will:
 * (1) notify AS regarding its distribution of the derivative work, and
 * (2) clearly notify users that such derivative work is a modified version
 *      and not the original ASEDIT distributed by AS.
 *
 * Any Licensee wishing to make commercial use of the Software should
 * contact AS to negotiate an appropriate license for such commercial use.
 * Commercial use includes:
 * (1) integration of all or part of the source code into a product for sale
 *     or license by or on behalf of Licensee to third parties, or 
 * (2) distribution of the binary code or source code to third parties that
 *     need it to utilize a commercial product sold or licensed by or on 
 *     behalf of Licensee.
 *
 * A. STOCHNIOL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS
 * SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR
 * IMPLIED WARRANTY.  IN NO EVENT SHALL A. STOCHNIOL BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *
 * 	Andrzej Stochniol	(A.Stochniol@ic.ac.uk)
 * 	30 Hatch Road
 * 	London SW16 4PN
 * 	UK
 */

/*
 * History:
	19.02.1993 - rewrite of the 1992 version (tidying up +
		explicit setting of labelStrings removed; now it is
		possible to use as_create_menuh with menu labels specified
		as resource strings)
		Menu structure is defined in as_menuh_struct. Actual labels,
		accelerators etc. might be specified either in the as_menuh_struct
		or as resources.
	25.05.1993 - implementing of mk_asdat function and a related
		     asClientDataStruct
	09.06.1993 - setting of the toogles on the basis of menu entry ('>', ']' - on)
 *
 */

#include <stdio.h>		/* for fprintf and stderr definition ... */
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>

#include "asedit.h"

#ifdef _NO_PROTO
caddr_t mk_asdat(/*   int client_data   */);
#else  /* _NO_PROTO */
caddr_t mk_asdat(int client_data);
#endif


#ifdef _NO_PROTO
void as_create_menuh(title, menu, menulist, nitems, charset)
char *title;
Widget menu;
as_menuh_struct *menulist;
int nitems;
XmStringCharSet charset;
#else  /* _NO_PROTO */
void as_create_menuh(char *title, Widget menu, as_menuh_struct *menulist, int nitems,
		XmStringCharSet charset)
#endif
{
  Arg        wargs[10];
  int        i, n=0;
  WidgetList buttons;
  int        separators = 0;
  char	     pull_down_name[40];	/* to construct ..._PullDown strings */


  /* Allocate a widget list to hold all button widgets. */
  buttons = (WidgetList) XtMalloc(nitems * sizeof(Widget));

  /* If a title is given, create Label and Separator widgets. */
  if(title)
  {
    n = 0;
    XtCreateManagedWidget(title, xmLabelWidgetClass, menu, wargs, n);

    n = 0;
    XtCreateManagedWidget("separator", xmSeparatorWidgetClass, menu, wargs, n);
  }

  /* Create an entry for each item in the menu. */
  for(i=0; i<nitems; i++)
  {
   if(menulist[i].name == NULL)	  /* A NULL name represents a separator.*/
   {
     n = 0;
     XtCreateManagedWidget("separator", xmSeparatorWidgetClass, menu, wargs, n);
     separators++; 		/* Count how many entries aren't buttons */
   }

   /* If there is a name and a callback, create a "normal"
    * menu entry and register the callback function.
    */
   else if(menulist[i].func)
   {
     n=0;
     if(menulist[i].mnemonic) { XtSetArg(wargs[n],XmNmnemonic,menulist[i].mnemonic); n++; }

     if(menulist[i].acceleratorText)
     {
	 XtSetArg(wargs[n], XmNacceleratorText,
		 XmStringCreateLtoR(menulist[i].acceleratorText, charset)); n++;
#ifdef _AS_DEBUG
	 /* check during debugging if for the accelerator text in the menu the
		appropriate accelerator was defined (be warry that sometimes
		accelerators need not to be defined, e.g. for "Del" for Text widget;
		at such	case ignore the warning during debugging) */
	 if(menulist[i].accelerator == NULL)
	 {
		fprintf(stderr,"_AS_DEBUG WARNING in as_create_menuh: for '%s' accelerator text  \n",
			menulist[i].acceleratorText,
			"   the appropriate accelerator was not defined (now is equal to NULL) ! \n");
	 }
#endif
     }

     if(menulist[i].accelerator) { XtSetArg(wargs[n], XmNaccelerator,
					menulist[i].accelerator); n++; }

     if (menulist[i].name[0] == '<' || menulist[i].name[0] == '>' ||
	 menulist[i].name[0] == '[' || menulist[i].name[0] == ']')    /* otpion/toggle button */
     {
	/* A toggle button (one of many) is diamond-shaped. */
	if (menulist[i].name[0] == '<' || menulist[i].name[0] == '>')
	{
	    XtSetArg(wargs[n], XmNindicatorType, XmONE_OF_MANY); n++;
	}
	/* set the on state (for '>' and ']') */
	if (menulist[i].name[0] == '>' || menulist[i].name[0] == ']')
	{
	    XtSetArg (wargs[n], XmNset, True);  n++;
	}


	/* Make sure the button shows up even when toggled off. */
	/***lets leave that to be specified through resources
		 if (menulist[i].name[0] == '#')  { XtSetArg(wargs[n], XmNvisibleWhenOff,
						True); n++; }
	****/
	/* ignore the first character of the label */
	buttons[i-separators] = XmCreateToggleButton (menu,(String)&(menulist[i].name[1]),
				      wargs, n);
	XtAddCallback(buttons[i-separators], XmNvalueChangedCallback ,
			   menulist[i].func, mk_asdat(menulist[i].data) );

     }
     else /* regular button */
     {
	buttons[i-separators] = XmCreatePushButton (menu, menulist[i].name,
				      wargs, n);
	XtAddCallback(buttons[i-separators], XmNactivateCallback,
		   menulist[i].func, mk_asdat(menulist[i].data) );
     }

     if( menulist[i].helpCB )
	XtAddCallback(buttons[i-separators], XmNhelpCallback,
		   menulist[i].helpCB, mk_asdat(menulist[i].data) );

   }
   /*
    * If there is a name, but no callback function, the entry
    * must be a label, unless there is a submenu.
    */
   else if(!menulist[i].sub_menu)
   {
     n = 0;
     buttons[i-separators] = XtCreateWidget(menulist[i].name,
					   xmLabelWidgetClass,
					   menu, wargs, n);
   }
   /*
    * If we got here, the entry must be a submenu.
    * Create a pulldown menu pane and an XmCascadeButton
    * widget. Attach the menu pane and make a recursive call
    * to create the entries in the submenu.
    */
   else
   {
    Widget sub_menu;

    /*  old (the name of the pull down menu was never set if sub_menu_title
	was not	specified, which is the usual situation)
	    sub_menu =XmCreatePulldownMenu(menu,
				   menulist[i].sub_menu_title,
				   NULL, 0);
    ***OLD  (before 14.10.1992)  */

    /* first construct a name for the pull down widget (practically menu shell widget) */

    strcpy(pull_down_name, menulist[i].name);
    strcat(pull_down_name,"_PullDown");

    sub_menu =XmCreatePulldownMenu(menu,
				   pull_down_name,
				   NULL, 0);

    n=0;
    XtSetArg(wargs[n], XmNsubMenuId, sub_menu); n++;
    if(menulist[i].mnemonic) { XtSetArg(wargs[n],XmNmnemonic,menulist[i].mnemonic); n++; }

    if(menulist[i].acceleratorText)
    {
	 XtSetArg(wargs[n], XmNacceleratorText,
		 XmStringCreateLtoR(menulist[i].acceleratorText, charset)); n++;
#ifdef _AS_DEBUG
	 /* check during debugging if for the accelerator text in the menu the
		appropriate accelerator was defined (be warry that sometimes
		accelerators need not to be defined, e.g. for "Del" for Text widget;
		at such	case ignore the warning during debugging) */
	 if(menulist[i].accelerator == NULL)
	 {
		fprintf(stderr,"_AS_DEBUG WARNING in as_create_menuh: for '%s' accelerator text  \n",
			menulist[i].acceleratorText,
			"   the appropriate accelerator was not defined (now is equal to NULL) ! \n");
	 }
#endif
    }

    if(menulist[i].accelerator) { XtSetArg(wargs[n], XmNaccelerator,
					menulist[i].accelerator); n++; }

    buttons[i-separators] = XmCreateCascadeButton (menu,
				 menulist[i].name, wargs, n);

    /* install a help callback if specified */
     if( menulist[i].helpCB )
	XtAddCallback(buttons[i-separators], XmNhelpCallback,
		   menulist[i].helpCB, mk_asdat(menulist[i].data) );



    as_create_menuh(menulist[i].sub_menu_title,
			  sub_menu, menulist[i].sub_menu,
			  menulist[i].n_sub_items, charset);
   }
   /* put the address of a created button widget into menulist[i]  */
   if(menulist[i].name != NULL)
   { 	/* O.K., otherwise a separator element has been created .... */
	menulist[i].w = buttons[i-separators];
   }

  }


  /*
   * Manage all button widgets. Menu panes are not managed.
   */
  XtManageChildren(buttons, nitems - separators);

} /* as_create_menuh */
