/*
 * Look up user and/or group names.
 */

#include <strings.h>
#include <sys/types.h>
#include <apollo/base.h>
#include "tar.h"

#ifndef NONAMES
/* Whole module goes away if NONAMES defined.  Otherwise... */

extern std_$call rgyc_$pgo_num_to_name();
extern std_$call rgyc_$pgo_name_to_num();

typedef enum {
	rgyc_$pgo_person,
	rgyc_$pgo_group,
	rgyc_$pgo_organization,
} rgyc_$pgo_t;

static int	saveuid = -993;
static char	saveuname[TUNMLEN];
static int	my_uid = -993;

static int	savegid = -993;
static char	savegname[TGNMLEN];
static int	my_gid = -993;

#define myuid	( my_uid < 0? (my_uid = getuid()): my_uid )
#define	mygid	( my_gid < 0? (my_gid = getgid()): my_gid )

/*
 * Look up a user or group name from a uid/gid, maintaining a cache.
 * FIXME, for now it's a one-entry cache.
 * FIXME2, the "-993" is to reduce the chance of a hit on the first lookup.
 *
 * This is ifdef'd because on Suns, it drags in about 38K of "yellow
 * pages" code, roughly doubling the program size.  Thanks guys.
 */
void
finduname(uname, uid)
char *uname;
int uid;
{
	int junk, namelen;
	char name[256];
	status_$t st;

	if (uid != saveuid) {
		saveuid = uid;
		rgyc_$pgo_num_to_name(rgyc_$pgo_person, uid, junk, name, namelen, st);
		if (st.all == status_$ok) {
			if (namelen >= TUNMLEN)
				namelen = TUNMLEN - 1;
			bcopy(name, saveuname, namelen);
		} else
			namelen = 0;
		saveuname[namelen] = '\0';
	}
	strncpy(uname, saveuname, TUNMLEN);
}

int
finduid(uname)
char *uname;
{
	int uid, junk;
	status_$t st;

	if (uname[0] != saveuname[0]	/* Quick test w/o proc call */
	    || 0!=strncmp(uname, saveuname, TUNMLEN)) {
		strncpy(saveuname, uname, TUNMLEN);
		rgyc_$pgo_name_to_num(rgyc_$pgo_person, *uname, strlen(uname), junk, uid, st);
		saveuid = (st.all == status_$ok) ? uid : myuid;
	}
	return saveuid;
}


void
findgname(gname, gid)
char *gname;
int gid;
{
	int junk, namelen;
	char name[256];
	status_$t st;

	if (gid != savegid) {
		savegid = gid;
		rgyc_$pgo_num_to_name(rgyc_$pgo_group, gid, junk, name, namelen, st);
		if (st.all == status_$ok) {
			if (namelen > TGNMLEN)
				namelen = TGNMLEN;
			bcopy(name, savegname, namelen);
		} else
			namelen = 0;
		savegname[namelen] = '\0';
	}
	strncpy(gname, savegname, TGNMLEN);
}


int
findgid(gname)
char *gname;
{
	int gid, junk;
	status_$t st;

	if (gname[0] != savegname[0]	/* Quick test w/o proc call */
	    || 0!=strncmp(gname, savegname, TUNMLEN)) {
		strncpy(savegname, gname, TUNMLEN);
		rgyc_$pgo_name_to_num(rgyc_$pgo_group, *gname, strlen(gname), junk, gid, st);
		savegid = (st.all == status_$ok) ? gid : mygid;
	}
	return savegid;
}
#endif
