/* File: wrapbox.h
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * WrapBox - put glyps in a TBBox or LRBox, but wrap them to the next row or
 *           column if they do not fit in the specified size.
 */

#ifndef wrapbox_h
#define wrapbox_h

#include <InterViews/composition.h>
#include <InterViews/coord.h>

class LRWrapBox : public LRComposition {
public:
  LRWrapBox(Coord width, GlyphIndex size = 10);
  LRWrapBox(GlyphIndex num_glyphs_across, GlyphIndex size = 10);
  ~LRWrapBox();
  LRWrapBox();
  virtual void append(Glyph* g);
};

class TBWrapBox : public TBComposition {
public:
  TBWrapBox(Coord height, GlyphIndex size = 10);
  TBWrapBox(GlyphIndex num_glyphs_down, GlyphIndex size = 10);
  ~TBWrapBox();

  virtual void append(Glyph* g);
};

#endif
