/* File: wrapbox.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * WrapBox - put glyps in a TBBox or LRBox, but wrap them to the next row or
 *           column if they do not fit in the specified size.
 */


#include <InterViews/simplecomp.h>
#include <InterViews/arraycomp.h>
#include <InterViews/discretion.h>
#include <InterViews/box.h>

#include "wrapbox.h"

LRWrapBox::LRWrapBox(
	  Coord width, GlyphIndex size
	  ) : LRComposition(new TBBox, new SimpleCompositor,
				/* no seperator */ nil, width, size) { }
			
LRWrapBox::LRWrapBox(
	  GlyphIndex num_glyphs_across, GlyphIndex size
	  ) : LRComposition(new TBBox, new ArrayCompositor(num_glyphs_across),
				/* no seperator */ nil, 0.0, size) { }
			
LRWrapBox::~LRWrapBox() { }

void LRWrapBox::append(Glyph* g)
{
  static Discretionary* ok_to_break = new Discretionary(0, nil, nil, nil, nil);
  Composition::append(g);
  Composition::append(ok_to_break);
}

TBWrapBox::TBWrapBox(
	  Coord height, GlyphIndex size
     ) : TBComposition(new LRBox, new SimpleCompositor, /* no seperator */ nil,
			    height, size) { }

TBWrapBox::TBWrapBox(
	  GlyphIndex num_glyphs_down, GlyphIndex size
	  ) : TBComposition(new TBBox, new ArrayCompositor(num_glyphs_down),
				/* no seperator */ nil, 0.0, size) { }

TBWrapBox::~TBWrapBox() { }

void TBWrapBox::append(Glyph* g)
{
  static Discretionary* ok_to_break = new Discretionary(0, nil, nil, nil, nil);
  Composition::append(g);
  Composition::append(ok_to_break);
}
