/* File: toggle_button.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * ToggleButton
 */

#include "toggle_button.h"

#include <IV-look/telltale.h>
#include <InterViews/action.h>
#include <InterViews/event.h>
#include <InterViews/listener.h>
#include <InterViews/resource.h>

#include <stream.h>

// Function:
//   Creates a new button with a telltale and both a 'select action' and 
//   a 'deselectAction'.

ToggleButton::ToggleButton(Telltale* t, Action* select, Action* deselect,
        boolean* value) :
    GenericButton(t, select)
{
  _value = value;

  if (_deselect_action)
    _deselect_action = deselect;
  else
    _deselect_action = select;

  Resource::ref(_deselect_action);
  if (_value) choose(*_value);
}

// Function:
//   Destruct the instance and unref the deselect action.

ToggleButton::~ToggleButton()
{
    Resource::unref(_deselect_action);
}

// Function:
//   If button is enabled and the cursor is over the button handle
//   the commit function by toggling the chosen flag and executing the
//   appropriate action (select or deselect) if it exists.

void ToggleButton::commit(Event& anEvent)
{
  if (enabled()) {
    if (listener()->picks(anEvent.pointer_x(), anEvent.pointer_y())) {
      choose(!chosen());
      if (chosen()) {
	if (_value) *_value = true;
	if (select_action() != nil)
	  select_action()->execute();
      } else {
	if (_value) *_value = false;
	if (deselect_action() != nil)
	  deselect_action()->execute();
      }
    }
  }
}
