/*
 * GEMS text editor
 */

#ifndef gems_text_editor_h
#define gems_text_editor_h

#include <InterViews/handler.h>
#include <InterViews/event.h>
#include <InterViews/monoglyph.h>
#include <InterViews/boolean.h>
#include <OS/string.h>

class Listener;
class Action;

class GemsTextEditor : public MonoGlyph, public Handler {
public:
  GemsTextEditor(GemsLabel* label =nil, Glyph* body =nil, 
       	       	 Action* OK =nil, Action* Cancel =nil, Action* keypress =nil);
  ~GemsTextEditor();
  virtual void event(Event&);
  void string(char*);
  char* string();
  
private:
  Action* _OK;
  Action* _Cancel;
  Action* _keypress;
  boolean _grabbed;
  Listener* _listener;
  GemsLabel* _text;
  enum {return_key = 96, escape_key = 36, control_key = 83, delete_key = 73,
	letter_a = 84, letter_e = 63, letter_f = 87, letter_b = 111,
	letter_k = 91};
};

#endif

