/* File: radio_button.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * GemsRadioButton
 */


#include "radio_button.h"

#include <IV-look/telltale.h>
#include <InterViews/action.h>
#include <InterViews/event.h>
#include <InterViews/listener.h>
//#include <InterViews/sensor.h>
//#include <InterViews/world.h>

#include <stream.h>

GemsRadioButton::GemsRadioButton(Telltale* t, Action* select, Action* deselect, boolean* value)
    : ToggleButton(t, select, deselect, value)
{
}

// Function:
//   Destruct the instance.

GemsRadioButton::~GemsRadioButton()
{
}

// Function:
//   If button is enabled and not yet chosen support drag function by
//   highlighting the telltale only when the cursor is over the button.

void GemsRadioButton::drag(Event& anEvent)
{
    if (enabled() && !chosen() && telltale() != nil) {
	telltale()->highlight(listener()->picks(anEvent.pointer_x(),
						anEvent.pointer_y()));
    }
}

// Function:
//   If button is enabled and not yet chosen support release function
//   by making sure the telltale is no longer highlighted.

void GemsRadioButton::release(Event& anEvent)
{
    if (enabled() && !chosen() && telltale() != nil) {
	telltale()->highlight(false);
    }
    PointerHandler::release(anEvent);
}

// Function:
//   If button is enabled, not yet chosen and the cursor is over the
//   button handle the commit function by choosing the button and if
//   in addition the action exists executing it.

void GemsRadioButton::commit(Event& anEvent)
{
    if (enabled()) {
	if (listener()->picks(anEvent.pointer_x(), anEvent.pointer_y())) {
	    if (!chosen()) {
		choose(true);
		if (select_action() != nil) {
		    select_action()->execute();
		}
	    }
	}
    }
}
