/* File: gems_mono_kit.h
 * Created: 4/7/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * GemsMonoKit -- object for creating common UI components
 */

#ifndef mono_mf_kit_h
#define mono_mf_kit_h

#include <UI/kit.h>

class  GemsMonoKitImpl;

class GemsMonoKit : public GemsKit {
public:
  GemsMonoKit();
  virtual ~GemsMonoKit();
  
  /*
   * Beveling for shading
   */
  virtual Glyph* inset_diamond(Glyph* g, Style* s) const;
  virtual Glyph* outset_diamond(Glyph* g, Style* s) const;
  virtual Glyph* flat_diamond(Glyph* g, Style* s) const;

  /* 
   * Label
   */
  virtual GemsLabel* label(char*, Style*) const;

 /* 
   * TextEditor
   */
  virtual GemsTextEditor* text_editor(
       Style*, char* default_text ="", Action* ok =nil, Action* cancel =nil, 
       Action* keypress =nil
   ) const;

  /* 
   * Generic Buttons
   */

  virtual GenericButton* push_button(Glyph*, Style*, Action* =nil,
	Glyph* =nil, Glyph* =nil) const;

  virtual ToggleButton* toggle_button(Style*, Action* =nil,
	Action* =nil, Glyph* =nil, Glyph* =nil, boolean* =nil) const;

  virtual ToggleButton* toggle_button(Glyph*, Style*, Action* =nil,
    	Action* =nil, Glyph* =nil, Glyph* =nil, boolean* =nil) const;

  virtual GemsRadioButton* radio_button(Style*, Action* =nil, Action* =nil,
 	Glyph* =nil, Glyph* =nil, boolean* =nil, Coord =20.0) const;

  virtual GemsRadioButton* radio_button(Glyph*, Style*, Action* =nil, Action* =nil,
	Glyph* =nil, Glyph* =nil, boolean* =nil) const;

private:
  GemsMonoKitImpl* _impl;
};


#endif
