/* File: gems_mf_kit.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * GemsMFKit -- object for creating common UI components
 */

#include "mf_kit.h"
#include "generic_button.h"
#include "toggle_button.h"
#include "radio_button.h"
#include "diamond_beveller.h"
#include  "label.h"
#include "text_editor.h"

#include <InterViews/bitmap.h>
#include <InterViews/center.h>
#include <InterViews/box.h>
#include <InterViews/font.h>
#include <InterViews/glue.h>
#include <InterViews/border.h>
#include <InterViews/margin.h>
#include <InterViews/style.h>
#include <InterViews/Bitmaps/checkmark.bm>

#include <IV-look/choice.h>

#include <OS/string.h>

#include <stream.h>

class GemsMFKitImpl {
private:
    friend class GemsMFKit;

    GemsMFKitImpl();
    ~GemsMFKitImpl();

    Coord frame_thickness(Style*);

    Glyph* GemsMFKitImpl::body(Glyph* left, Glyph* right, Glyph* g);
    ChoiceItem* GemsMFKitImpl::choice(Glyph* normal, Glyph* pressed, Glyph* disabled);
    ChoiceItem* GemsMFKitImpl::choice(Glyph* normal, Glyph* pressed);
  
    Bitmap* checkmark_;
};

GemsMFKit::GemsMFKit() {
    _impl = new GemsMFKitImpl;
}

GemsMFKit::~GemsMFKit() {
    delete _impl;
}

GemsMFKitImpl::GemsMFKitImpl() {
    checkmark_ = new Bitmap(
	checkmark_bits, checkmark_width, checkmark_height,
	checkmark_x_hot, checkmark_y_hot
    );
    checkmark_->ref();
}

GemsMFKitImpl::~GemsMFKitImpl() {
    Resource::unref(checkmark_);
}

Glyph* GemsMFKit::inset_diamond(Glyph* g, Style* s) const
{
    return new Bevel(g, diamond, s->dark(), s-> dull(), s ->light(),
		     _impl->frame_thickness(s));
}

Glyph* GemsMFKit::outset_diamond(Glyph* g, Style* s) const
{
    return new Bevel(g, diamond, s->light(), s-> flat(), s ->dark(),
		     _impl->frame_thickness(s));
}

Glyph* GemsMFKit::flat_diamond(Glyph* g, Style* s) const
{
    return new Bevel(g, diamond, s->flat(), s-> flat(), s ->flat(),
		     _impl->frame_thickness(s));
}

GemsLabel* GemsMFKit::label(char* label, Style* s) const
{
  return(new GemsLabel(label, s->font(), s->foreground()));
}

GemsTextEditor* GemsMFKit::text_editor(
       Style* style, char* default_text, Action* ok, Action* cancel, Action* keypress
   ) const
{
  Kit* kit = Kit::instance();

  GemsLabel* label = new GemsLabel(default_text, style->font(), style->foreground());

  Glyph* g1 = 
       	   new LRBox(
       	       new Margin(
       	       	   label,
       	       	   2.0
       	       ),
       	       new HGlue(0.0, fil, 0.0)
       	   );

  Glyph* g2 = new Bevel(g1, &Bevel::rect, style->dark(), style->light(), style->light(), _impl->frame_thickness(style));
//  Glyph* g2 = new Bevel(g1, diamond, style->dark(), style->light(), style->light(), 2.0);

  return(new GemsTextEditor(label, g2, ok, cancel, keypress));
}

GenericButton* GemsMFKit::push_button(Glyph* g, Style* s, Action* select,
	Glyph* left, Glyph* right) const
{
  Kit* kit = Kit::instance();
  Coord margin = 3.0;
  Coord in_margin = margin + _impl->frame_thickness(s);
  
  Glyph* normal = _impl->body(left, right,
	kit->outset_frame(new Margin(g, margin), s));

  Glyph* pressed = _impl->body(left, right,
        kit->inset_frame(new Margin(g, in_margin), s));

  return new GenericButton(_impl->choice(normal, pressed), select);
}

ToggleButton* GemsMFKit::toggle_button(Style* style, Action* select, Action* deselect,
	Glyph* left, Glyph* right, boolean* value) const
{
  Kit* kit = Kit::instance();
  Coord margin = 3.0;
  
  Glyph* on_pic = kit->label(" ", style);
  Glyph* off_pic = kit->label(" ", style);
  
  Glyph* normal = _impl->body(left, right, 
  	kit->outset_frame(new Margin(off_pic, margin), style));

  Glyph* pressed = _impl->body(left, right,
	kit->inset_frame(new Margin(on_pic, margin), style));

  Glyph* disabled = _impl->body(left, right,
    	kit->flat_frame(new Margin(off_pic, margin), style));

  ChoiceItem* choice = _impl->choice(normal, pressed, disabled);

  return(new ToggleButton(choice, select, deselect, value));
}

ToggleButton* GemsMFKit::toggle_button(Glyph* g, Style* s, Action* select,
	Action* deselect, Glyph* left, Glyph* right, boolean* value) const
{
  Kit* kit = Kit::instance();
  Coord margin = 3.0;
  Coord in_margin = margin + _impl->frame_thickness(s);
  
  Glyph* normal = _impl->body(left, right,
	kit->outset_frame(new Margin(g, margin), s));
	
  Glyph* pressed = _impl->body(left, right,
	kit->inset_frame(new Margin(g, in_margin), s));

  Glyph* disabled = _impl->body(left, right,
    	kit->flat_frame(new Margin(g, margin), s));
    
    ChoiceItem* choice = _impl->choice(normal, pressed, disabled);

    return(new ToggleButton(choice, select, deselect, value));
}

GemsRadioButton* GemsMFKit::radio_button(Style* s, Action* select, Action* deselect,
	Glyph* left, Glyph* right, boolean* value, Coord size) const
{
    Coord margin = 3.0;
    Coord in_margin = margin + _impl->frame_thickness(s);

//    Coord size = (((s != nil) && (s->font() != nil))? (0.8 * s->font()->ascent()) : 20);

    Glyph* square = new VCenter(new LRBox(new HGlue(size, 0, 0),
					  new VGlue(size, 0, 0)),
				0.0);

    Glyph* normal = _impl->body(left, right,
	new Margin(outset_diamond(square, s), margin));
    
    Glyph* pressed = _impl->body(left, right,
	new Margin(inset_diamond(square, s), margin));

    Glyph* disabled = _impl->body(left, right,
	new Margin(flat_diamond(square, s), margin));

    ChoiceItem* choice = _impl->choice(normal, pressed, disabled);

    return new GemsRadioButton(choice, select, deselect, value);
}

GemsRadioButton* GemsMFKit::radio_button(Glyph* g, Style* s, Action* select, Action* deselect,
	Glyph* left, Glyph* right, boolean* value) const
{
  Kit* kit = Kit::instance();
  Coord margin = 3.0;
  Coord in_margin = margin + _impl->frame_thickness(s);

  Glyph* normal = _impl->body(left, right,
  	kit->outset_frame(new Margin(g, margin), s));
	
  Glyph* pressed = _impl->body(left, right,
	kit->inset_frame(new Margin(g, in_margin),s));

  Glyph* disabled = _impl->body(left, right,
  	kit->flat_frame(new Margin(g, margin),s));
  
  ChoiceItem* choice = _impl->choice(normal, pressed, disabled);
  
  return new GemsRadioButton(choice, select, deselect, value);
}

/*
 * GemsMFKitImpl
 */

Coord GemsMFKitImpl::frame_thickness(Style* style)
{
  Coord c;
  if (!style->find_attribute("frameThickness", c)) {
    c = 2.0;
  }
  return c;
}

ChoiceItem* GemsMFKitImpl::choice(Glyph* normal, Glyph* pressed)
{
  return(new ChoiceItem(normal, pressed));
}

ChoiceItem* GemsMFKitImpl::choice(Glyph* normal, Glyph* pressed, Glyph* disabled)
{
  ChoiceItem* choice = new ChoiceItem();
  
  for (unsigned int i = 0; i < choice->numlooks(); i++) {
    if (!choice->contains_looks(i, ChoiceItem::is_enabled)) {
      choice->look(i, disabled);
    } else {
      if ((choice->contains_looks(i, ChoiceItem::is_pressed)) ==
	  (choice->contains_looks(i, ChoiceItem::is_chosen))) {
	choice->look(i, normal);
      } else {
	choice->look(i, pressed);
      }
    }
  }
  return(choice);
}

Glyph* GemsMFKitImpl::body(Glyph* left, Glyph* right, Glyph* g)
{
  Glyph* stretch = new HGlue(5.0, fil, 0.0);
  Glyph* fixed = new HGlue(5.0, 0.0, 0.0);
  Glyph* body;

  if (left  && !right) {
    body = new LRBox(
	left,
	stretch,
	g
   );		     
  } else if (!left && right) {
    body = new LRBox(
	g,
	fixed,
	right		   
   );		     
  } else if (left && right) {
    body = new LRBox(
	left,
	stretch,
	g,
	fixed,
	right		    
   );		     
  } else
    body = g;
  
  return(body);
}
