

#ifndef viewer_h
#define viewer_h

#include <InterViews/action.h>
#include <InterViews/handler.h>

#include <IV-look/adjuster.h>
#include <IV-look/adjustable.h>
#include <IV-look/button.h>

class Telltale;
class Patch;
class Event;

class Zoomer : public Button, public Adjuster {
public:
    Zoomer (Telltale*, Adjustable*, float zoom);

    virtual void zoom();
protected:
    virtual ~Zoomer();

    float _current;
    float _zoom;
};

class Viewer : public MonoGlyph, public Handler, public Adjustable {
public:
    Viewer (Glyph* view);

    virtual void event (Event&);
    virtual void draw(Canvas*, const Allocation&) const;
    virtual void allocate(Canvas*, const Allocation&, Extension&);
//    virtual void request(Requisition&) const;

    virtual Coord lower(DimensionName);
    virtual Coord upper(DimensionName);
    virtual Coord length(DimensionName);
    virtual Coord cur_lower(DimensionName);
    virtual Coord cur_upper(DimensionName);
    virtual Coord cur_length(DimensionName);

    virtual void scroll_forward(DimensionName);
    virtual void scroll_backward(DimensionName);
    virtual void page_forward(DimensionName);
    virtual void page_backward(DimensionName);

    virtual void scroll_to (DimensionName, Coord);
    virtual void zoom_to (float, float);
    virtual void zoom_to_fit(Coord, Coord);
    virtual void scroll_and_zoom_to(Coord, Coord, Coord, Coord);
protected:
    virtual ~Viewer ();

    virtual void notify ();

    float _zoom_x;
    float _zoom_y;
    Coord _current[Dimension_Undefined];
    Glyph* _view;
    Patch* _patch;
    Coord x,y;
};

#endif
