/* File: test_bed.c
 * Created: 4/27/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

#include <OS/string.h>

#include <InterViews/deck.h>
#include <InterViews/box.h>
#include <InterViews/style.h>
#include <InterViews/glue.h>
#include <IV-look/kit.h>
#include <IV-look/field.h>

#include <stdio.h>

#include "test_bed.h"
#include "gems.h"

TestBed::TestBed(
       Glyph* g1, Glyph* g2, Glyph* g3, Glyph* g4, Glyph* g5,
       Glyph* g6, Glyph* g7, Glyph* g8, Glyph* g9, Glyph* g10
   ) : Patch(nil), Adjustable()
{
  Gems* gems = Gems::instance();
  Style* style = gems->style();
  Kit* kit = Kit::instance();

  body(_deck = new Deck());

  if (g1) MonoGlyph::append(g1);
  if (g2) MonoGlyph::append(g2);
  if (g3) MonoGlyph::append(g3);
  if (g4) MonoGlyph::append(g4);
  if (g5) MonoGlyph::append(g5);
  if (g6) MonoGlyph::append(g6);
  if (g7) MonoGlyph::append(g7);
  if (g8) MonoGlyph::append(g8);
  if (g9) MonoGlyph::append(g9);
  if (g10) MonoGlyph::append(g10);

  _deck->flip_to(0);
  static char buf[20];
  sprintf(buf, "%d of %d", _deck->card()+1, count());

  Glyph* fixed_hsep = new HGlue(2.0, 0.0, 0.0);

  _adjuster = 
       new LRBox(
       	   kit->left_mover(this, style),
	   fixed_hsep,
       	   _display  = new FieldEditor(buf, style),
	   fixed_hsep,
       	   kit->right_mover(this, style)
       );
  update_display();
}

TestBed::~TestBed() { }

void TestBed::scroll_backward(DimensionName)
{
  printf("TestBed::scroll_backward()\n");

  GlyphIndex num_cards = _deck->count();
  GlyphIndex current_card = _deck->card();
  GlyphIndex new_card = (current_card+1) % num_cards;

  printf("\tnum_cards=%d\n", num_cards);
  printf("\tcurrent_card=%d\n", current_card);
  printf("\tnew_card=%d\n", new_card);

  if (num_cards <= 1)
    return;

  use(new_card);
}

void TestBed::scroll_forward(DimensionName)
{
  printf("TestBed::scroll_forward()\n");

  GlyphIndex num_cards = _deck->count();
  GlyphIndex current_card = _deck->card();
  GlyphIndex new_card = (current_card ? current_card-1 : num_cards-1);

  printf("\tnum_cards=%d\n", num_cards);
  printf("\tcurrent_card=%d\n", current_card);
  printf("\tnew_card=%d\n", new_card);

  if (num_cards <= 1)
    return;

  use(new_card);
}

void TestBed::update_display()
{
  static char buf[20];
  sprintf(buf, "%d of %d", _deck->card()+1, count());
  printf("TestBed::update_display()\n");
  printf("\tbuf=%s\n", buf);
  _display->field(buf);
}

void TestBed::use(GlyphIndex index)
{
  _deck->flip_to(index);
  update_display();
  reallocate();
  redraw();
}

void TestBed::append(Glyph* g)
{
  MonoGlyph::append(g);
  use(count()-1);
}

void TestBed::remove(GlyphIndex index)
{
  GlyphIndex current_card = _deck->card();

  if (current_card == index) {
    MonoGlyph::remove(index);
    GlyphIndex num_cards = _deck->count();
    GlyphIndex new_card = (current_card ? current_card-1 : num_cards-1);
    use(new_card);
  } else {
    MonoGlyph::remove(index);
    update_display();    
  }
}
