#include <stdio.h>
#include <InterViews/brush.h>
#include <InterViews/color.h>
#include <InterViews/patch.h>
#include <stream.h>
#include <strings.h>

#include "figure.h"
#include "query.h"
#include "map.h"
#include "selection.h"

/* 
 * Graphics
 */


TPolyline::TPolyline(const Color* fill, Coord* x, Coord* y, int count, Map* map) :
	       Polyline(map->get_selection()->unselected_brush(), map->get_selection()->street_border(), 
		 fill, x, y, count)
{ 
  _map = map;
}

TPolyline::~TPolyline()
{ }

void TPolyline::draw(Canvas* c, const Allocation& a) const
{
//  printf("in polyline draw\n");
//  c->push_transform();
//  c->transform(*(_map->viewer()->transformer()));
  Patch::draw(c, a);
//  c->pop_transform();
}

TPolygon::TPolygon(const Color* fill, Coord* x, Coord* y, int count, Map* map) :
	       Polygon(map->get_selection()->unselected_brush(), map->get_selection()->area_border(), 
		 fill, x, y, count)
{ 
  _map = map;
}

TPolygon::~TPolygon()
{ }

void TPolygon::draw(Canvas* c, const Allocation& a) const
{
//  printf("in polyline draw\n");
//  c->push_transform();
//  c->transform(*(_map->viewer()->transformer()));
  Patch::draw(c, a);
//  c->pop_transform();
}

TRectangle::TRectangle(const Color* fill, Coord l, Coord b, Coord r, Coord t, Map* map) :
	       Rectangle(map->get_selection()->unselected_brush(), map->get_selection()->grid_border(), 
		 fill, l, b, r, t)
{ 
  _map = map;
}

TRectangle::~TRectangle()
{ }

void TRectangle::draw(Canvas* c, const Allocation& a) const
{
//  printf("in polyline draw\n");
//  c->push_transform();
//  c->transform(*(_map->viewer()->transformer()));
  Patch::draw(c, a);
//  c->pop_transform();
}


Street::Street(Coord* x, Coord* y, int count, char* name, Map* map,
	       const Color* fill) :
	       TPolyline(fill, x, y, count, map)
{
  button(true, Event::left);
  button(true, Event::middle);
  _name = new char[strlen(name) + 1];
  strcpy(_name,name);
}	       

Street::~Street()
{
  unref(this);
}

void Street::set_name(char* name)
{
  delete _name;
  _name = new char[strlen(name) + 1];
  strcpy(_name,name);
}

void Street::press(Event& e)
{
  printf("Street::event() %s\n", _name);
  _map->status_line(_name);
  if (e.pointer_button() == Event::left) _map->get_selection()->replace_selection(this);
  else _map->get_selection()->add_selection(this);
}

Area::Area(Coord* x, Coord* y, int count, char* name, Map* map,
        const Color* fill) :
	TPolygon(fill, x, y, count, map)
{
  button(true, Event::left);
  button(true, Event::middle);
  _name = new char[strlen(name) + 1];
  strcpy(_name,name);
}	       

Area::~Area()
{
  unref(this);
}

void Area::set_name(char* name)
{
  delete _name;
  _name = new char[strlen(name) + 1];
  strcpy(_name,name);
}

void Area::press(Event& e)
{
  printf("Area::event() %s\n", _name);
  _map->status_line(_name);
  if (e.pointer_button() == Event::left) _map->get_selection()->replace_selection(this);
  else _map->get_selection()->add_selection(this);
}

Grid::Grid(Coord l, Coord b, Coord r, Coord t, char* name, Map* map, 
	   const Color* fill) :
	   TRectangle(fill, l, b, r, t, map)
{
  button(true, Event::left);
  button(true, Event::middle);
  _name = new char[strlen(name) + 1];
  strcpy(_name,name);
}	       

Grid::~Grid()
{
  unref(this);
}

void Grid::set_name(char* name)
{
  delete _name;
  _name = new char[strlen(name) + 1];
  strcpy(_name,name);
}

void Grid::press(Event& e)
{
  printf("Grid::event() %s\n", _name);
  _map->status_line(_name);
  if (e.pointer_button() == Event::left) _map->get_selection()->replace_selection(this);
  else _map->get_selection()->add_selection(this);
}

/*
 * Tools
 */

MapView::MapView(
       Map* map, Coord label_width, Coord list_height, Coord list_width, 
       char* item1, char* item2,
       char* item3, char* item4,
       char* item5, char* item6,
       char* item7, char* item8,
       char* item9, char* item10
   ) : MapViewTool(
       label_width, list_height, list_width,
       item1, item2,
       item3, item4,
       item5, item6,
       item7, item8,
       item9, item10
   )
{
  _map = map;
/*  DrawingBox* box = _map->drawing_box();

  _streets = new Drawing(box, Event::middle);
  _neighbohoods = new Drawing(box, Event::none);

  make_streets();
  make_neightborhoods();
}

void MapView::make_streets()
{
  Brush* b = new Brush(2.0);     	 // drawing thickness
  const Color* c = style->foreground();  // drawing color
  Color* f = nil;      	       	   	 // fill color
  
  static Coord x1[] = { 40, 100, 100, 80, 20 };
  static Coord y1[] = { 40, 60, 140, 140, 80 };

  static Coord x2[] = { 50, 200, 170, 50 };
  static Coord y2[] = { 50, 50, 170, 200 };

  const Color* color = style->foreground();  // drawing color
  Brush* brush = new Brush(1.0);
  Rectangle* rect = new Rectangle(brush, color, color, 0.0, 0.0, 2.0, 2.0);
  Resource::unref(rect);



       	   new Overlay(
       	       new VGlue(3000.0, fil, fil),
       	       new HGlue(3000.0, fil, fil),
       	       new Area(b, c, f, x2, y2, sizeof(x2) / sizeof(Coord), "Oakland"),
       	       new Street(b, c, f, x1, y1, sizeof(x1) / sizeof(Coord), "Forbes"),
       	   ),
*/
}

void MapView::grids()
{
//  printf("Query layer: turning grids %s\n", (_grids_value ? "on" : "off"));
}
