#include <InterViews/display.h>
#include <InterViews/background.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/color.h>

#include <stdio.h>

#include <UI/string_list.h>

#include "gems.h"
#include "toolbox.h"
#include "toolbox_tools.h"
#include "query.h"
#include "map.h"
#include "figure.h"

static PropertyData props[] = {
    { "*datapath", "/afs/cs/usr/jb7p/local/include/" },
    { "*pretty", "off" },
    { "*network", "on" },
    { nil }
};

static OptionDesc options[] = {
    { "data=", "*datapath", OptionValueAfter },
    { "-pretty", "*pretty", OptionValueImplicit, "on" },
    { "-nonetwork", "*network", OptionValueImplicit, "off" },
    { nil }
};

int main(int argc, char** argv)
{
  Session* session = new Session("Gems", argc, argv, options, props);
  Gems* gems = Gems::instance(session);
  Style* style = gems->style();
  Display* d = gems->display();

  SimulationController* simulation_controller = gems->controller();

  Map* map = new Map("Pittsburgh");

  map->drawing_box()->prepend(new Grid(30, 30, 100, 100,
				"Jason's Grid", map,
				      new Color(0.0, 0.8, 0.0)));

  Coord x[4], y[4];
  x[0] = 30;
  x[1] = 60;
  x[2] = 110;
  x[3] = 250;
  y[0] = 120;
  y[1] = 200;
  y[2] = 150;
  y[3] = 280;
  map->drawing_box()->prepend(new Street(x, y, 4,
			     "Jason's street", map, nil));
  x[0] = 300;
  x[1] = 350;
  x[2] = 390;
  x[3] = 330;
  y[0] = 100;
  y[1] = 150;
  y[2] = 110;
  y[3] = 50;
  map->drawing_box()->prepend(new Area(x, y, 4,
			   "Jason's area", map,
				      new Color(0.0, 0.5, 0.5)));

  map->display();

  Coord label_width = 90.0;
  Coord list_height = 200.0;
  Coord list_width = 150.0;

  StringList* locations = make_string_list("LA", "Pittsburgh");

  StringList* counties = make_string_list("Ventura", "LA", "San Bernadino", "Orange", "Riverside", "Santa Barbara");
  StringList* districts = make_string_list("1", "2", "3");
  StringList* tracts = make_string_list("5", "6", "7", "8", "9");
  StringList* point_sources = make_string_list("New York City");
  
  StringList* chemistry_simulations = make_string_list("Particle Track", "Contor Map", "Two Dimensional Graph", "Streamline");
  StringList* chemicals = make_string_list("Ozone", "CO2");
  StringList* heights = make_string_list("0", "200", "400", "600", "800", "1000", "1100");
  StringList* dates = make_string_list("8/27/87", "8/28/87", "8/29/87");

  StringList* population_simulations = make_string_list("Contor Map", "Two Dimensional Graph");
  StringList* ages = make_string_list("0-10", "11-20", "21-30", "31-40", "41-50", "51-60", "over 60");
  StringList* ethnicities = make_string_list("Hispanic", "Asian", "Black", "Caucasian");

  MapView* map_view = 
       new MapView(
       	   map, label_width, list_height, list_width,
	   "Counties", "Point Sources",
	   "Districts", "Grids", 
	   "Tracts", "Landsat"
       );
  map_view->append_list("Location", locations);

  WhereIsTool* where_is = new WhereIsTool(label_width, list_height, list_width);
  where_is->append_list("Counties", counties);
  where_is->append_list("Districts", districts);
  where_is->append_list("Tracts", tracts);
  where_is->append_list("Point Sources", point_sources);

  ChemistryTool* chemistry = new ChemistryTool(
       map, label_width, list_height, list_width
     );
  chemistry->append_list("Simulation", chemistry_simulations);
  chemistry->append_list("Chemical1", chemicals);
  chemistry->append_list("Chemical2", chemicals);
  chemistry->append_list("Height", heights);
  chemistry->append_list("Date", dates);

  PopulationTool* population = new PopulationTool(label_width, list_height, list_width);
  population->append_list("Simulation", population_simulations);
  population->append_list("Age", ages);
  population->append_list("Ethnicity", ethnicities);
    
  PointSourceTool* point_source = new PointSourceTool(
       label_width, list_height, list_width
   );


  Toolbox *toolbox =
       new Toolbox(
       	   map_view,
	   where_is,
	   chemistry,
       	   population,
       	   point_source
       );

  gems->run();

  delete toolbox;
  delete map;
  delete gems;
  return 0;

}
