/* File: color_scale.h
 * Created: 4/28/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

#ifndef color_scale_h
#define color_scale_h

#include <InterViews/monoglyph.h>
#include <InterViews/color.h>

#include <math.h>

class CubicSpline;

class ColorScale : public MonoGlyph {
public:
  ColorScale(int num_colors);
  ~ColorScale();

  int linear_index(Coord v, Coord min, Coord max);
  int log10_index(Coord v, Coord min, Coord max);
  Color* color(int index);
  
  int num_colors();

private:
  CubicSpline* r_spline();
  CubicSpline* g_spline();
  CubicSpline* b_spline();

  Color** _color;
  int _num_colors;
};  

inline int ColorScale::linear_index(Coord v, Coord min, Coord max)
{
//  fprintf(stderr, "ColorScale::linear_index\n");
//  printf("\tv=%f z_min=%f z_max=%f\n", v, min, max);

  int index;

  if (v < min)
    index = 0;
  else if (v > max)
    index = _num_colors - 1;
  else {
    Coord increment = ((max - min) / ((float) (_num_colors - 1)));
    index = (int) ((v - min) / increment);
  }
  return(index);
}  

inline int ColorScale::log10_index(Coord v, Coord min, Coord max)
{
//  fprintf(stderr, "ColorScale::log_index\n");
//  printf("\tv=%f z_min=%f z_max=%f\n", v, min, max);

  int index;

  if (v < min)
    index = 0;
  else if (v > max)
    index = _num_colors - 1;
  else {
    Coord increment = (log10(max - min + 1) / ((float) (_num_colors - 1)));
    index = (int) (log10(v - min + 1) / increment);
  }
  return(index);
}  

inline Color* ColorScale::color(int index)
   { return(_color[index]); }

inline int ColorScale::num_colors()
   { return(_num_colors); }    

#endif
