%% Herbert Voss <hvoss@tug.org>
%% Copyright (C) 2025
%%
%% This program can be redistributed and/or modified under the terms
%% of the LaTeX Project Public License Distributed from CTAN archives
%% in directory macros/latex/base/lppl.txt.
%%
%% width=2\textwidth+\leftmargin+\rightmargin   height=variable
%% _With_ additional text on the doublepage
%%
%% ------------------------------------- the doublepage obejcts ---------------------------
%% ||1in+evenside --- |1in+oddside ---||
%
\def\do@hvFloat@doublePage#1{%  image on left and right page with caption on the right page 
  % #1-> 0/1 caption under/right
  \setcounter{topnumber}{1}%
  \setcounter{dbltopnumber}{1}%
  \global\hv@leftPageObjectWidth=\the\dimexpr\paperwidth-1in-\evensidemargin-\hvSet@bindCorrection\relax
  \global\hv@tempWidthA=\the\dimexpr1in+\oddsidemargin-\hvSet@bindCorrection\relax
  \xdef\hv@caption@format@temp{\hv@caption@format}%  it gets lost otherwise for next afterpage
  \@dblfpbot=0\p@ \@plus 1fil%
  \global\hv@switchTypefalse
  \setcounter{hv@tempCNTfigA}{\value{figure}}%
  \setcounter{hv@tempCNTfigB}{\value{figure}}%
  \setcounter{hv@tempCNTtabA}{\value{table}}%
  \setcounter{hv@tempCNTtabB}{\value{table}}%
  \savebox\hvCaptionBox{%   NO rotation
    \minipage{\textwidth}%% minipage, to get hyphenation
      \let\@captype\hv@floatType
      \caption*{\hv@longCap}%
    \endminipage}%
  \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
  \ifnum#1=0\relax    % no rotation, caption below
    \@tempdima=\dimexpr\ht\hvObjectBox+\ht\hvCaptionBox+\abovecaptionskip+\belowcaptionskip +\textfloatsep\relax%+\floatsep\relax
    \ifdim\@tempdima > \dimexpr\textheight-\hv@minTextlines\relax
      \hv@switchTypetrue
    \fi
  \fi
  \ifhv@forceOutput
    \do@hvFloat@doublePAGECaptionRight{#1}%   no cheque
  \else
  \checkoddpage
  \ifoddpage %  we are on the right page 
    \if@twocolumn
      \if@firstcolumn % we are in the left column of the right page
        \ifhv@switchType
          \afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
            \do@hvFloat@doublePAGECaptionRight{#1}}%
        \else
          \afterpage{%
            %\afterpage{%
               \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
            \do@hvFloat@doublePageCaptionRight{#1}}%}%
        \fi
      \else % we are in the right column of the right page
        \ifhv@tugboat
          \do@hvFloat@doublePageCaptionRight{#1}%
        \else
          \ifhv@switchType
            \do@hvFloat@doublePAGECaptionRight{#1}%
          \else
            \afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
            \do@hvFloat@doublePageCaptionRight{#1}}%
          \fi
        \fi
      \fi
    \else% onecolumn
      \ifhv@switchType
        \do@hvFloat@doublePAGECaptionRight{#1}%
      \else
        \ifhv@forceLeft
          \do@hvFloat@doublePageCaptionRight{#1}%   no \afterpage
        \else
          \afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
          \do@hvFloat@doublePageCaptionRight{#1}}%
        \fi
      \fi
    \fi  
  \else% we have an even page
      \if@twocolumn
        \if@firstcolumn % We are in the left column of the left page
          \ifhv@switchType
            \afterpage{\afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
              \do@hvFloat@doublePAGECaptionRight{#1}}}%
          \else % 
            \afterpage{\afterpage{%\afterpage{%
              \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
              \do@hvFloat@doublePageCaptionRight{#1}}}%}%
          \fi
        \else% second column(right column on left page) 
          \ifhv@switchType
            \afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
            \do@hvFloat@doublePAGECaptionRight{#1}}%
          \else
            \afterpage{\afterpage{%
              \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
              \do@hvFloat@doublePageCaptionRight{#1}}}%
          \fi
        \fi
      \else% onecolumn
        \ifhv@switchType
          \afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
            \do@hvFloat@doublePAGECaptionRight{#1}}%
        \else
          \ifhv@forceLeft
            \afterpage{%
             \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
             \do@hvFloat@doublePageCaptionRight{#1}}%
          \else
            \afterpage{\afterpage{%
            \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
              \do@hvFloat@doublePageCaptionRight{#1}}}%
          \fi
        \fi
      \fi
  \fi
  \let\@fptop\hv@fptop
  \fi
 \endgroup% started at main macro \hvFloat
}
%
\def\do@hvFloat@doublePageCaptionRight#1{%  image on left and right page with caption on the right page ----------------------------------
  \setcounter{topnumber}{1}%
  \setcounter{dbltopnumber}{1}%
  \hfuzz=\maxdimen
  \vfuzz=\maxdimen
  \hbadness=10000
  \vbadness=10000
  \hvfloat@typeout{do@hvFloat@doublePageCaptionRight->start}%
  \do@hvFloat@doublePageCaptionRightObjectLeft{0pt}% 
  \do@hvFloat@doublePageCaptionRightObjectRight{#1}%
}
%
\def\do@hvFloat@doublePageCaptionRightObjectLeft#1{% left part of the object
  \begin{\hv@floatType*}[t]
    \hvfloat@typeout{>>>doublePage: begin with left side of the object \hv@floatObject}%
    \hv@set@noverticalSpace
    \hfuzz=\maxdimen
    \vfuzz=\maxdimen
  \hbadness=10000
  \vbadness=10000
    \let\c@hv@tempCNTfigA\c@figure
    \let\c@hv@tempCNTtabA\c@table
    \expandafter\hvFloatSet\expandafter{\hv@save@setting}% 
    \hvfloat@typeout{Float position parameter is for left page: !t}%    
    \global\savebox{\hvObjectBox}{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
    \clipbox*{0 -\depth{} \hv@leftPageObjectWidth{} \height}{\usebox\hvObjectBox}%
    \ifx\hv@label\@empty
    \else
      \ifx\hv@floatType\hv@figure
        \global\refstepcounter{hv@tempCNTfigA}%
      \else
        \global\refstepcounter{hv@tempCNTtabA}%   before caption
      \fi
      \label{\hv@label}%
    \fi        
    \ifhv@global@sameHeight \ifx\hvSet@capPos\hv@Bottom % only for capPos=bottom
      \hvfloat@typeout{text should be of same height of both pages}%
      \par\noindent\phantom{\parbox{\textwidth}{\caption*{\hv@longCap}}}%
      \vspace{\belowcaptionskip}%  default 
    \fi\fi
    \hv@reset@noverticalSpace
  \end{\hv@floatType*}%
}

\def\do@hvFloat@doublePageCaptionRightObjectRight#1{% right part of the object
  \begin{\hv@floatType*}[t]
    \hv@set@noverticalSpace
      \hfuzz=\maxdimen
          \vfuzz=\maxdimen
  \hbadness=10000
  \vbadness=10000
    \let\c@hv@tempCNTfigA\c@figure
    \let\c@hv@tempCNTtabA\c@table
    \expandafter\hvFloatSet\expandafter{\hv@save@setting}%    
    \global\savebox\hvObjectBox{\ifhv@useOBox\usebox{\hvOBox}\else\hv@floatObject\fi}%
    \hv@tempWidthA=\the\dimexpr1in+\oddsidemargin-\hvSet@bindCorrection\relax%   FÜR DTK
    \hspace*{-\hv@tempWidthA}%
    \hv@leftPageObjectWidth=\the\dimexpr\paperwidth-1in-\evensidemargin-\hvSet@bindCorrection\relax%  FÜR FTK
    \savebox\hv@rightBox{\clipbox*{\hv@leftPageObjectWidth{} -\depth{} \width{} \height{}}{\usebox\hvObjectBox}}%
    \hv@tempWidthB=\dimexpr\textwidth-\wd\hv@rightBox-\hvSet@bindCorrection+1in+\oddsidemargin-\hv@floatCapSep\relax
    \hvfloat@typeout{Height of right box: \the\ht\hv@rightBox}%
    \hvfloat@typeout{Depth of right box : \the\dp\hv@rightBox}%
       \ifdim\dp\hv@rightBox > \z@
           \raisebox{\depth}{\usebox\hv@rightBox}%
       \else
         \usebox\hv@rightBox
       \fi
       \c@hv@tempCNTfigB=\numexpr\c@figure-1\relax
       \c@hv@tempCNTtabB=\numexpr\c@table-1\relax
       \ifx\hv@label\@empty\else
         \ifx\hv@floatType\hv@figure
           \refstepcounter{hv@tempCNTfigB}%
         \else
           \refstepcounter{hv@tempCNTtabB}%   before caption
         \fi
         \label{\hv@label-2}%
       \fi        
       \ifx\hv@caption@format@temp\@empty\else
         \expandafter\captionsetup\expandafter{\hv@caption@format@temp}%
       \fi
       \c@figure=\numexpr\c@hv@tempCNTfigB-1\relax
       \c@table=\numexpr\c@hv@tempCNTtabB-1\relax
       \ifnum#1>\z@		% caption on the right
         \hvfloat@typeout{doublePage: capAngle=\hvSet@capAngle}%
         \ifnum\hvSet@capAngle > \z@
           \hspace{\hv@floatCapSep}%        
           \rlap{\rotatebox{\hvSet@capAngle}{\parbox[b]{\the\dimexpr\ht\hvObjectBox+\dp\hvObjectBox}{%
             \abovecaptionskip=0pt% local inside parbox
             \belowcaptionskip=0pt% local inside parbox
             \ifx\relax\hv@shortCap\relax
               \caption{\hv@longCap}%
             \else
               \caption[\hv@shortCap]{\hv@longCap}%
             \fi
           }}}%
           \ifx\hv@label\@empty\else\label{\hv@label-cap}\fi
         \else
           \hv@tempWidthB=\dimexpr\textwidth-\wd\hv@rightBox-\hvSet@bindCorrection+1in+\oddsidemargin-\hv@floatCapSep\relax
           \hspace{\hv@floatCapSep}%
           \rlap{\parbox[b][\dimexpr\ht\hv@rightBox+\dp\hv@rightBox][\hv@@capVPos]{\hv@tempWidthB}{%
             \abovecaptionskip=0pt % local inside parbox
             \belowcaptionskip=0pt % local inside parbox
             \ifx\hv@shortCap\@empty
               \caption{\hv@longCap}%
             \else
               \caption[\hv@shortCap]{\hv@longCap}%
             \fi
           }}%
           \ifx\hv@label\@empty\else\label{\hv@label-cap}\fi
         \fi
       \else % #1 = 0 caption below
         \ifx\relax\hv@shortCap\relax
           \caption{\hv@longCap}%
         \else
           \caption[\hv@shortCap]{\hv@longCap}%
         \fi
         \ifx\hv@label\@empty\else\label{\hv@label-cap}\fi
       \fi
    \vspace{0pt}%
    \hv@reset@noverticalSpace
  \end{\hv@floatType*}
}
