/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.siunitx;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.siunitx.SIunitxSty;
import com.dickimawbooks.texparserlib.latex.siunitx.SiPer;
import java.io.IOException;

public class SIUnitCs
extends ControlSequence {
    private String notation;
    protected boolean prefix = false;
    protected SIunitxSty sty;

    public SIUnitCs(SIunitxSty sIunitxSty, String string, String string2) {
        this(sIunitxSty, string, string2, false);
    }

    public SIUnitCs(SIunitxSty sIunitxSty, String string, String string2, boolean bl) {
        super(string);
        this.notation = string2;
        this.sty = sIunitxSty;
        this.prefix = bl;
    }

    @Override
    public Object clone() {
        return new SIUnitCs(this.sty, this.getName(), this.notation, this.prefix);
    }

    public String getNotation() {
        return this.notation;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (teXParser.isMathMode()) {
            SIunitxSty.createText(teXParser, teXParser.getListener().createGroup(this.notation)).process(teXParser);
        } else {
            teXParser.getListener().getWriteable().write(this.notation);
        }
        TeXObject teXObject = teXParser.peekStack();
        if (teXObject instanceof SIUnitCs && !this.prefix || teXObject instanceof SiPer) {
            teXParser.push(this.sty.createUnitSep(teXParser));
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        if (teXParser.isMathMode()) {
            teXObject = SIunitxSty.createText(teXParser, teXParser.getListener().createGroup(this.notation));
            ((TeXObjectList)teXObject).process(teXParser, teXObjectList);
        } else {
            teXParser.getListener().getWriteable().write(this.notation);
        }
        teXObject = teXObjectList.peekStack();
        if (teXObject instanceof SIUnitCs && !this.prefix || teXObject instanceof SiPer) {
            teXObjectList.push(this.sty.createUnitSep(teXParser));
        }
    }
}

