/*
 * SOURCE:  profile.h
 * PROJECT: EasyTeX
 *
 * PURPOSE: function prototypes and defines
 *
 * UPDATES: 08/15/1991 - major rewrite
 *
 * (c)M.Schollmeyer
 */
#ifndef PROFILE_H
#define PROFILE_H

#define PROFILEMAGIC 0x2e30546cL

#define PR_INIPATH          0       // initial directory
#define PR_WORDWRAP         1
#define PR_TABSTOPS         2
#define PR_CURRFILE         3
#define PR_FLAGS            4
#define PR_FILENAME(i)     (5+i)
#define PR_VIRTFILE(i)    (25+i)
#define PR_FILEKOORDS(i)  (45+i)
#define PR_CLIPBOARDNAME   65
#define PR_SEARCHSTRING    66
#define PR_REPLACESTRING   67
#define PR_SEARCHFLAGS     68
#define PR_LASTFILE        69
#define PR_ERRORLEVEL      70
#define PR_DRIVEROPTS(i)  (71+i)
#define PR_DRIVERINTS(i)  (77+i)
#define PR_PREVIEWADD      84
#define PR_PREVIEWCOMMAND  85
#define PR_TEXFLAGS        86
#define PR_TEXDEFDRIVE     87
#define PR_PRINTSTANDALONE 88

#define PR_FILEMASK        89
#define PR_TEXCOMMAND      90

#define PR_PERISAV         91
#define PR_TEXLASTFILE     92       /* Here, the file name of the last file
                                       beeing converted by TeX is stored. This
                                       name is used by the error check
                                       algorithm as the project file name */
#define PR_TEXCWD          93       /* Since files in the logfile of TeX can
                                       have no path (means in the current dir)
                                       we have to store the current dir for
                                       such references */

#define PR_PSCRIPTOUTPUT   94
#define PR_PSCRIPTADD      95
#define PR_PSCRIPTCMD      102

#define PR_DOSCOMMAND      96
#define PR_MACROS(i)      (97+i)
#define PR_DOSREQOPTS     101

#define PR_CUSTOMCMD(i)  (103+4*(i))
#define PR_CUSTOMOPT(i)  (104+4*(i))
#define PR_CUSTOMNAME(i) (105+4*(i))
#define PR_CUSTOMFLAGS(i) (106+4*(i))
#define PR_MAXCUSTOM       14

#define PR_TMPTEXFILES    204
#define PR_RESPONSEFILE   164

    // page options
#define PR_P_HEIGHT    165
#define PR_P_WIDTH     166
#define PR_P_LMARGIN   167
#define PR_P_LMADJ     168
#define PR_P_TMARGIN   169
#define PR_P_TMADJ     170
#define PR_P_TRANS     171
#define PR_P_FIRST     172
#define PR_P_PAGES     173
#define PR_P_INDEX     174
#define PR_P_BEGIN     175
#define PR_P_END       176
#define PR_P_SKIP      177
#define PR_P_NUMBER    178
#define PR_P_FLAGS     179

#define PR_PRINTADD        180
#define PR_PRINTCOMMAND    181
#define PR_PRINTOUTPUT     182
#define PR_PRINTREPEAT     183
#define PR_PRINTPOSTREP    184
#define PR_PRINTFLAGS      190

#define PR_PREVIEWHP      191
#define PR_PREVIEWVP      192
#define PR_PREVIEWGX      193
#define PR_PREVIEWGY      194
#define PR_PREVIEWADAPTER 195
#define PR_PREVIEWCOLORS  196
#define PR_PREVIEWUNIT    197
#define PR_PREVIEWSX      198
#define PR_PREVIEWSY      199

#define PR_PREVIEWFLAGS   200
#define PR_ENVIRONMENT    201   // obsolete

#define PR_VIDEOMODE      202
#define PR_INITVMODE      203

#define PR_PALETTE        205

#define MAXPROFILEENTRIES 207

extern unsigned int virtfiles[];

    // default value for GetProfileData()
extern long profnull;   // can be used as default to return null

#define PutProfileString(slot, c) PutProfileData( slot, c, strlen(c)+1 )
#define PutProfileInt(slot, i)    PutProfileData( slot, &i, sizeof(int) )
#define PutProfileLong(slot, l)   PutProfileData( slot, &l, sizeof(long) )
#define ClearProfileData(slot)    PutProfileData( slot, NULL, 0 )

#define GetProfileString( slot, def ) (char *)GetProfileData( slot, def )
#define GetProfileInt( slot )    *(int *)GetProfileData( slot, &profnull )
#define GetProfileLong( slot )   *(long *)GetProfileData( slot, &profnull )

        // function prototypes
BOOL GetProfile( char * );
BOOL PutProfile( char * );
void *GetProfileData( unsigned int, void * );
BOOL PutProfileData( unsigned int, void *, int );
void SwapProfileData( unsigned int, unsigned int );

#endif
